/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.mixin;

import com.cobblemon.mod.common.client.gui.pc.PCGUI;
import com.cobblemon.mod.common.client.storage.ClientBox;
import com.cobblemon.mod.common.client.storage.ClientPC;
import com.cobblemon.mod.common.client.storage.ClientParty;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PCGUI.class}, remap=false)
public abstract class MixinPCGUIEnsure {
    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void shadowedhearts$ensureOnPCOpen(CallbackInfo ci) {
        try {
            PCGUI self = (PCGUI)this;
            ClientParty party = self.getParty();
            ClientPC pc = self.getPc();
            for (Pokemon p : party.getSlots()) {
                if (p == null) continue;
                PokemonAspectUtil.ensureRequiredShadowAspects(p);
            }
            for (ClientBox box : pc.getBoxes()) {
                for (Pokemon p : box.getSlots()) {
                    if (p == null) continue;
                    PokemonAspectUtil.ensureRequiredShadowAspects(p);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

