/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.mixin;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.InBattleGimmickMove;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.ShowdownPokemon;
import com.cobblemon.mod.common.battles.ShowdownSide;
import com.cobblemon.mod.common.battles.interpreter.instructions.RequestInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.ShadowGate;
import java.util.List;
import java.util.UUID;
import kotlin.Unit;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RequestInstruction.class}, remap=false)
public abstract class MixinRequestInstruction {
    @Shadow
    public abstract BattleActor getBattleActor();

    @Inject(method={"invoke$lambda$0"}, at={@At(value="INVOKE", target="Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;sendUpdate(Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", shift=At.Shift.BEFORE)})
    private static void shadowedhearts$disableNonShadowMovesAtInvoke(RequestInstruction this$0, ShowdownActionRequest $request, PokemonBattle $battle, CallbackInfoReturnable<Unit> cir) {
        List reqMovesets = $request.getActive();
        if (reqMovesets == null) {
            return;
        }
        BattleActor actor = this$0.getBattleActor();
        if (actor.getType() != ActorType.PLAYER) {
            return;
        }
        ShowdownSide requestSide = $request.getSide();
        if (requestSide == null || requestSide.getPokemon() == null) {
            return;
        }
        List<ShowdownPokemon> activeInRequest = requestSide.getPokemon().stream().filter(ShowdownPokemon::getActive).toList();
        for (int i = 0; i < Math.min(activeInRequest.size(), reqMovesets.size()); ++i) {
            ShowdownMoveset moveset;
            Pokemon effected;
            ShowdownPokemon showdownPokemon = activeInRequest.get(i);
            UUID pokemonUuid = showdownPokemon.getUuid();
            BattlePokemon battlePokemon = actor.getPokemonList().stream().filter(p -> p.getUuid().equals(pokemonUuid)).findFirst().orElse(null);
            if (battlePokemon == null || !ShadowGate.isShadowLocked(effected = battlePokemon.getEffectedPokemon()) || (moveset = (ShowdownMoveset)reqMovesets.get(i)) == null || moveset.getMoves() == null) continue;
            int allowed = PokemonAspectUtil.getAllowedVisibleNonShadowMoves(effected);
            int nonShadowIndex = 0;
            for (InBattleMove m : moveset.getMoves()) {
                if (m == null) continue;
                String id = m.getId();
                boolean forced = m.getMaxpp() == 100 && m.getPp() == 100;
                if (forced || "struggle".equalsIgnoreCase(id) || ShadowGate.isShadowMoveId(id)) continue;
                if (nonShadowIndex >= allowed) {
                    m.setDisabled(true);
                    InBattleGimmickMove gm = m.getGimmickMove();
                    if (gm != null) {
                        gm.setDisabled(true);
                    }
                }
                ++nonShadowIndex;
            }
        }
    }
}

