/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.network;

import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.core.ModBlocks;
import com.jayemceekay.shadowedhearts.core.ModPoiTypes;
import com.jayemceekay.shadowedhearts.network.MeteoroidScanRequestHandler;
import com.jayemceekay.shadowedhearts.network.MeteoroidScanRequestPacket;
import com.jayemceekay.shadowedhearts.network.MeteoroidScanResultPacket;
import com.jayemceekay.shadowedhearts.network.ShadowedHeartsNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J+\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/jayemceekay/shadowedhearts/network/MeteoroidScanRequestHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/jayemceekay/shadowedhearts/network/MeteoroidScanRequestPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "player", "", "handle", "(Lcom/jayemceekay/shadowedhearts/network/MeteoroidScanRequestPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;)V", "Lnet/minecraft/class_3218;", "level", "Lnet/minecraft/class_2338;", "origin", "", "radius", "", "hasAnyMeteoroidBlock", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;I)Z", "", "positions", "clusterPositions", "(Ljava/util/List;I)Ljava/util/List;", "ShadowedHearts-common"})
@SourceDebugExtension(value={"SMAP\nMeteoroidScanRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeteoroidScanRequestHandler.kt\ncom/jayemceekay/shadowedhearts/network/MeteoroidScanRequestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n774#2:103\n865#2,2:104\n*S KotlinDebug\n*F\n+ 1 MeteoroidScanRequestHandler.kt\ncom/jayemceekay/shadowedhearts/network/MeteoroidScanRequestHandler\n*L\n37#1:103\n37#1:104,2\n*E\n"})
public final class MeteoroidScanRequestHandler
implements ServerNetworkPacketHandler<MeteoroidScanRequestPacket> {
    @NotNull
    public static final MeteoroidScanRequestHandler INSTANCE = new MeteoroidScanRequestHandler();

    private MeteoroidScanRequestHandler() {
    }

    /*
     * WARNING - void declaration
     */
    public void handle(@NotNull MeteoroidScanRequestPacket packet, @NotNull MinecraftServer server, @NotNull class_3222 player) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_3218 class_32182 = player.method_51469();
        Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"serverLevel(...)");
        class_3218 level = class_32182;
        int maxRange = ShadowedHeartsConfigs.getInstance().getShadowConfig().auraScannerMeteoroidRange();
        int range = RangesKt.coerceIn((int)packet.getRange(), (int)8, (int)maxRange);
        class_2338 center = player.method_24515();
        class_4153 class_41532 = level.method_19494();
        Intrinsics.checkNotNullExpressionValue((Object)class_41532, (String)"getPoiManager(...)");
        class_4153 poiManager = class_41532;
        class_4158 poiType = (class_4158)ModPoiTypes.SHADOWFALL_METEOROID.get();
        Stream stream = poiManager.method_19125(arg_0 -> MeteoroidScanRequestHandler.handle$lambda$0(poiType, arg_0), center, range, class_4153.class_4155.field_18489);
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"getInRange(...)");
        Stream stream2 = stream;
        List list = stream2.map(arg_0 -> MeteoroidScanRequestHandler.handle$lambda$1(handle.poiPositions.1.INSTANCE, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        List poiPositions2 = list;
        Iterable $this$filter$iv = poiPositions2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_2338 pos = (class_2338)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.hasAnyMeteoroidBlock(level, pos, 3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validPositions = (List)destination$iv$iv;
        List<class_2338> centers = this.clusterPositions(validPositions, 3);
        ShadowedHeartsNetwork.sendToPlayer(player, new MeteoroidScanResultPacket(centers));
    }

    private final boolean hasAnyMeteoroidBlock(class_3218 level, class_2338 origin, int radius) {
        class_2248 block = (class_2248)ModBlocks.SHADOWFALL_METEOROID.get();
        int dx = -radius;
        if (dx <= radius) {
            while (true) {
                int dy;
                if ((dy = -radius) <= radius) {
                    while (true) {
                        int dz;
                        if ((dz = -radius) <= radius) {
                            while (true) {
                                class_2338 p;
                                if (level.method_8320(p = origin.method_10069(dx, dy, dz)).method_27852(block)) {
                                    return true;
                                }
                                if (dz == radius) break;
                                ++dz;
                            }
                        }
                        if (dy == radius) break;
                        ++dy;
                    }
                }
                if (dx == radius) break;
                ++dx;
            }
        }
        return false;
    }

    private final List<class_2338> clusterPositions(List<? extends class_2338> positions, int radius) {
        Set remaining = CollectionsKt.toMutableSet((Iterable)positions);
        List out = new ArrayList();
        int r2 = radius * radius;
        while (!((Collection)remaining).isEmpty()) {
            class_2338 start = (class_2338)CollectionsKt.first((Iterable)remaining);
            remaining.remove(start);
            long sumX = 0L;
            long sumY = 0L;
            long sumZ = 0L;
            int count = 0;
            ArrayDeque queue = new ArrayDeque();
            queue.add((Object)start);
            Set visited = new LinkedHashSet();
            visited.add(start);
            block1: while (!((Collection)queue).isEmpty()) {
                class_2338 cur = (class_2338)queue.removeFirst();
                sumX += (long)cur.method_10263();
                sumY += (long)cur.method_10264();
                sumZ += (long)cur.method_10260();
                ++count;
                int dx = -radius;
                if (dx > radius) continue;
                while (true) {
                    int dy;
                    if ((dy = -radius) <= radius) {
                        while (true) {
                            int dz;
                            if ((dz = -radius) <= radius) {
                                while (true) {
                                    class_2338 n;
                                    int d2;
                                    if ((d2 = dx * dx + dy * dy + dz * dz) <= r2 && !visited.contains(n = cur.method_10069(dx, dy, dz)) && remaining.contains(n)) {
                                        Intrinsics.checkNotNull((Object)n);
                                        visited.add(n);
                                        remaining.remove(n);
                                        queue.add((Object)n);
                                    }
                                    if (dz == radius) break;
                                    ++dz;
                                }
                            }
                            if (dy == radius) break;
                            ++dy;
                        }
                    }
                    if (dx == radius) continue block1;
                    ++dx;
                }
            }
            if (count <= 0) continue;
            int cx = MathKt.roundToInt((double)((double)sumX / (double)count));
            int cy = MathKt.roundToInt((double)((double)sumY / (double)count));
            int cz = MathKt.roundToInt((double)((double)sumZ / (double)count));
            out.add(new class_2338(cx, cy, cz));
        }
        return out;
    }

    private static final boolean handle$lambda$0(class_4158 $poiType, class_6880 holder) {
        return Intrinsics.areEqual((Object)holder.comp_349(), (Object)$poiType);
    }

    private static final class_2338 handle$lambda$1(Function1 $tmp0, Object p0) {
        return (class_2338)$tmp0.invoke(p0);
    }
}

