/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.network;

import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.jayemceekay.shadowedhearts.config.ISnagConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.items.SnagMachineItem;
import com.jayemceekay.shadowedhearts.network.ShadowedHeartsNetwork;
import com.jayemceekay.shadowedhearts.network.SnagArmPacket;
import com.jayemceekay.shadowedhearts.network.SnagArmedPacket;
import com.jayemceekay.shadowedhearts.snag.PlayerSnagData;
import com.jayemceekay.shadowedhearts.snag.SimplePlayerSnagData;
import com.jayemceekay.shadowedhearts.snag.SnagBattleUtil;
import com.jayemceekay.shadowedhearts.snag.SnagCaps;
import com.jayemceekay.shadowedhearts.snag.SnagEnergy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jayemceekay/shadowedhearts/network/SnagArmHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/jayemceekay/shadowedhearts/network/SnagArmPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "player", "", "handle", "(Lcom/jayemceekay/shadowedhearts/network/SnagArmPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;)V", "ShadowedHearts-common"})
public final class SnagArmHandler
implements ServerNetworkPacketHandler<SnagArmPacket> {
    @NotNull
    public static final SnagArmHandler INSTANCE = new SnagArmHandler();

    private SnagArmHandler() {
    }

    public void handle(@NotNull SnagArmPacket packet, @NotNull MinecraftServer server, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerSnagData cap = SnagCaps.get((class_1657)player);
        if (!cap.hasSnagMachine()) {
            return;
        }
        if (cap.cooldown() > 0) {
            return;
        }
        boolean requestArmed = packet.getArmed();
        if (requestArmed) {
            class_1799 machineStack;
            if (!SnagBattleUtil.isInTrainerBattle((class_1657)player) && !SnagBattleUtil.hasEligibleShadowOpponent((class_1657)player)) {
                return;
            }
            class_1799 class_17992 = machineStack = cap instanceof SimplePlayerSnagData ? ((SimplePlayerSnagData)cap).getMachineStack() : class_1799.field_8037;
            if (!machineStack.method_7960() && machineStack.method_7909() instanceof SnagMachineItem) {
                class_1792 class_17922 = machineStack.method_7909();
                Intrinsics.checkNotNull((Object)class_17922, (String)"null cannot be cast to non-null type com.jayemceekay.shadowedhearts.items.SnagMachineItem");
                SnagMachineItem sm = (SnagMachineItem)class_17922;
                SnagEnergy.ensureInitialized(machineStack, sm.capacity());
                int currentEnergy = SnagCaps.get((class_1657)player).energy();
                ISnagConfig cfg = ShadowedHeartsConfigs.getInstance().getSnagConfig();
                int required = cfg.energyPerAttempt();
                if (currentEnergy < required) {
                    cap.setCooldown(cfg.toggleCooldownTicks());
                    Object[] objectArray = new Object[]{currentEnergy, required};
                    player.method_43496((class_2561)class_2561.method_43469((String)"message.shadowedhearts.snag_machine.not_enough_energy", (Object[])objectArray));
                    return;
                }
                cap.setArmed(true);
                cap.setCooldown(cfg.toggleCooldownTicks());
                ShadowedHeartsNetwork.sendToPlayer(player, new SnagArmedPacket(true));
            }
        } else {
            ISnagConfig cfg = ShadowedHeartsConfigs.getInstance().getSnagConfig();
            cap.setArmed(false);
            cap.setCooldown(cfg.toggleCooldownTicks());
            ShadowedHeartsNetwork.sendToPlayer(player, new SnagArmedPacket(false));
        }
    }
}

