/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.network.purification.server;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.network.purification.MovePurificationToPCPacket;
import com.jayemceekay.shadowedhearts.storage.purification.PurificationChamberPosition;
import com.jayemceekay.shadowedhearts.storage.purification.PurificationChamberStore;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jayemceekay/shadowedhearts/network/purification/server/MovePurificationToPCHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/jayemceekay/shadowedhearts/network/purification/MovePurificationToPCPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "player", "", "handle", "(Lcom/jayemceekay/shadowedhearts/network/purification/MovePurificationToPCPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;)V", "ShadowedHearts-common"})
public final class MovePurificationToPCHandler
implements ServerNetworkPacketHandler<MovePurificationToPCPacket> {
    @NotNull
    public static final MovePurificationToPCHandler INSTANCE = new MovePurificationToPCHandler();

    private MovePurificationToPCHandler() {
    }

    public void handle(@NotNull MovePurificationToPCPacket packet, @NotNull MinecraftServer server, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PCStore pc = Cobblemon.INSTANCE.getStorage().getPC(player);
        class_5455 registryAccess = player.method_56673();
        PokemonStoreManager pokemonStoreManager = Cobblemon.INSTANCE.getStorage();
        UUID uUID = packet.getPurificationStoreID();
        Intrinsics.checkNotNull((Object)registryAccess);
        PurificationChamberStore purificationChamberStore = (PurificationChamberStore)pokemonStoreManager.getCustomStore(PurificationChamberStore.class, uUID, registryAccess);
        if (purificationChamberStore == null) {
            MovePurificationToPCHandler $this$handle_u24lambda_u240 = this;
            boolean bl = false;
            return;
        }
        PurificationChamberStore purification = purificationChamberStore;
        boolean isShadow = packet.getFromIndex() == 0;
        int supportIdx = RangesKt.coerceAtLeast((int)(packet.getFromIndex() - 1), (int)0);
        PurificationChamberPosition from = new PurificationChamberPosition(packet.getSetIndex(), isShadow ? 0 : supportIdx, isShadow);
        Pokemon pokemon = purification.get(from);
        if (pokemon == null) {
            return;
        }
        Pokemon fromMon = pokemon;
        Pokemon destMon = pc.get(packet.getPcPosition());
        if (destMon == null) {
            boolean removed = purification.remove(from);
            if (!removed) {
                return;
            }
            pc.set(packet.getPcPosition(), fromMon);
        } else {
            boolean destIsShadow = PokemonAspectUtil.hasShadowAspect(destMon);
            if (from.isShadow() == destIsShadow) {
                purification.set(from, destMon);
                pc.set(packet.getPcPosition(), fromMon);
            } else {
                return;
            }
        }
    }
}

