/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.pokemon.properties;

import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.ShadowService;
import java.util.concurrent.ThreadLocalRandom;

public final class ShadowChanceProperty
implements CustomPokemonProperty {
    private final int percent;

    public ShadowChanceProperty(int percent) {
        if (percent < 0) {
            percent = 0;
        }
        if (percent > 100) {
            percent = 100;
        }
        this.percent = percent;
    }

    public void apply(Pokemon pokemon) {
        if (this.percent <= 0) {
            return;
        }
        if (this.percent >= 100 || ShadowChanceProperty.roll(this.percent)) {
            ShadowService.setShadow(pokemon, null, true, true);
        }
    }

    public void apply(PokemonEntity pokemonEntity) {
        if (pokemonEntity != null) {
            this.apply(pokemonEntity.getPokemon());
        }
    }

    public String asString() {
        return "sh_shadow_chance=" + this.percent;
    }

    public boolean matches(Pokemon pokemon) {
        return false;
    }

    private static boolean roll(int percent) {
        int r = ThreadLocalRandom.current().nextInt(100);
        return r < percent;
    }
}

