/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.pokemon.properties.type;

import com.cobblemon.mod.common.api.properties.CustomPokemonPropertyType;
import com.jayemceekay.shadowedhearts.pokemon.properties.ShadowChanceProperty;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class ShadowChancePropertyType
implements CustomPokemonPropertyType<ShadowChanceProperty> {
    private static final Set<String> KEYS = Set.of("sh_shadow_chance");

    public Iterable<String> getKeys() {
        return KEYS;
    }

    public boolean getNeedsKey() {
        return true;
    }

    public ShadowChanceProperty fromString(String value) {
        if (value == null) {
            return null;
        }
        String s = value.trim();
        if (s.isEmpty()) {
            return null;
        }
        try {
            double d;
            if (s.endsWith("%")) {
                s = s.substring(0, s.length() - 1).trim();
            }
            int percent = s.contains(".") ? ((d = Double.parseDouble(s)) <= 1.0 ? (int)Math.round(d * 100.0) : (int)Math.round(d)) : Integer.parseInt(s);
            percent = Math.max(0, Math.min(100, percent));
            return new ShadowChanceProperty(percent);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Collection<String> examples() {
        return List.of("25", "25%", "0.25");
    }
}

