/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.restrictions;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.mixin.AccessorCancelable;
import kotlin.Unit;

public final class ShadowRestrictions {
    private ShadowRestrictions() {
    }

    public static void init() {
        CobblemonEvents.EVOLUTION_ACCEPTED.subscribe(Priority.NORMAL, event -> {
            Pokemon pokemon = event.getPokemon();
            if (pokemon == null) {
                return Unit.INSTANCE;
            }
            if (PokemonAspectUtil.hasShadowAspect(pokemon)) {
                event.cancel();
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_NICKNAMED.subscribe(Priority.NORMAL, e -> {
            Pokemon pokemon = e.getPokemon();
            if (pokemon == null) {
                return Unit.INSTANCE;
            }
            if (PokemonAspectUtil.hasShadowAspect(pokemon)) {
                e.cancel();
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.TRADE_EVENT_PRE.subscribe(Priority.NORMAL, pre -> {
            Pokemon p1 = pre.getTradeParticipant1Pokemon();
            Pokemon p2 = pre.getTradeParticipant2Pokemon();
            if (p1 != null && PokemonAspectUtil.hasShadowAspect(p1) || p2 != null && PokemonAspectUtil.hasShadowAspect(p2)) {
                pre.cancel();
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.THROWN_POKEBALL_HIT.subscribe(Priority.LOW, event -> {
            if (event.isCanceled() && PokemonAspectUtil.hasShadowAspect(event.getPokemon().getPokemon())) {
                ((AccessorCancelable)event).setCanceled(false);
            }
            return Unit.INSTANCE;
        });
    }
}

