/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.server;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.network.ShadowedHeartsNetworkingUtils;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Unit;
import net.minecraft.class_1297;

public final class AuraServerSync {
    private static final Map<Integer, WeakReference<PokemonEntity>> TRACKING = new ConcurrentHashMap<Integer, WeakReference<PokemonEntity>>();

    private AuraServerSync() {
    }

    public static void init() {
        CobblemonEvents.POKEMON_SENT_POST.subscribe(Priority.NORMAL, e -> {
            PokemonEntity pe = e.getPokemonEntity();
            if (pe == null || pe.method_37908().method_8608()) {
                return Unit.INSTANCE;
            }
            try {
                Pokemon p = pe.getPokemon();
                PokemonAspectUtil.ensureRequiredShadowAspects(p);
                if (!PokemonAspectUtil.hasShadowAspect(p)) {
                    return Unit.INSTANCE;
                }
            }
            catch (Exception ex) {
                return Unit.INSTANCE;
            }
            TRACKING.put(pe.method_5628(), new WeakReference<PokemonEntity>(pe));
            ShadowedHeartsNetworkingUtils.broadcastAuraStartToTracking((class_1297)pe);
            ShadowedHeartsNetworkingUtils.broadcastLuminousMoteToTracking((class_1297)pe);
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.LOWEST, e -> {
            PokemonEntity pe = (PokemonEntity)e.getEntity();
            if (pe == null || pe.method_37908().method_8608()) {
                return Unit.INSTANCE;
            }
            if (PokemonAspectUtil.hasShadowAspect(pe.getPokemon())) {
                TRACKING.put(pe.method_5628(), new WeakReference<PokemonEntity>(pe));
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_RECALL_PRE.subscribe(Priority.NORMAL, e -> {
            PokemonEntity pe = e.getOldEntity();
            if (pe == null || pe.method_37908().method_8608()) {
                return Unit.INSTANCE;
            }
            TRACKING.remove(pe.method_5628());
            ShadowedHeartsNetworkingUtils.broadcastAuraFadeOutToTracking((class_1297)pe, 10);
            return Unit.INSTANCE;
        });
    }
}

