/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.server;

import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSentEvent;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.jayemceekay.shadowedhearts.heart.HeartGaugeEvents;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003R&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jayemceekay/shadowedhearts/server/BattleSentOnceListener;", "", "<init>", "()V", "", "init", "", "Ljava/util/UUID;", "", "seenByBattle", "Ljava/util/Map;", "ShadowedHearts-common"})
public final class BattleSentOnceListener {
    @NotNull
    public static final BattleSentOnceListener INSTANCE = new BattleSentOnceListener();
    @NotNull
    private static final Map<UUID, Set<UUID>> seenByBattle = new ConcurrentHashMap();

    private BattleSentOnceListener() {
    }

    public final void init() {
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.POKEMON_SENT_POST), null, BattleSentOnceListener::init$lambda$2, (int)1, null);
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.BATTLE_VICTORY), null, BattleSentOnceListener::init$lambda$3, (int)1, null);
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.BATTLE_FLED), null, BattleSentOnceListener::init$lambda$4, (int)1, null);
    }

    private static final Set init$lambda$2$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConcurrentHashMap.newKeySet();
    }

    private static final Set init$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Unit init$lambda$2(PokemonSentEvent.Post ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        PokemonEntity entity = ev.getPokemonEntity();
        UUID uUID = entity.getBattleId();
        if (uUID == null) {
            return Unit.INSTANCE;
        }
        UUID battleId = uUID;
        UUID pokemonUUID = ev.getPokemon().getUuid();
        Set set = seenByBattle.computeIfAbsent(battleId, arg_0 -> BattleSentOnceListener.init$lambda$2$lambda$1(BattleSentOnceListener::init$lambda$2$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        Set set2 = set;
        Intrinsics.checkNotNull((Object)pokemonUUID);
        boolean firstTime = set2.add(pokemonUUID);
        if (firstTime) {
            HeartGaugeEvents.onBattleSentOut(entity);
        }
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$3(BattleVictoryEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        seenByBattle.remove(ev.getBattle().getBattleId());
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$4(BattleFledEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        seenByBattle.remove(ev.getBattle().getBattleId());
        return Unit.INSTANCE;
    }
}

