/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.server;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.api.pokemon.evolution.PreEvolution;
import com.cobblemon.mod.common.api.pokemon.requirement.Requirement;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.properties.UncatchableProperty;
import com.cobblemon.mod.common.pokemon.requirements.LevelRequirement;
import com.jayemceekay.shadowedhearts.AspectHolder;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.Shadowedhearts;
import com.jayemceekay.shadowedhearts.config.ModConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.data.ShadowAspectPresets;
import com.jayemceekay.shadowedhearts.data.ShadowPools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public final class NPCShadowInjector {
    public static final String TAG_ENABLE = "sh_shadow_party";
    public static final String TAG_MODE_CONVERT = "sh_shadow_mode_convert";
    public static final String TAG_MODE_APPEND = "sh_shadow_mode_append";
    public static final String TAG_MODE_REPLACE = "sh_shadow_mode_replace";
    public static final String TAG_COUNT_PREFIX = "sh_shadow_n";
    public static final String TAG_LVL_MATCH = "sh_lvl_match";
    public static final String TAG_LVL_FIXED_PREFIX = "sh_lvl_fixed_";
    public static final String TAG_LVL_PLUS_PREFIX = "sh_lvl_plus_";
    public static final String TAG_POOL_PREFIX = "sh_pool/";
    public static final String TAG_UNIQUE = "sh_unique";
    public static final String TAG_CONVERT_CHANCE_PREFIX = "sh_convert_chance_";
    public static final String TAG_PRESET_PREFIX = "sh_shadow_presets/";
    public static final String TAG_LVL_ENFORCE_EVO_MIN = "sh_lvl_enforce_evo_min";
    private static final int PARTY_MAX = 6;
    private static final String[] SHADOW_IDS = new String[]{"shadowblast", "shadowblitz", "shadowbolt", "shadowbreak", "shadowchill", "shadowdown", "shadowend", "shadowfire", "shadowhalf", "shadowhold", "shadowmist", "shadowpanic", "shadowrave", "shadowrush", "shadowshed", "shadowsky", "shadowstorm", "shadowwave"};

    private NPCShadowInjector() {
    }

    public static void init() {
        CobblemonEvents.BATTLE_STARTED_PRE.subscribe(Priority.NORMAL, event -> {
            try {
                event.getBattle().getActors().forEach(ba -> {
                    if (ba instanceof EntityBackedBattleActor) {
                        EntityBackedBattleActor ebActor = (EntityBackedBattleActor)ba;
                        long battleSalt = 0L;
                        try {
                            UUID bid = event.getBattle().getBattleId();
                            if (bid != null) {
                                battleSalt = bid.getLeastSignificantBits();
                            }
                        }
                        catch (Throwable bid) {
                            // empty catch block
                        }
                        class_1309 entity = ebActor.getEntity();
                        if (ebActor.getEntity() instanceof PokemonEntity) {
                            return;
                        }
                        NPCShadowInjector.expandPresetAspects((class_1297)entity);
                        HashSet<String> allTraits = new HashSet<String>(entity.method_5752());
                        if (entity instanceof AspectHolder) {
                            AspectHolder holder = (AspectHolder)entity;
                            allTraits.addAll(holder.shadowedhearts$getAspects());
                        }
                        if (!allTraits.contains(TAG_ENABLE)) {
                            return;
                        }
                        int count = NPCShadowInjector.readCountFromTags(allTraits);
                        if (count <= 0) {
                            return;
                        }
                        Mode mode = NPCShadowInjector.readMode(allTraits);
                        LevelPolicy lvl = NPCShadowInjector.readLevelPolicy(allTraits, ba);
                        class_2960 poolId = NPCShadowInjector.readPoolId(allTraits);
                        boolean unique = allTraits.contains(TAG_UNIQUE);
                        int convertChance = NPCShadowInjector.readConvertChance(allTraits);
                        boolean enforceMinEvo = allTraits.contains(TAG_LVL_ENFORCE_EVO_MIN);
                        Shadowedhearts.LOGGER.info("Processing actor: " + ba.getName().getString() + " | Mode: " + String.valueOf((Object)mode) + " | Count: " + count + " | Unique: " + unique);
                        switch (mode.ordinal()) {
                            case 1: {
                                NPCShadowInjector.convertExistingToShadow(ba.getPokemonList(), count, convertChance, NPCShadowInjector.makeRng((class_1297)entity, battleSalt));
                                break;
                            }
                            case 0: {
                                NPCShadowInjector.appendShadowPokemon(ba, (class_1297)entity, count, lvl, poolId, unique, enforceMinEvo, battleSalt);
                                break;
                            }
                            case 2: {
                                NPCShadowInjector.replaceWithShadowPokemon(ba, (class_1297)entity, count, lvl, poolId, unique, enforceMinEvo, battleSalt);
                            }
                        }
                    }
                });
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
            return Unit.INSTANCE;
        });
    }

    private static void expandPresetAspects(class_1297 entity) {
        try {
            MinecraftServer server = entity.method_37908().method_8503();
            if (server == null) {
                return;
            }
            HashSet<String> aspectsToProcess = new HashSet<String>();
            if (entity instanceof AspectHolder) {
                AspectHolder holder = (AspectHolder)entity;
                aspectsToProcess.addAll(holder.shadowedhearts$getAspects());
            }
            ArrayList<String> toRemove = new ArrayList<String>();
            ArrayList<String> toAdd = new ArrayList<String>();
            for (String aspect : aspectsToProcess) {
                class_2960 id;
                if (!ShadowAspectPresets.isPresetKey(aspect) || (id = ShadowAspectPresets.toPresetId(aspect)) == null) continue;
                List<String> list = ShadowAspectPresets.get(server, id);
                if (!list.isEmpty()) {
                    toAdd.addAll(list);
                    Shadowedhearts.LOGGER.info("Expanded aspect preset {} into {} tags", (Object)id, (Object)list.size());
                } else {
                    Shadowedhearts.LOGGER.warn("Aspect preset {} was empty or not found", (Object)id);
                }
                toRemove.add(aspect);
            }
            for (String tag : entity.method_5752()) {
                String presetId;
                if (!tag.startsWith(TAG_PRESET_PREFIX) || (presetId = tag.substring(TAG_PRESET_PREFIX.length())).isBlank()) continue;
                String presetKey = tag;
                if (!ShadowAspectPresets.isPresetKey(presetKey)) {
                    Shadowedhearts.LOGGER.warn("Not a valid preset key: " + presetKey);
                    continue;
                }
                class_2960 id = ShadowAspectPresets.toPresetId(presetKey);
                if (id == null) {
                    Shadowedhearts.LOGGER.warn("Failed to convert tag to preset ID: " + tag);
                    continue;
                }
                List<String> list = ShadowAspectPresets.get(server, id);
                if (!list.isEmpty()) {
                    toAdd.addAll(list);
                    Shadowedhearts.LOGGER.info("Expanded preset {} into {} tags", (Object)id, (Object)list.size());
                } else {
                    Shadowedhearts.LOGGER.warn("Preset {} was empty or not found", (Object)id);
                }
                toRemove.add(tag);
            }
            if (!toRemove.isEmpty() || !toAdd.isEmpty()) {
                if (entity instanceof AspectHolder) {
                    AspectHolder holder = (AspectHolder)entity;
                    HashSet<String> current = new HashSet<String>(holder.shadowedhearts$getAspects());
                    current.removeAll(toRemove);
                    current.addAll(toAdd);
                    holder.shadowedhearts$setAspects(current);
                } else {
                    for (String r : toRemove) {
                        entity.method_5738(r);
                    }
                    for (String a : toAdd) {
                        entity.method_5780(a);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int readCountFromTags(Set<String> tags) {
        int count = 1;
        for (int i = 6; i >= 1; --i) {
            String key = TAG_COUNT_PREFIX + i;
            if (!tags.contains(key)) continue;
            count = i;
            break;
        }
        return count;
    }

    private static Mode readMode(Set<String> tags) {
        if (tags.contains(TAG_MODE_APPEND)) {
            return Mode.APPEND;
        }
        if (tags.contains(TAG_MODE_REPLACE)) {
            return Mode.REPLACE;
        }
        return Mode.CONVERT;
    }

    private static void convertExistingToShadow(List<BattlePokemon> list, int count, int convertChance, Random rng) {
        if (list.isEmpty() || count <= 0) {
            return;
        }
        ArrayList<Integer> eligibleIndices = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            Pokemon p;
            BattlePokemon bp = list.get(i);
            if (bp == null || (p = bp.getEffectedPokemon()) == null || p.getAspects().contains("shadowedhearts:shadow")) continue;
            eligibleIndices.add(i);
        }
        if (eligibleIndices.isEmpty()) {
            return;
        }
        if (rng != null) {
            Collections.shuffle(eligibleIndices, rng);
        }
        int converted = 0;
        Iterator iterator2 = eligibleIndices.iterator();
        while (iterator2.hasNext()) {
            int roll;
            int idx = (Integer)iterator2.next();
            BattlePokemon bp = list.get(idx);
            Pokemon p = bp.getEffectedPokemon();
            if (convertChance >= 0 && rng != null && (roll = rng.nextInt(100)) >= convertChance) continue;
            NPCShadowInjector.forceShadow(p);
            p.setOriginalTrainer("?????");
            PokemonAspectUtil.ensureRequiredShadowAspects(p);
            NPCShadowInjector.assignShadowMoves(p, rng);
            if (++converted < count) continue;
            break;
        }
    }

    private static LevelPolicy readLevelPolicy(Set<String> tags, BattleActor actor) {
        int base = 0;
        try {
            Pokemon p;
            if (!actor.getPokemonList().isEmpty() && actor.getPokemonList().get(0) != null && (p = ((BattlePokemon)actor.getPokemonList().get(0)).getEffectedPokemon()) != null) {
                base = p.getLevel();
            }
        }
        catch (Throwable p) {
            // empty catch block
        }
        int fixed = NPCShadowInjector.scanNumberTag(tags, TAG_LVL_FIXED_PREFIX, -1);
        if (fixed > 0) {
            return new LevelPolicy(LevelPolicy.LevelMode.FIXED, fixed, base);
        }
        int plus = NPCShadowInjector.scanNumberTag(tags, TAG_LVL_PLUS_PREFIX, Integer.MIN_VALUE);
        if (plus != Integer.MIN_VALUE) {
            return new LevelPolicy(LevelPolicy.LevelMode.PLUS, plus, base);
        }
        return new LevelPolicy(LevelPolicy.LevelMode.MATCH, 0, base);
    }

    private static int scanNumberTag(Set<String> tags, String prefix, int defaultVal) {
        for (String t : tags) {
            if (!t.startsWith(prefix)) continue;
            try {
                String n = t.substring(prefix.length());
                return Integer.parseInt(n);
            }
            catch (Exception exception) {
            }
        }
        return defaultVal;
    }

    private static void appendShadowPokemon(BattleActor actor, class_1297 entity, int count, LevelPolicy lvl, class_2960 poolId, boolean unique, boolean enforceMinEvo, long battleSalt) {
        List<BattlePokemon> created;
        List list = actor.getPokemonList();
        int free = 6 - list.size();
        if (free <= 0) {
            return;
        }
        int toAdd = Math.min(count, free);
        if (toAdd <= 0) {
            return;
        }
        if (poolId != null && !(created = NPCShadowInjector.createFromPool(actor, entity, poolId, toAdd, lvl, unique, enforceMinEvo, battleSalt)).isEmpty()) {
            for (BattlePokemon bp : created) {
                bp.setActor(actor);
                list.add(bp);
            }
            return;
        }
        int idx = 0;
        for (int i = 0; i < toAdd && !list.isEmpty(); ++i) {
            BattlePokemon source = (BattlePokemon)list.get(idx % list.size());
            ++idx;
            if (source == null || source.getEffectedPokemon() == null) continue;
            BattlePokemon clone = BattlePokemon.Companion.safeCopyOf(source.getEffectedPokemon());
            Pokemon p = clone.getEffectedPokemon();
            NPCShadowInjector.forceShadow(p);
            p.setOriginalTrainer("?????");
            int resolvedLevel = Math.max(1, lvl.resolve());
            try {
                p.setLevel(resolvedLevel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (enforceMinEvo && NPCShadowInjector.getMinEvolutionLevel(p) > p.getLevel()) {
                --i;
                continue;
            }
            PokemonAspectUtil.ensureRequiredShadowAspects(p);
            NPCShadowInjector.assignShadowMoves(p, NPCShadowInjector.makeRng(entity, battleSalt + (long)i));
            if (unique && NPCShadowInjector.speciesAlreadyPresent(list, NPCShadowInjector.safeSpeciesId(p))) {
                --i;
                continue;
            }
            clone.setActor(actor);
            list.add(clone);
        }
    }

    private static void replaceWithShadowPokemon(BattleActor actor, class_1297 entity, int count, LevelPolicy lvl, class_2960 poolId, boolean unique, boolean enforceMinEvo, long battleSalt) {
        List list = actor.getPokemonList();
        if (list.isEmpty() || count <= 0) {
            return;
        }
        Random rng = NPCShadowInjector.makeRng(entity, battleSalt);
        ArrayList<Integer> targetIndices = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            BattlePokemon bp = (BattlePokemon)list.get(i);
            if (bp == null || bp.getEffectedPokemon() == null || bp.getEffectedPokemon().getAspects().contains("shadowedhearts:shadow")) continue;
            targetIndices.add(i);
        }
        if (targetIndices.isEmpty()) {
            return;
        }
        Collections.shuffle(targetIndices, rng);
        List<BattlePokemon> poolCandidates = null;
        if (poolId != null && (poolCandidates = NPCShadowInjector.createFromPool(actor, entity, poolId, count, lvl, unique, enforceMinEvo, battleSalt)).isEmpty()) {
            Shadowedhearts.LOGGER.warn("NPC {} requested shadow pool {} but it was missing or empty; falling back to cloning team.", (Object)entity.method_5667(), (Object)poolId);
        }
        int replaced = 0;
        for (int i = 0; i < targetIndices.size() && replaced < count; ++i) {
            String speciesId;
            BattlePokemon replacement;
            int slotIdx = (Integer)targetIndices.get(i);
            BattlePokemon bp = (BattlePokemon)list.get(slotIdx);
            if (poolCandidates != null && replaced < poolCandidates.size()) {
                replacement = poolCandidates.get(replaced);
            } else {
                replacement = BattlePokemon.Companion.safeCopyOf(bp.getEffectedPokemon());
                Pokemon p = replacement.getEffectedPokemon();
                NPCShadowInjector.forceShadow(p);
                p.setOriginalTrainer("?????");
                int resolvedLevel = Math.max(1, lvl.resolve());
                try {
                    p.setLevel(resolvedLevel);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (enforceMinEvo && NPCShadowInjector.getMinEvolutionLevel(p) > p.getLevel()) continue;
                PokemonAspectUtil.ensureRequiredShadowAspects(p);
            }
            if (unique && NPCShadowInjector.speciesAlreadyPresent(list, speciesId = NPCShadowInjector.safeSpeciesId(replacement.getEffectedPokemon()))) continue;
            replacement.setActor(actor);
            list.set(slotIdx, replacement);
            ++replaced;
        }
    }

    private static void forceShadow(Pokemon p) {
        if (p == null) {
            return;
        }
        try {
            HashSet<String> mutable;
            Set forced = p.getForcedAspects();
            HashSet<String> hashSet = mutable = forced == null ? new HashSet<String>() : new HashSet(forced);
            if (!mutable.contains("shadowedhearts:shadow")) {
                mutable.add("shadowedhearts:shadow");
                p.setForcedAspects(mutable);
            }
            try {
                UncatchableProperty.INSTANCE.catchable().apply(p);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                p.updateAspects();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            HashSet<String> fallback = new HashSet<String>();
            fallback.add("shadowedhearts:shadow");
            try {
                p.setForcedAspects(fallback);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                UncatchableProperty.INSTANCE.catchable().apply(p);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                p.updateAspects();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class_2960 readPoolId(Set<String> tags) {
        for (String t : tags) {
            if (!t.startsWith(TAG_POOL_PREFIX)) continue;
            String rest = t.substring(TAG_POOL_PREFIX.length());
            try {
                if (rest.contains("/")) {
                    int slash = rest.indexOf(47);
                    String ns = rest.substring(0, slash);
                    String path = rest.substring(slash + 1);
                    return new class_2960(ns, path);
                }
                if (!rest.contains(":")) continue;
                int colon = rest.indexOf(58);
                String ns = rest.substring(0, colon);
                String path = rest.substring(colon + 1);
                return new class_2960(ns, path);
            }
            catch (Exception ignored) {
                Shadowedhearts.LOGGER.error("Invalid pool ID: " + rest);
            }
        }
        return null;
    }

    private static List<BattlePokemon> createFromPool(BattleActor actor, class_1297 entity, class_2960 poolId, int count, LevelPolicy lvl, boolean unique, boolean enforceMinEvo, long battleSalt) {
        try {
            class_1297 e = entity;
            MinecraftServer server = entity.method_37908().method_8503();
            if (server == null) {
                Shadowedhearts.LOGGER.error("Failed to create shadow pool " + String.valueOf(poolId) + " for NPC " + String.valueOf(entity.method_5667()) + " because server is null");
                return List.of();
            }
            List<ShadowPools.WeightedEntry> entries = ShadowPools.get(server, poolId);
            if (entries.isEmpty()) {
                Shadowedhearts.LOGGER.error("Failed to create shadow pool " + String.valueOf(poolId) + " for NPC " + String.valueOf(entity.method_5667()) + " because pool is empty");
                return List.of();
            }
            Random rng = NPCShadowInjector.makeRng(e, battleSalt);
            HashSet<String> present = unique ? NPCShadowInjector.collectSpeciesIds(actor.getPokemonList()) : null;
            int resolvedLevel = lvl.resolve();
            ArrayList<PokemonProperties> propsList = new ArrayList<PokemonProperties>();
            int attempts = 0;
            while (propsList.size() < count && attempts < count * 10) {
                ++attempts;
                List<PokemonProperties> pick = ShadowPools.pick(rng, entries, 1);
                if (pick.isEmpty()) break;
                PokemonProperties candidate = pick.get(0);
                PokemonProperties copy = candidate.copy();
                int levelToTest = copy.getLevel() == null || copy.getLevel() <= 0 ? resolvedLevel : copy.getLevel();
                copy.setLevel(Integer.valueOf(levelToTest));
                Pokemon testMon = copy.create();
                if (enforceMinEvo && NPCShadowInjector.getMinEvolutionLevel(testMon) > levelToTest) continue;
                if (unique) {
                    String speciesId = NPCShadowInjector.safeSpeciesId(candidate);
                    if (present.contains(speciesId)) continue;
                    present.add(speciesId);
                }
                propsList.add(candidate);
            }
            ArrayList<BattlePokemon> out = new ArrayList<BattlePokemon>();
            for (PokemonProperties props : propsList) {
                PokemonProperties copy = props.copy();
                try {
                    if (copy.getLevel() == null || copy.getLevel() <= 0) {
                        copy.setLevel(Integer.valueOf(Math.max(1, lvl.resolve())));
                    }
                }
                catch (Throwable ignored) {
                    Shadowedhearts.LOGGER.debug("Failed to set level for shadow copy, using default level 1");
                }
                Pokemon created = copy.create();
                BattlePokemon bp = BattlePokemon.Companion.safeCopyOf(created);
                Pokemon p = bp.getEffectedPokemon();
                NPCShadowInjector.forceShadow(p);
                PokemonAspectUtil.ensureRequiredShadowAspects(p);
                NPCShadowInjector.assignShadowMoves(p, NPCShadowInjector.makeRng(entity, battleSalt + (long)entries.indexOf(props)));
                p.setOriginalTrainer("?????");
                out.add(bp);
            }
            return out;
        }
        catch (Throwable t) {
            Shadowedhearts.LOGGER.error("Failed to create shadow pool " + String.valueOf(poolId) + " for NPC " + String.valueOf(entity.method_5667()), t);
            t.printStackTrace();
            return List.of();
        }
    }

    private static Random makeRng(class_1297 e, long battleSalt) {
        long worldSeed = 0L;
        class_1937 class_19372 = e.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 sl = (class_3218)class_19372;
            worldSeed = sl.method_8412();
        }
        long seed = worldSeed ^ e.method_5667().getMostSignificantBits() ^ e.method_5667().getLeastSignificantBits() ^ battleSalt;
        return new Random(seed);
    }

    private static int readConvertChance(Set<String> tags) {
        for (String t : tags) {
            if (!t.startsWith(TAG_CONVERT_CHANCE_PREFIX)) continue;
            try {
                int p = Integer.parseInt(t.substring(TAG_CONVERT_CHANCE_PREFIX.length()));
                if (p < 0) {
                    p = 0;
                }
                if (p > 100) {
                    p = 100;
                }
                return p;
            }
            catch (Exception exception) {
            }
        }
        return -1;
    }

    private static boolean speciesAlreadyPresent(List<BattlePokemon> list, String speciesId) {
        if (speciesId == null) {
            return false;
        }
        for (BattlePokemon bp : list) {
            if (bp == null || bp.getEffectedPokemon() == null || !speciesId.equalsIgnoreCase(NPCShadowInjector.safeSpeciesId(bp.getEffectedPokemon()))) continue;
            return true;
        }
        return false;
    }

    private static HashSet<String> collectSpeciesIds(List<BattlePokemon> list) {
        HashSet<String> set = new HashSet<String>();
        for (BattlePokemon bp : list) {
            String id;
            if (bp == null || bp.getEffectedPokemon() == null || (id = NPCShadowInjector.safeSpeciesId(bp.getEffectedPokemon())) == null) continue;
            set.add(id);
        }
        return set;
    }

    private static String safeSpeciesId(PokemonProperties props) {
        try {
            return props.getSpecies();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String safeSpeciesId(Pokemon p) {
        try {
            return p.getSpecies() != null ? p.getSpecies().showdownId() : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void assignShadowMoves(Pokemon pokemon, Random rng) {
        if (pokemon == null) {
            return;
        }
        if (ShadowedHeartsConfigs.getInstance().getShadowConfig().shadowMovesOnlyShadowRush()) {
            MoveTemplate tmpl = Moves.getByNameOrDummy((String)"shadowrush");
            pokemon.getMoveSet().setMove(0, tmpl.create(tmpl.getPp(), 0));
            return;
        }
        Random r = rng == null ? new Random() : rng;
        int count = ModConfig.resolveReplaceCount(r);
        ArrayList<String> pool = new ArrayList<String>(Arrays.asList(SHADOW_IDS));
        for (int i = 0; i < Math.min(count, 4); ++i) {
            String moveId;
            String string = moveId = i == 0 ? NPCShadowInjector.pickDamageShadow(pool, null, r) : NPCShadowInjector.pickShadow(pool, null, r);
            if (moveId == null) continue;
            MoveTemplate tmpl = Moves.getByNameOrDummy((String)moveId);
            pokemon.getMoveSet().setMove(i, tmpl.create(tmpl.getPp(), 0));
            pool.remove(moveId);
        }
    }

    private static String pickDamageShadow(List<String> ids, String exclude, Random rng) {
        ArrayList<String> damageMoves = new ArrayList<String>();
        for (String id : ids) {
            MoveTemplate tmpl = Moves.getByNameOrDummy((String)id);
            if (tmpl.getDamageCategory() == DamageCategories.INSTANCE.getSTATUS()) continue;
            damageMoves.add(id);
        }
        return NPCShadowInjector.pickShadow(damageMoves, exclude, rng);
    }

    private static String pickShadow(List<String> ids, String exclude, Random rng) {
        List<String> pool;
        if (ids != null) {
            pool = ids;
        } else {
            pool = new ArrayList<String>(SHADOW_IDS.length);
            for (String id : SHADOW_IDS) {
                pool.add(id);
            }
        }
        if (pool.isEmpty()) {
            return null;
        }
        Random r = rng == null ? new Random() : rng;
        int tries = 0;
        while (tries++ < 8) {
            String id = pool.get(r.nextInt(pool.size()));
            if (exclude != null && exclude.equalsIgnoreCase(id)) continue;
            return id;
        }
        return pool.get(0);
    }

    private static int getMinEvolutionLevel(Pokemon pokemon) {
        if (pokemon == null) {
            return 1;
        }
        PreEvolution preEvo = pokemon.getPreEvolution();
        if (preEvo == null) {
            return 1;
        }
        Set evolutions = preEvo.getForm().getEvolutions();
        for (Evolution evolution : evolutions) {
            for (Requirement req : evolution.getRequirements()) {
                if (!(req instanceof LevelRequirement)) continue;
                LevelRequirement levelReq = (LevelRequirement)req;
                return levelReq.getMinLevel();
            }
        }
        return 1;
    }

    private static enum Mode {
        APPEND,
        CONVERT,
        REPLACE;

    }

    private record LevelPolicy(LevelMode mode, int value, int base) {
        int resolve() {
            return switch (this.mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.base;
                case 1 -> this.value;
                case 2 -> Math.max(1, this.base + this.value);
            };
        }

        static enum LevelMode {
            MATCH,
            FIXED,
            PLUS;

        }
    }
}

