/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.server;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.platform.events.ChangeDimensionEvent;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.platform.events.ServerPlayerEvent;
import com.cobblemon.mod.common.platform.events.ServerPlayerTickEvent;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.heart.HeartGaugeEvents;
import com.jayemceekay.shadowedhearts.storage.purification.PurificationChamberStore;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\nR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jayemceekay/shadowedhearts/server/PurificationStepTracker;", "", "<init>", "()V", "", "init", "", "Ljava/util/UUID;", "Lnet/minecraft/class_243;", "lastPositions", "Ljava/util/Map;", "", "partyStepAccumulators", "", "TELEPORT_THRESHOLD_BLOCKS", "D", "MAX_STEPS_PER_TICK", "I", "ShadowedHearts-common"})
public final class PurificationStepTracker {
    @NotNull
    public static final PurificationStepTracker INSTANCE = new PurificationStepTracker();
    @NotNull
    private static final Map<UUID, class_243> lastPositions = new ConcurrentHashMap();
    @NotNull
    private static final Map<UUID, Integer> partyStepAccumulators = new ConcurrentHashMap();
    private static final double TELEPORT_THRESHOLD_BLOCKS = 64.0;
    private static final int MAX_STEPS_PER_TICK = 8;

    private PurificationStepTracker() {
    }

    public final void init() {
        Observable.subscribe$default((Observable)((Observable)PlatformEvents.SERVER_PLAYER_LOGIN), null, PurificationStepTracker::init$lambda$0, (int)1, null);
        Observable.subscribe$default((Observable)((Observable)PlatformEvents.SERVER_PLAYER_LOGOUT), null, PurificationStepTracker::init$lambda$1, (int)1, null);
        Observable.subscribe$default((Observable)((Observable)PlatformEvents.CHANGE_DIMENSION), null, PurificationStepTracker::init$lambda$2, (int)1, null);
        Observable.subscribe$default((Observable)((Observable)PlatformEvents.SERVER_PLAYER_TICK_POST), null, PurificationStepTracker::init$lambda$4, (int)1, null);
    }

    private static final Unit init$lambda$0(ServerPlayerEvent.Login ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        lastPositions.put(ev.getPlayer().method_5667(), ev.getPlayer().method_19538());
        partyStepAccumulators.put(ev.getPlayer().method_5667(), 0);
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$1(ServerPlayerEvent.Logout ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        lastPositions.remove(ev.getPlayer().method_5667());
        partyStepAccumulators.remove(ev.getPlayer().method_5667());
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$2(ChangeDimensionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        lastPositions.put(ev.getPlayer().method_5667(), ev.getPlayer().method_19538());
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$4(ServerPlayerTickEvent.Post ev) {
        PurificationChamberStore store;
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        class_3222 player = ev.getPlayer();
        if (player.method_7325()) {
            Map<UUID, class_243> map = lastPositions;
            UUID uUID = player.method_5667();
            class_243 class_2432 = player.method_19538();
            map.put(uUID, class_2432);
            return Unit.INSTANCE;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        class_243 class_2433 = player.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"position(...)");
        class_243 prev = lastPositions.put(uUID, class_2433);
        if (prev == null) {
            return Unit.INSTANCE;
        }
        class_243 cur = player.method_19538();
        double dx = cur.field_1352 - prev.field_1352;
        double dz = cur.field_1350 - prev.field_1350;
        double dy = cur.field_1351 - prev.field_1351;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        double manhattan = Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
        if (manhattan > 64.0) {
            return Unit.INSTANCE;
        }
        int steps = RangesKt.coerceAtLeast((int)((int)Math.floor(horizontalDist)), (int)0);
        if (steps <= 0) {
            return Unit.INSTANCE;
        }
        int n = 8;
        int clamped = Math.min(steps, n);
        class_5455 reg = player.method_56673();
        PokemonStoreManager pokemonStoreManager = Cobblemon.INSTANCE.getStorage();
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        Intrinsics.checkNotNull((Object)reg);
        PurificationChamberStore purificationChamberStore = store = (PurificationChamberStore)pokemonStoreManager.getCustomStore(PurificationChamberStore.class, uUID2, reg);
        if (purificationChamberStore != null) {
            purificationChamberStore.advanceSteps(clamped);
        }
        if (clamped > 0) {
            int total;
            Integer n2 = partyStepAccumulators.get(player.method_5667());
            int remainder = total = (n2 != null ? n2 : 0) + clamped;
            int intervals = remainder / 256;
            Map<UUID, Integer> map = partyStepAccumulators;
            UUID uUID3 = player.method_5667();
            Integer n3 = remainder %= 256;
            map.put(uUID3, n3);
            if (intervals > 0) {
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
                List snapshot = CollectionsKt.toList((Iterable)((Iterable)party));
                for (int i = 0; i < intervals; ++i) {
                    int it = i;
                    boolean bl = false;
                    for (Pokemon mon : snapshot) {
                        if (!PokemonAspectUtil.hasShadowAspect(mon)) continue;
                        HeartGaugeEvents.onPartyStep(mon, null);
                    }
                }
            }
        }
        return Unit.INSTANCE;
    }
}

