/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.server;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.sound.UnvalidatedPlaySoundS2CPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.ShadowService;
import com.jayemceekay.shadowedhearts.config.HeartGaugeConfig;
import com.jayemceekay.shadowedhearts.config.IWorldAlterationConfig;
import com.jayemceekay.shadowedhearts.config.ShadowSpawnConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.core.ModBlocks;
import com.jayemceekay.shadowedhearts.core.ModSounds;
import com.jayemceekay.shadowedhearts.network.ShadowedHeartsNetworkingUtils;
import com.jayemceekay.shadowedhearts.server.AuraBroadcastQueue;
import com.jayemceekay.shadowedhearts.server.WildShadowSpawnListener;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashSet;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public class ShadowMeteoroidProximityHandler {
    private static int checkTimer = 0;

    public static void init() {
        TickEvent.SERVER_LEVEL_POST.register(level -> {
            IWorldAlterationConfig config = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration();
            if (!config.meteoroidShadowTransformationEnabled()) {
                return;
            }
            if (++checkTimer >= config.meteoroidShadowTransformationCheckIntervalTicks()) {
                checkTimer = 0;
                ShadowMeteoroidProximityHandler.processProximity(level);
                ShadowMeteoroidProximityHandler.processBallDecay(level);
            }
        });
    }

    private static void processProximity(class_3218 level) {
        IWorldAlterationConfig config = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration();
        int radius = config.meteoroidShadowTransformationRadius();
        double baseChance = config.meteoroidShadowTransformationChancePerInterval();
        for (class_1297 e : level.method_27909()) {
            int maxGauge;
            int currentGauge;
            PokemonEntity entity;
            if (!(e instanceof PokemonEntity) || !(entity = (PokemonEntity)e).method_5805()) continue;
            Pokemon pokemon = entity.getPokemon();
            if (!(pokemon == null || pokemon.isBattleClone() || PokemonAspectUtil.hasShadowAspect(pokemon) || ShadowSpawnConfig.isBlacklisted(pokemon) || PokemonAspectUtil.isImmunized(pokemon))) {
                if (ShadowMeteoroidProximityHandler.isNearMeteoroid(level, entity.method_24515(), radius)) {
                    double currentExposure = PokemonAspectUtil.getExposure(pokemon);
                    PokemonAspectUtil.setExposureProperty(pokemon, currentExposure += config.meteoroidShadowTransformationExposureIncrease());
                    double chance = baseChance * currentExposure;
                    if (!(level.field_9229.method_43058() < chance)) continue;
                    ShadowMeteoroidProximityHandler.transformToShadow(level, entity);
                    PokemonAspectUtil.setExposureProperty(pokemon, 0.0);
                    continue;
                }
                double currentExposure = PokemonAspectUtil.getExposure(pokemon);
                if (!(currentExposure > 0.0)) continue;
                double exposure = currentExposure - config.meteoroidShadowTransformationExposureDecay();
                PokemonAspectUtil.setExposureProperty(pokemon, Math.max(0.0, exposure));
                continue;
            }
            if (pokemon == null || !PokemonAspectUtil.hasShadowAspect(pokemon) || !ShadowMeteoroidProximityHandler.isNearMeteoroid(level, entity.method_24515(), radius) || (currentGauge = PokemonAspectUtil.getHeartGaugeMeter(pokemon)) >= (maxGauge = HeartGaugeConfig.getMax(pokemon))) continue;
            int increase = (int)Math.max(1.0, config.meteoroidShadowTransformationExposureIncrease());
            ShadowService.setHeartGauge(pokemon, entity, currentGauge + increase);
        }
    }

    private static void processBallDecay(class_3218 level) {
        IWorldAlterationConfig config = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration();
        double decayAmount = config.meteoroidShadowTransformationExposureDecay();
        if (decayAmount <= 0.0) {
            return;
        }
        HashSet<Pokemon> processed = new HashSet<Pokemon>();
        for (class_1297 e : level.method_27909()) {
            PokemonEntity entity;
            Object pokemon;
            if (!(e instanceof PokemonEntity) || (pokemon = (entity = (PokemonEntity)e).getPokemon()) == null) continue;
            processed.add((Pokemon)pokemon);
        }
        for (class_3222 player : level.method_18456()) {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            for (Pokemon mon : party) {
                if (mon == null || processed.contains(mon)) continue;
                ShadowMeteoroidProximityHandler.decayExposure(mon, decayAmount);
                processed.add(mon);
            }
            PCStore pc = Cobblemon.INSTANCE.getStorage().getPC(player);
            for (Pokemon mon : pc) {
                if (mon == null || processed.contains(mon)) continue;
                ShadowMeteoroidProximityHandler.decayExposure(mon, decayAmount);
                processed.add(mon);
            }
        }
    }

    private static void decayExposure(Pokemon pokemon, double decayAmount) {
        if (PokemonAspectUtil.hasShadowAspect(pokemon)) {
            return;
        }
        if (ShadowSpawnConfig.isBlacklisted(pokemon)) {
            return;
        }
        double currentExposure = PokemonAspectUtil.getExposure(pokemon);
        if (currentExposure > 0.0) {
            PokemonAspectUtil.setExposureProperty(pokemon, Math.max(0.0, currentExposure - decayAmount));
        }
    }

    private static boolean isNearMeteoroid(class_3218 level, class_2338 pos, int radius) {
        for (class_2338 p : class_2338.method_10097((class_2338)pos.method_10069(-radius, -4, -radius), (class_2338)pos.method_10069(radius, 4, radius))) {
            if (!level.method_8320(p).method_27852((class_2248)ModBlocks.SHADOWFALL_METEOROID.get())) continue;
            return true;
        }
        return false;
    }

    private static void transformToShadow(class_3218 level, PokemonEntity entity) {
        Pokemon pokemon = entity.getPokemon();
        if (pokemon == null) {
            return;
        }
        ShadowService.setShadow(pokemon, entity, true);
        if (pokemon.getOwnerUUID() != null) {
            ShadowService.setHeartGauge(pokemon, entity, 0);
        } else {
            ShadowService.setHeartGauge(pokemon, entity, HeartGaugeConfig.getMax(pokemon));
        }
        PokemonAspectUtil.ensureRequiredShadowAspects(pokemon);
        WildShadowSpawnListener.assignShadowMoves(pokemon);
        if (ModSounds.SHADOW_AURA_INITIAL_BURST != null) {
            new UnvalidatedPlaySoundS2CPacket(ModSounds.SHADOW_AURA_INITIAL_BURST.getId(), class_3419.field_15254, entity.method_23317(), entity.method_23318(), entity.method_23321(), 3.0f, 1.0f).sendToPlayersAround(entity.method_23317(), entity.method_23318(), entity.method_23321(), 64.0, level.method_27983(), serverPlayer -> false);
        }
        AuraBroadcastQueue.queueBroadcast((class_1297)entity, 2.5f, 600);
        ShadowedHeartsNetworkingUtils.broadcastLuminousMoteToTracking((class_1297)entity);
    }
}

