/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.server;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import kotlin.Unit;

public final class ShadowProgressionManager {
    private ShadowProgressionManager() {
    }

    public static void init() {
        CobblemonEvents.EXPERIENCE_GAINED_EVENT_PRE.subscribe(Priority.NORMAL, e -> {
            Pokemon p = e.getPokemon();
            if (p == null) {
                return Unit.INSTANCE;
            }
            if (PokemonAspectUtil.hasShadowAspect(p)) {
                int xp = e.getExperience();
                if (xp > 0) {
                    PokemonAspectUtil.addBufferedExp(p, xp);
                }
                e.cancel();
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.EXPERIENCE_CANDY_USE_PRE.subscribe(Priority.NORMAL, e -> {
            Pokemon p = e.getPokemon();
            if (p == null) {
                return Unit.INSTANCE;
            }
            if (PokemonAspectUtil.hasShadowAspect(p)) {
                int yield = Math.max(0, e.getExperienceYield());
                if (yield > 0) {
                    PokemonAspectUtil.addBufferedExp(p, yield);
                }
                e.cancel();
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.EV_GAINED_EVENT_PRE.subscribe(Priority.NORMAL, e -> {
            Pokemon p = e.getPokemon();
            if (p == null) {
                return Unit.INSTANCE;
            }
            if (PokemonAspectUtil.hasShadowAspect(p)) {
                int amt = e.getAmount();
                if (amt > 0) {
                    PokemonAspectUtil.addBufferedEv(p, e.getStat(), amt);
                }
                e.cancel();
            }
            return Unit.INSTANCE;
        });
    }
}

