/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.server;

import com.cobblemon.mod.common.pokemon.Species;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class SpeciesTagManager
extends class_4309 {
    private static final Gson GSON = new Gson();
    public static final SpeciesTagManager INSTANCE = new SpeciesTagManager();
    private final Map<class_2960, Set<class_2960>> tagMap = new ConcurrentHashMap<class_2960, Set<class_2960>>();
    private final Map<class_2960, Set<class_2960>> resolvedTagMap = new ConcurrentHashMap<class_2960, Set<class_2960>>();

    private SpeciesTagManager() {
        super(GSON, "tags/species");
    }

    protected void applyImproved(Map<class_2960, JsonElement> object) {
        HashMap<class_2960, TagData> rawTags = new HashMap<class_2960, TagData>();
        for (Map.Entry<class_2960, JsonElement> entry : object.entrySet()) {
            JsonObject obj;
            class_2960 tagId = entry.getKey();
            JsonElement json = entry.getValue();
            if (!json.isJsonObject() || !(obj = json.getAsJsonObject()).has("values") || !obj.get("values").isJsonArray()) continue;
            TagData data = new TagData();
            for (JsonElement element : obj.getAsJsonArray("values")) {
                String s = element.getAsString();
                if (s.startsWith("#")) {
                    data.tags.add(class_2960.method_60654((String)s.substring(1)));
                    continue;
                }
                data.species.add(class_2960.method_60654((String)s));
            }
            rawTags.put(tagId, data);
        }
        this.resolvedTagMap.clear();
        for (class_2960 tagId : rawTags.keySet()) {
            HashSet<class_2960> species = new HashSet<class_2960>();
            this.collectSpecies(tagId, rawTags, species, new HashSet<class_2960>());
            this.resolvedTagMap.put(tagId, species);
        }
    }

    private void collectSpecies(class_2960 tagId, Map<class_2960, TagData> rawTags, Set<class_2960> out, Set<class_2960> visited) {
        if (visited.contains(tagId)) {
            return;
        }
        visited.add(tagId);
        TagData data = rawTags.get(tagId);
        if (data == null) {
            return;
        }
        out.addAll(data.species);
        for (class_2960 subTag : data.tags) {
            this.collectSpecies(subTag, rawTags, out, visited);
        }
    }

    public boolean isInTag(Species species, String tagWithHash) {
        if (species == null || tagWithHash == null || !tagWithHash.startsWith("#")) {
            return false;
        }
        String tagName = tagWithHash.substring(1);
        class_2960 tagId = class_2960.method_60654((String)tagName);
        Set<class_2960> speciesList = this.resolvedTagMap.get(tagId);
        if (speciesList == null) {
            return false;
        }
        return speciesList.contains(species.getResourceIdentifier());
    }

    public void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        this.applyImproved(object);
    }

    private static class TagData {
        Set<class_2960> species = new HashSet<class_2960>();
        Set<class_2960> tags = new HashSet<class_2960>();

        private TagData() {
        }
    }
}

