/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.server;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.sound.UnvalidatedPlaySoundS2CPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.jayemceekay.shadowedhearts.PokemonAspectUtil;
import com.jayemceekay.shadowedhearts.ShadowService;
import com.jayemceekay.shadowedhearts.config.HeartGaugeConfig;
import com.jayemceekay.shadowedhearts.config.ModConfig;
import com.jayemceekay.shadowedhearts.config.ShadowSpawnConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.core.ModBlocks;
import com.jayemceekay.shadowedhearts.core.ModSounds;
import com.jayemceekay.shadowedhearts.server.AuraBroadcastQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import kotlin.Unit;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public final class WildShadowSpawnListener {
    private static final Random RANDOM = new Random();
    private static final String[] SHADOW_IDS = new String[]{"shadowblast", "shadowblitz", "shadowbolt", "shadowbreak", "shadowchill", "shadowdown", "shadowend", "shadowfire", "shadowhalf", "shadowhold", "shadowmist", "shadowpanic", "shadowrave", "shadowrush", "shadowshed", "shadowsky", "shadowstorm", "shadowwave"};

    private WildShadowSpawnListener() {
    }

    public static void init() {
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.NORMAL, e -> {
            int r;
            PokemonEntity entity = (PokemonEntity)e.getEntity();
            class_1937 patt0$temp = entity.method_37908();
            if (!(patt0$temp instanceof class_3218)) {
                return Unit.INSTANCE;
            }
            class_3218 level = (class_3218)patt0$temp;
            Pokemon pokemon = entity.getPokemon();
            if (pokemon == null) {
                return Unit.INSTANCE;
            }
            if (entity.method_6139() != null) {
                return Unit.INSTANCE;
            }
            if (pokemon.isBattleClone()) {
                return Unit.INSTANCE;
            }
            if (ShadowSpawnConfig.isBlacklisted(pokemon)) {
                return Unit.INSTANCE;
            }
            if (PokemonAspectUtil.isImmunized(pokemon)) {
                return Unit.INSTANCE;
            }
            double chance = ShadowSpawnConfig.getChancePercent();
            if (WildShadowSpawnListener.isNearShadowfallMeteoroid(level, entity.method_24515())) {
                chance *= ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration().meteoroidShadowSpawnChanceMultiplier();
            }
            if (chance <= 0.0) {
                return Unit.INSTANCE;
            }
            if (chance < 100.0 && (double)(r = RANDOM.nextInt(100)) >= chance) {
                return Unit.INSTANCE;
            }
            ShadowService.setShadow(pokemon, entity, true);
            ShadowService.setHeartGauge(pokemon, entity, HeartGaugeConfig.getMax(pokemon));
            PokemonAspectUtil.ensureRequiredShadowAspects(pokemon);
            WildShadowSpawnListener.assignShadowMoves(pokemon);
            if (ModSounds.SHADOW_AURA_INITIAL_BURST != null) {
                new UnvalidatedPlaySoundS2CPacket(ModSounds.SHADOW_AURA_INITIAL_BURST.getId(), class_3419.field_15254, entity.method_23317(), entity.method_23318(), entity.method_23321(), 3.0f, 1.0f).sendToPlayersAround(entity.method_23317(), entity.method_23318(), entity.method_23321(), 64.0, level.method_27983(), serverPlayer -> false);
            }
            AuraBroadcastQueue.queueBroadcast((class_1297)entity, 2.5f, 600);
            return Unit.INSTANCE;
        });
    }

    private static boolean isNearShadowfallMeteoroid(class_3218 level, class_2338 pos) {
        int radius = 48;
        for (class_2338 p : class_2338.method_10097((class_2338)pos.method_10069(-radius, -8, -radius), (class_2338)pos.method_10069(radius, 8, radius))) {
            if (!level.method_8320(p).method_27852((class_2248)ModBlocks.SHADOWFALL_METEOROID.get())) continue;
            return true;
        }
        return false;
    }

    public static void assignShadowMoves(Pokemon pokemon) {
        if (ShadowedHeartsConfigs.getInstance().getShadowConfig().shadowMovesOnlyShadowRush()) {
            MoveTemplate tmpl = Moves.getByNameOrDummy((String)"shadowrush");
            pokemon.getMoveSet().setMove(0, tmpl.create(tmpl.getPp(), 0));
            return;
        }
        int count = ModConfig.resolveReplaceCount(RANDOM);
        ArrayList<String> pool = new ArrayList<String>(List.of(SHADOW_IDS));
        for (int i = 0; i < Math.min(count, 4); ++i) {
            String moveId = i == 0 ? WildShadowSpawnListener.pickDamageShadow(pool, null) : WildShadowSpawnListener.pickShadow(pool, null);
            if (moveId == null) continue;
            MoveTemplate tmpl = Moves.getByNameOrDummy((String)moveId);
            pokemon.getMoveSet().setMove(i, tmpl.create(tmpl.getPp(), 0));
            pool.remove(moveId);
        }
    }

    private static String pickDamageShadow(List<String> ids, String exclude) {
        ArrayList<String> damageMoves = new ArrayList<String>();
        for (String id : ids) {
            MoveTemplate tmpl = Moves.getByNameOrDummy((String)id);
            if (tmpl.getDamageCategory() == DamageCategories.INSTANCE.getSTATUS()) continue;
            damageMoves.add(id);
        }
        return WildShadowSpawnListener.pickShadow(damageMoves, exclude);
    }

    private static String pickShadow(List<String> ids, String exclude) {
        if (ids.isEmpty()) {
            return null;
        }
        int tries = 0;
        while (tries++ < 8) {
            String id = ids.get(RANDOM.nextInt(ids.size()));
            if (exclude != null && exclude.equalsIgnoreCase(id)) continue;
            return id;
        }
        return ids.get(0);
    }
}

