/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.showdown;

import com.cobblemon.mod.relocations.graalvm.polyglot.Context;
import com.cobblemon.mod.relocations.graalvm.polyglot.Value;
import com.jayemceekay.shadowedhearts.Shadowedhearts;
import com.jayemceekay.shadowedhearts.config.IShadowConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ShowdownRuntimePatcher {
    private ShowdownRuntimePatcher() {
    }

    public static void applyPatches() {
        Shadowedhearts.LOGGER.info("Applying Showdown runtime patches...");
        for (Path showdown : ShowdownRuntimePatcher.locateShowdownDirs()) {
            ShowdownRuntimePatcher.ensureModFilesExist(showdown);
            try {
                ShowdownRuntimePatcher.patchDexConditions(showdown.resolve("sim").resolve("dex-conditions.js"));
            }
            catch (Exception e) {
                Shadowedhearts.LOGGER.info("Failed to patch dex-conditions.js in Showdown directory: " + String.valueOf(showdown));
            }
            try {
                ShowdownRuntimePatcher.patchBattleCapture(showdown.resolve("sim").resolve("battle.js"));
            }
            catch (Exception e) {
                Shadowedhearts.LOGGER.info("Failed to patch battle.js in Showdown directory: " + String.valueOf(showdown));
            }
            try {
                ShowdownRuntimePatcher.patchTeams(showdown.resolve("sim").resolve("teams.js"));
            }
            catch (Exception e) {
                Shadowedhearts.LOGGER.info("Failed to patch teams.js in Showdown directory: " + String.valueOf(showdown));
            }
            try {
                ShowdownRuntimePatcher.patchBattleAddShadowEngine(showdown.resolve("sim").resolve("battle.js"));
            }
            catch (Exception e) {
                Shadowedhearts.LOGGER.info("Failed to patch battle.js in Showdown directory: " + String.valueOf(showdown));
            }
            try {
                ShowdownRuntimePatcher.patchFieldAddPseudoWeatherDebug(showdown.resolve("sim").resolve("field.js"));
            }
            catch (Exception e) {
                Shadowedhearts.LOGGER.info("Failed to patch field.js in Showdown directory: " + String.valueOf(showdown));
            }
            try {
                ShowdownRuntimePatcher.patchSideAddCallChoice(showdown.resolve("sim").resolve("side.js"));
            }
            catch (Exception e) {
                Shadowedhearts.LOGGER.info("Failed to patch side.js in Showdown directory: " + String.valueOf(showdown));
            }
            try {
                ShowdownRuntimePatcher.patchBattleQueueAddCallOrder(showdown.resolve("sim").resolve("battle-queue.js"));
            }
            catch (Exception e) {
                Shadowedhearts.LOGGER.info("Failed to patch battle-queue.js in Showdown directory: " + String.valueOf(showdown));
            }
            try {
                ShowdownRuntimePatcher.patchBattleAddCallAction(showdown.resolve("sim").resolve("battle.js"));
            }
            catch (Exception e) {
                Shadowedhearts.LOGGER.info("Failed to patch battle.js in Showdown directory: " + String.valueOf(showdown));
            }
        }
    }

    private static List<Path> locateShowdownDirs() {
        ArrayList<Path> result = new ArrayList<Path>();
        ShowdownRuntimePatcher.addIfDir(result, Platform.getGameFolder().resolve("showdown"));
        ShowdownRuntimePatcher.addIfDir(result, Paths.get("showdown", new String[0]));
        return result;
    }

    private static void addIfDir(List<Path> list, Path p) {
        try {
            if (Files.isDirectory(p, new LinkOption[0])) {
                list.add(p.toRealPath(new LinkOption[0]));
            }
        }
        catch (IOException ignored) {
            Shadowedhearts.LOGGER.info("Failed to resolve directory: " + String.valueOf(p));
        }
    }

    private static void ensureModFilesExist(Path showdownDir) {
        Path modDataDir = showdownDir.resolve("data").resolve("mods").resolve("cobblemon");
        try {
            Files.createDirectories(modDataDir, new FileAttribute[0]);
            ShowdownRuntimePatcher.yoink("/assets/shadowedhearts/showdown/mods/conditions.js", modDataDir.resolve("conditions.js"));
            ShowdownRuntimePatcher.yoink("/assets/shadowedhearts/showdown/mods/typechart.js", modDataDir.resolve("typechart.js"));
            ShowdownRuntimePatcher.yoink("/assets/shadowedhearts/showdown/mods/items.js", modDataDir.resolve("items.js"));
            ShowdownRuntimePatcher.yoink("/assets/shadowedhearts/showdown/mods/scripts.js", modDataDir.resolve("scripts.js"));
        }
        catch (IOException e) {
            Shadowedhearts.LOGGER.error("Failed to ensure mod files exist in " + String.valueOf(modDataDir), (Throwable)e);
        }
    }

    private static void yoink(String resourcePath, Path targetPath) {
        if (Files.exists(targetPath, new LinkOption[0])) {
            return;
        }
        try (InputStream in = ShowdownRuntimePatcher.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                Shadowedhearts.LOGGER.error("Resource not found: " + resourcePath);
                return;
            }
            Files.copy(in, targetPath, new CopyOption[0]);
            Shadowedhearts.LOGGER.info("Extracted " + resourcePath + " to " + String.valueOf(targetPath));
        }
        catch (IOException e) {
            Shadowedhearts.LOGGER.error("Failed to extract " + resourcePath + " to " + String.valueOf(targetPath), (Throwable)e);
        }
    }

    private static void patchDexConditions(Path dexConditionsPath) throws IOException {
        if (!Files.isRegularFile(dexConditionsPath, new LinkOption[0])) {
            return;
        }
        String content = Files.readString(dexConditionsPath, StandardCharsets.UTF_8);
        String whitelistPattern = "[\"Weather\", \"Status\"]";
        String desired = "[\"Weather\", \"Status\", \"Field\"]";
        if (content.contains("\"Field\"")) {
            return;
        }
        String needle = "this.effectType = [\"Weather\", \"Status\"].includes(data.effectType) ? data.effectType : \"Condition\";";
        String replacement = "this.effectType = [\"Weather\", \"Status\", \"Field\"].includes(data.effectType) ? data.effectType : \"Condition\";";
        if (content.contains(needle)) {
            String patched = content.replace(needle, replacement);
            Files.writeString(dexConditionsPath, (CharSequence)patched, StandardCharsets.UTF_8, new OpenOption[0]);
            Shadowedhearts.LOGGER.info("Patched dex-conditions.js with Field effectType whitelist");
            return;
        }
        if (content.contains(whitelistPattern)) {
            String patched = content.replace(whitelistPattern, desired);
            Files.writeString(dexConditionsPath, (CharSequence)patched, StandardCharsets.UTF_8, new OpenOption[0]);
            Shadowedhearts.LOGGER.info("Patched dex-conditions.js with Field effectType whitelist");
            return;
        }
    }

    private static String readResourceText(String resourcePath) {
        String string;
        block9: {
            InputStream in = ShowdownRuntimePatcher.class.getResourceAsStream(resourcePath);
            if (in == null) {
                throw new IOException("Resource not found: " + resourcePath);
            }
            InputStream inputStream = in;
            try {
                string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Shadowedhearts.LOGGER.info("Failed to read resource: " + resourcePath, (Throwable)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static String extractExportedTemplate(String raw) {
        if (raw == null) {
            return null;
        }
        String s = raw.trim();
        int firstTick = s.indexOf(96);
        int lastTick = s.lastIndexOf(96);
        if ((s.startsWith("module.exports") || s.contains("module.exports")) && firstTick >= 0 && lastTick > firstTick) {
            return s.substring(firstTick + 1, lastTick);
        }
        return raw;
    }

    private static void patchBattleCapture(Path battlePath) throws IOException {
        if (!Files.isRegularFile(battlePath, new LinkOption[0])) {
            return;
        }
        String content = Files.readString(battlePath, StandardCharsets.UTF_8);
        if (content.contains("pokemon.side.emitRequest(req)") || content.contains("// Build and emit a new request")) {
            Shadowedhearts.LOGGER.info("Battle already patched for request emission, skipping patch");
            return;
        }
        String needle = "      if (this.checkWin())\n        return true;\n    }\n    return false;\n  }";
        String replacement = "      if (this.checkWin())\n        return true;\n      this.checkFainted();\n\n      // Build and emit a new request so the victim side can choose a replacement\n      const activeData = pokemon.side.active.map(pk => pk?.getMoveRequestData());\n      const req = { active: activeData, side: pokemon.side.getRequestData() };\n      if (pokemon.side.allySide) {\n          req.ally = pokemon.side.allySide.getRequestData(true);\n      }\n      pokemon.side.emitRequest(req);\n      pokemon.side.clearChoice();\n    }\n    return false;\n  }";
        if (content.contains("      if (this.checkWin())\n        return true;\n    }\n    return false;\n  }")) {
            String patched = content.replace("      if (this.checkWin())\n        return true;\n    }\n    return false;\n  }", "      if (this.checkWin())\n        return true;\n      this.checkFainted();\n\n      // Build and emit a new request so the victim side can choose a replacement\n      const activeData = pokemon.side.active.map(pk => pk?.getMoveRequestData());\n      const req = { active: activeData, side: pokemon.side.getRequestData() };\n      if (pokemon.side.allySide) {\n          req.ally = pokemon.side.allySide.getRequestData(true);\n      }\n      pokemon.side.emitRequest(req);\n      pokemon.side.clearChoice();\n    }\n    return false;\n  }");
            Files.writeString(battlePath, (CharSequence)patched, StandardCharsets.UTF_8, new OpenOption[0]);
            Shadowedhearts.LOGGER.info("Patched battle.js to emit capture request");
        }
    }

    private static void patchTeams(Path teamsPath) throws IOException {
        boolean hasNewFlags;
        if (!Files.isRegularFile(teamsPath, new LinkOption[0])) {
            return;
        }
        String content = Files.readString(teamsPath, StandardCharsets.UTF_8);
        boolean bl = hasNewFlags = content.contains("set.isHyper") || content.contains("set.isReverse") || content.contains("misc[9]");
        if (hasNewFlags) {
            Shadowedhearts.LOGGER.info("Teams already patched for new flags, skipping patch");
            return;
        }
        int packStart = content.indexOf("  pack(team) {");
        if (packStart < 0) {
            Shadowedhearts.LOGGER.info("Teams already patched for pack function, skipping patch");
            return;
        }
        int unpackStart = content.indexOf("\n  unpack(buf) {", packStart);
        if (unpackStart < 0) {
            Shadowedhearts.LOGGER.info("Teams already patched for unpack function, skipping patch");
            return;
        }
        int afterUnpack = content.indexOf("\n  /**", unpackStart);
        if (afterUnpack < 0) {
            afterUnpack = content.indexOf("\n  packName(", unpackStart);
        }
        if (afterUnpack < 0) {
            afterUnpack = content.indexOf("\n  static packName(", unpackStart);
        }
        if (afterUnpack < 0) {
            return;
        }
        String newBlock = "  pack(team) {\n    if (!team)\n      return \"\";\n    function getIv(ivs, s) {\n      return ivs[s] === 31 || ivs[s] === void 0 ? \"\" : ivs[s].toString();\n    }\n    let buf = \"\";\n    for (const set of team) {\n      if (buf)\n        buf += \"]\";\n      buf += set.name || set.species;\n      const id = this.packName(set.species || set.name);\n      buf += \"|\" + (this.packName(set.name || set.species) === id ? \"\" : id);\n      buf += \"|\" + this.packName(set.item);\n      buf += \"|\" + this.packName(set.ability);\n      buf += \"|\" + set.moves.map(this.packName).join(\",\");\n      buf += \"|\" + (set.nature || \"\");\n      let evs = \"|\";\n      if (set.evs) {\n        evs = \"|\" + (set.evs[\"hp\"] || \"\") + \",\" + (set.evs[\"atk\"] || \"\") + \",\" + (set.evs[\"def\"] || \"\") + \",\" + (set.evs[\"spa\"] || \"\") + \",\" + (set.evs[\"spd\"] || \"\") + \",\" + (set.evs[\"spe\"] || \"\");\n      }\n      if (evs === \"|,,,,,\") {\n        buf += \"|\";\n      } else {\n        buf += evs;\n      }\n      if (set.gender) {\n        buf += \"|\" + set.gender;\n      } else {\n        buf += \"|\";\n      }\n      let ivs = \"|\";\n      if (set.ivs) {\n        ivs = \"|\" + getIv(set.ivs, \"hp\") + \",\" + getIv(set.ivs, \"atk\") + \",\" + getIv(set.ivs, \"def\") + \",\" + getIv(set.ivs, \"spa\") + \",\" + getIv(set.ivs, \"spd\") + \",\" + getIv(set.ivs, \"spe\");\n      }\n      if (ivs === \"|,,,,,\") {\n        buf += \"|\";\n      } else {\n        buf += ivs;\n      }\n      if (set.shiny) {\n        buf += \"|S\";\n      } else {\n        buf += \"|\";\n      }\n      if (set.level && set.level !== 100) {\n        buf += \"|\" + set.level;\n      } else {\n        buf += \"|\";\n      }\n      if (set.happiness !== void 0 && set.happiness !== 255) {\n        buf += \"|\" + set.happiness;\n      } else {\n        buf += \"|\";\n      }\n      if (set.pokeball || set.hpType || set.gigantamax || set.dynamaxLevel !== void 0 && set.dynamaxLevel !== 10 || set.teraType || set.isShadow || set.heartGaugeBars !== void 0 || set.isHyper || set.isReverse) {\n        buf += \",\" + this.packName(set.pokeball || \"\");\n        buf += \",\" + (set.hpType || \"\");\n        buf += \",\" + (set.gigantamax ? \"G\" : \"\");\n        buf += \",\" + (set.dynamaxLevel !== void 0 && set.dynamaxLevel !== 10 ? set.dynamaxLevel : \"\");\n        buf += \",\" + (set.teraType || \"\");\n        buf += \",\" + (set.isShadow ? \"true\" : \"false\");\n        buf += \",\" + (set.heartGaugeBars !== void 0 ? set.heartGaugeBars : \"\");\n        buf += \",\" + (set.isHyper ? 'true' : 'false');\n        buf += \",\" + (set.isReverse ? 'true' : 'false');\n      }\n    }\n    return buf;\n  }\n  unpack(buf) {\n    if (!buf)\n      return null;\n    if (typeof buf !== \"string\")\n      return buf;\n    if (buf.startsWith(\"[\") && buf.endsWith(\"]\")) {\n      try {\n        buf = this.pack(JSON.parse(buf));\n      } catch {\n        return null;\n      }\n    }\n    const team = [];\n    let i = 0;\n    let j = 0;\n    for (let count = 0; count < 24; count++) {\n      const set = {};\n      team.push(set);\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.name = buf.substring(i, j);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.species = this.unpackName(buf.substring(i, j), import_dex.Dex.species) || set.name;\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.uuid = buf.substring(i, j);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.currentHealth = parseInt(buf.substring(i, j));\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.status = buf.substring(i, j);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.statusDuration = parseInt(buf.substring(i, j));\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.item = this.unpackName(buf.substring(i, j), import_dex.Dex.items);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      const ability = buf.substring(i, j);\n      set.ability = this.unpackName(ability, import_dex.Dex.abilities);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.moves = buf.substring(i, j).split(\",\", 24).map((name) => this.unpackName(name, import_dex.Dex.moves));\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.movesInfo = buf.substring(i, j).split(\",\", 24).map((moveData) => {\n        const moveInfo = {};\n        let data = moveData.split(\"/\");\n        moveInfo.pp = parseInt(data[0]);\n        moveInfo.maxPp = parseInt(data[1]);\n        return moveInfo;\n      });\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.nature = this.unpackName(buf.substring(i, j), import_dex.Dex.natures);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      if (j !== i) {\n        const evs = buf.substring(i, j).split(\",\", 6);\n        set.evs = {\n          hp: Number(evs[0]) || 0,\n          atk: Number(evs[1]) || 0,\n          def: Number(evs[2]) || 0,\n          spa: Number(evs[3]) || 0,\n          spd: Number(evs[4]) || 0,\n          spe: Number(evs[5]) || 0\n        };\n      }\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      if (i !== j)\n        set.gender = buf.substring(i, j);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      if (j !== i) {\n        const ivs = buf.substring(i, j).split(\",\", 6);\n        set.ivs = {\n          hp: ivs[0] === \"\" ? 31 : Number(ivs[0]) || 0,\n          atk: ivs[1] === \"\" ? 31 : Number(ivs[1]) || 0,\n          def: ivs[2] === \"\" ? 31 : Number(ivs[2]) || 0,\n          spa: ivs[3] === \"\" ? 31 : Number(ivs[3]) || 0,\n          spd: ivs[4] === \"\" ? 31 : Number(ivs[4]) || 0,\n          spe: ivs[5] === \"\" ? 31 : Number(ivs[5]) || 0\n        };\n      }\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      if (i !== j)\n        set.shiny = true;\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      if (i !== j)\n        set.level = parseInt(buf.substring(i, j));\n      i = j + 1;\n        // happiness + extended misc\n        j = buf.indexOf(']', i);\n        let misc;\n        if (j < 0) {\n            if (i < buf.length) misc = buf.substring(i).split(',', 10);\n        } else {\n            if (i !== j) misc = buf.substring(i, j).split(',', 10);\n        }\n        if (misc) {\n            set.happiness = (misc[0] ? Number(misc[0]) : 255);\n            set.pokeball = this.unpackName(misc[1] || '', import_dex.Dex.items);\n            set.hpType = misc[2] || '';\n            set.gigantamax = !!misc[3];\n            set.dynamaxLevel = (misc[4] ? Number(misc[4]) : 10);\n            set.teraType = misc[5];\n\n            // 7th token: Shadow flag\n            const shadowTok = misc[6];\n            set.isShadow = shadowTok === 'true';\n            // 8th token: Heart Gauge bars (0..5)\n            if (misc.length > 7 && misc[7] !== undefined && misc[7] !== '') {\n                set.heartGaugeBars = Number(misc[7]);\n            }\n            // 9th token: Start in Hyper Mode flag\n            if (misc.length > 8) {\n                set.isHyper = misc[8] === 'true';\n            }\n            // 10th token: Start in Reverse Mode flag\n            if (misc.length > 9) {\n                set.isReverse = misc[9] === 'true';\n            }\n        }\n      if (j < 0)\n        break;\n      i = j + 1;\n    }\n    return team;\n  }\n";
        String patched = content.substring(0, packStart) + "  pack(team) {\n    if (!team)\n      return \"\";\n    function getIv(ivs, s) {\n      return ivs[s] === 31 || ivs[s] === void 0 ? \"\" : ivs[s].toString();\n    }\n    let buf = \"\";\n    for (const set of team) {\n      if (buf)\n        buf += \"]\";\n      buf += set.name || set.species;\n      const id = this.packName(set.species || set.name);\n      buf += \"|\" + (this.packName(set.name || set.species) === id ? \"\" : id);\n      buf += \"|\" + this.packName(set.item);\n      buf += \"|\" + this.packName(set.ability);\n      buf += \"|\" + set.moves.map(this.packName).join(\",\");\n      buf += \"|\" + (set.nature || \"\");\n      let evs = \"|\";\n      if (set.evs) {\n        evs = \"|\" + (set.evs[\"hp\"] || \"\") + \",\" + (set.evs[\"atk\"] || \"\") + \",\" + (set.evs[\"def\"] || \"\") + \",\" + (set.evs[\"spa\"] || \"\") + \",\" + (set.evs[\"spd\"] || \"\") + \",\" + (set.evs[\"spe\"] || \"\");\n      }\n      if (evs === \"|,,,,,\") {\n        buf += \"|\";\n      } else {\n        buf += evs;\n      }\n      if (set.gender) {\n        buf += \"|\" + set.gender;\n      } else {\n        buf += \"|\";\n      }\n      let ivs = \"|\";\n      if (set.ivs) {\n        ivs = \"|\" + getIv(set.ivs, \"hp\") + \",\" + getIv(set.ivs, \"atk\") + \",\" + getIv(set.ivs, \"def\") + \",\" + getIv(set.ivs, \"spa\") + \",\" + getIv(set.ivs, \"spd\") + \",\" + getIv(set.ivs, \"spe\");\n      }\n      if (ivs === \"|,,,,,\") {\n        buf += \"|\";\n      } else {\n        buf += ivs;\n      }\n      if (set.shiny) {\n        buf += \"|S\";\n      } else {\n        buf += \"|\";\n      }\n      if (set.level && set.level !== 100) {\n        buf += \"|\" + set.level;\n      } else {\n        buf += \"|\";\n      }\n      if (set.happiness !== void 0 && set.happiness !== 255) {\n        buf += \"|\" + set.happiness;\n      } else {\n        buf += \"|\";\n      }\n      if (set.pokeball || set.hpType || set.gigantamax || set.dynamaxLevel !== void 0 && set.dynamaxLevel !== 10 || set.teraType || set.isShadow || set.heartGaugeBars !== void 0 || set.isHyper || set.isReverse) {\n        buf += \",\" + this.packName(set.pokeball || \"\");\n        buf += \",\" + (set.hpType || \"\");\n        buf += \",\" + (set.gigantamax ? \"G\" : \"\");\n        buf += \",\" + (set.dynamaxLevel !== void 0 && set.dynamaxLevel !== 10 ? set.dynamaxLevel : \"\");\n        buf += \",\" + (set.teraType || \"\");\n        buf += \",\" + (set.isShadow ? \"true\" : \"false\");\n        buf += \",\" + (set.heartGaugeBars !== void 0 ? set.heartGaugeBars : \"\");\n        buf += \",\" + (set.isHyper ? 'true' : 'false');\n        buf += \",\" + (set.isReverse ? 'true' : 'false');\n      }\n    }\n    return buf;\n  }\n  unpack(buf) {\n    if (!buf)\n      return null;\n    if (typeof buf !== \"string\")\n      return buf;\n    if (buf.startsWith(\"[\") && buf.endsWith(\"]\")) {\n      try {\n        buf = this.pack(JSON.parse(buf));\n      } catch {\n        return null;\n      }\n    }\n    const team = [];\n    let i = 0;\n    let j = 0;\n    for (let count = 0; count < 24; count++) {\n      const set = {};\n      team.push(set);\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.name = buf.substring(i, j);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.species = this.unpackName(buf.substring(i, j), import_dex.Dex.species) || set.name;\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.uuid = buf.substring(i, j);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.currentHealth = parseInt(buf.substring(i, j));\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.status = buf.substring(i, j);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.statusDuration = parseInt(buf.substring(i, j));\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.item = this.unpackName(buf.substring(i, j), import_dex.Dex.items);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      const ability = buf.substring(i, j);\n      set.ability = this.unpackName(ability, import_dex.Dex.abilities);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.moves = buf.substring(i, j).split(\",\", 24).map((name) => this.unpackName(name, import_dex.Dex.moves));\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.movesInfo = buf.substring(i, j).split(\",\", 24).map((moveData) => {\n        const moveInfo = {};\n        let data = moveData.split(\"/\");\n        moveInfo.pp = parseInt(data[0]);\n        moveInfo.maxPp = parseInt(data[1]);\n        return moveInfo;\n      });\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      set.nature = this.unpackName(buf.substring(i, j), import_dex.Dex.natures);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      if (j !== i) {\n        const evs = buf.substring(i, j).split(\",\", 6);\n        set.evs = {\n          hp: Number(evs[0]) || 0,\n          atk: Number(evs[1]) || 0,\n          def: Number(evs[2]) || 0,\n          spa: Number(evs[3]) || 0,\n          spd: Number(evs[4]) || 0,\n          spe: Number(evs[5]) || 0\n        };\n      }\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      if (i !== j)\n        set.gender = buf.substring(i, j);\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      if (j !== i) {\n        const ivs = buf.substring(i, j).split(\",\", 6);\n        set.ivs = {\n          hp: ivs[0] === \"\" ? 31 : Number(ivs[0]) || 0,\n          atk: ivs[1] === \"\" ? 31 : Number(ivs[1]) || 0,\n          def: ivs[2] === \"\" ? 31 : Number(ivs[2]) || 0,\n          spa: ivs[3] === \"\" ? 31 : Number(ivs[3]) || 0,\n          spd: ivs[4] === \"\" ? 31 : Number(ivs[4]) || 0,\n          spe: ivs[5] === \"\" ? 31 : Number(ivs[5]) || 0\n        };\n      }\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      if (i !== j)\n        set.shiny = true;\n      i = j + 1;\n      j = buf.indexOf(\"|\", i);\n      if (j < 0)\n        return null;\n      if (i !== j)\n        set.level = parseInt(buf.substring(i, j));\n      i = j + 1;\n        // happiness + extended misc\n        j = buf.indexOf(']', i);\n        let misc;\n        if (j < 0) {\n            if (i < buf.length) misc = buf.substring(i).split(',', 10);\n        } else {\n            if (i !== j) misc = buf.substring(i, j).split(',', 10);\n        }\n        if (misc) {\n            set.happiness = (misc[0] ? Number(misc[0]) : 255);\n            set.pokeball = this.unpackName(misc[1] || '', import_dex.Dex.items);\n            set.hpType = misc[2] || '';\n            set.gigantamax = !!misc[3];\n            set.dynamaxLevel = (misc[4] ? Number(misc[4]) : 10);\n            set.teraType = misc[5];\n\n            // 7th token: Shadow flag\n            const shadowTok = misc[6];\n            set.isShadow = shadowTok === 'true';\n            // 8th token: Heart Gauge bars (0..5)\n            if (misc.length > 7 && misc[7] !== undefined && misc[7] !== '') {\n                set.heartGaugeBars = Number(misc[7]);\n            }\n            // 9th token: Start in Hyper Mode flag\n            if (misc.length > 8) {\n                set.isHyper = misc[8] === 'true';\n            }\n            // 10th token: Start in Reverse Mode flag\n            if (misc.length > 9) {\n                set.isReverse = misc[9] === 'true';\n            }\n        }\n      if (j < 0)\n        break;\n      i = j + 1;\n    }\n    return team;\n  }\n" + content.substring(afterUnpack);
        Files.writeString(teamsPath, (CharSequence)patched, StandardCharsets.UTF_8, new OpenOption[0]);
        Shadowedhearts.LOGGER.info("Patched pack() in " + String.valueOf(teamsPath.toAbsolutePath()));
    }

    private static void patchCustomFormats(Path customFormatsPath) throws IOException {
        String content;
        if (!Files.isRegularFile(customFormatsPath, new LinkOption[0])) {
            try {
                Files.createDirectories(customFormatsPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String scaffold = "exports.Formats = [\n];\n";
            Files.writeString(customFormatsPath, (CharSequence)scaffold, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        if ((content = Files.readString(customFormatsPath, StandardCharsets.UTF_8)).contains("name: \"[Gen 9] Micro\"") || content.contains("name: '[Gen 9] Micro'")) {
            return;
        }
        String microBlock = "\n,{\n    section: \"Shadowed Hearts\",\n},\n{\n    name: \"[Gen 9] Micro\",\n    desc: \"Internal one-action micro battle for overworld interactions; not for human play.\",\n    mod: 'micro',\n    gameType: 'singles',\n    searchShow: false,\n    challengeShow: false,\n    tournamentShow: false,\n    rated: false,\n    ruleset: [\n        'Obtainable', 'Species Clause', 'HP Percentage Mod', 'Cancel Mod', 'Illusion Level Mod', 'Endless Battle Clause',\n        'Picked Team Size = 1', 'Max Team Size = 1', 'Min Team Size = 1',\n    ],\n    banlist: [\n        // Hazards and delayed-turn moves\n        'Stealth Rock', 'Spikes', 'Toxic Spikes', 'Sticky Web',\n        'Future Sight', 'Doom Desire', 'Perish Song',\n        // Pivots and passers (avoid switch flow)\n        'Baton Pass', 'Parting Shot',\n        // Two-turn/charge/invuln moves\n        'Sky Drop', 'Dive', 'Dig', 'Bounce', 'Fly', 'Phantom Force', 'Shadow Force', 'Solar Beam', 'Solar Blade', 'Skull Bash', 'Freeze Shock', 'Ice Burn', 'Razor Wind', 'Geomancy',\n    ],\n    onBegin() {\n        // State should be injected by the micro-battle runner; nothing to do here.\n    },\n    onResidual() {\n        // Prevent format-level residual effects; core statuses/weather may still apply if present.\n    },\n},\n";
        int endIndex = content.lastIndexOf("];");
        Object patched = endIndex >= 0 ? content.substring(0, endIndex) + "\n,{\n    section: \"Shadowed Hearts\",\n},\n{\n    name: \"[Gen 9] Micro\",\n    desc: \"Internal one-action micro battle for overworld interactions; not for human play.\",\n    mod: 'micro',\n    gameType: 'singles',\n    searchShow: false,\n    challengeShow: false,\n    tournamentShow: false,\n    rated: false,\n    ruleset: [\n        'Obtainable', 'Species Clause', 'HP Percentage Mod', 'Cancel Mod', 'Illusion Level Mod', 'Endless Battle Clause',\n        'Picked Team Size = 1', 'Max Team Size = 1', 'Min Team Size = 1',\n    ],\n    banlist: [\n        // Hazards and delayed-turn moves\n        'Stealth Rock', 'Spikes', 'Toxic Spikes', 'Sticky Web',\n        'Future Sight', 'Doom Desire', 'Perish Song',\n        // Pivots and passers (avoid switch flow)\n        'Baton Pass', 'Parting Shot',\n        // Two-turn/charge/invuln moves\n        'Sky Drop', 'Dive', 'Dig', 'Bounce', 'Fly', 'Phantom Force', 'Shadow Force', 'Solar Beam', 'Solar Blade', 'Skull Bash', 'Freeze Shock', 'Ice Burn', 'Razor Wind', 'Geomancy',\n    ],\n    onBegin() {\n        // State should be injected by the micro-battle runner; nothing to do here.\n    },\n    onResidual() {\n        // Prevent format-level residual effects; core statuses/weather may still apply if present.\n    },\n},\n" + content.substring(endIndex) : "exports.Formats = [\n\n,{\n    section: \"Shadowed Hearts\",\n},\n{\n    name: \"[Gen 9] Micro\",\n    desc: \"Internal one-action micro battle for overworld interactions; not for human play.\",\n    mod: 'micro',\n    gameType: 'singles',\n    searchShow: false,\n    challengeShow: false,\n    tournamentShow: false,\n    rated: false,\n    ruleset: [\n        'Obtainable', 'Species Clause', 'HP Percentage Mod', 'Cancel Mod', 'Illusion Level Mod', 'Endless Battle Clause',\n        'Picked Team Size = 1', 'Max Team Size = 1', 'Min Team Size = 1',\n    ],\n    banlist: [\n        // Hazards and delayed-turn moves\n        'Stealth Rock', 'Spikes', 'Toxic Spikes', 'Sticky Web',\n        'Future Sight', 'Doom Desire', 'Perish Song',\n        // Pivots and passers (avoid switch flow)\n        'Baton Pass', 'Parting Shot',\n        // Two-turn/charge/invuln moves\n        'Sky Drop', 'Dive', 'Dig', 'Bounce', 'Fly', 'Phantom Force', 'Shadow Force', 'Solar Beam', 'Solar Blade', 'Skull Bash', 'Freeze Shock', 'Ice Burn', 'Razor Wind', 'Geomancy',\n    ],\n    onBegin() {\n        // State should be injected by the micro-battle runner; nothing to do here.\n    },\n    onResidual() {\n        // Prevent format-level residual effects; core statuses/weather may still apply if present.\n    },\n},\n];\n";
        Files.writeString(customFormatsPath, (CharSequence)patched, StandardCharsets.UTF_8, new OpenOption[0]);
        Shadowedhearts.LOGGER.info("Custom formats patch applied successfully");
    }

    private static void patchMicroScripts(Path scriptsPath) throws IOException {
        String marker1 = "tiebreak()";
        String marker2 = "addSideCondition(";
        if (Files.isRegularFile(scriptsPath, new LinkOption[0])) {
            String existing = Files.readString(scriptsPath, StandardCharsets.UTF_8);
            if (existing.contains("exports.Scripts") && existing.contains(marker1) && existing.contains(marker2)) {
                return;
            }
        } else {
            try {
                Files.createDirectories(scriptsPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException existing) {
                // empty catch block
            }
        }
        String js = "exports.Scripts = {\n\tgen: 9,\n\tinherit: 'gen9',\n\n\t// Keep battles as quiet/minimal as possible; logs are handled by the runner.\n\tbattle: {\n\t\t// Suppress tiebreaks and other special-casing \u2013 micro battles should never reach them\n\t\ttiebreak() {\n\t\t\t// no-op\n\t\t},\n\t},\n\n\tside: {\n\t\t// Block adding common hazard/side condition effects; return false to indicate failure\n\t\taddSideCondition(status, source = null, sourceEffect = null) {\n\t\t\t// Fallback to parent implementation for non-hazard conditions\n\t\t\tconst hazards = [\n\t\t\t\t'stealthrock', 'spikes', 'toxicspikes', 'stickyweb',\n\t\t\t\t// G-Max residual hazards\n\t\t\t\t'gmaxsteelsurge', 'gmaxcannonade', 'gmaxvinelash', 'gmaxvolcalith', 'gmaxwildfire',\n\t\t\t];\n\t\t\tconst id = this.battle.toID((status && status.id) || status);\n\t\t\tif (hazards.includes(id)) return false;\n\t\t\treturn this.__proto__.addSideCondition.call(this, status, source, sourceEffect);\n\t\t},\n\t},\n\n\t// Disable global residual tick if possible by preventing the format residual from doing anything.\n\t// Many residual effects (weather/status) still occur via their own hooks; for micro, the\n\t// controlling format will opt not to include residual turns.\n};\n";
        Files.writeString(scriptsPath, (CharSequence)js, StandardCharsets.UTF_8, new OpenOption[0]);
        Shadowedhearts.LOGGER.info("Field pseudo weather patch applied successfully");
    }

    private static void patchBattleAddShadowEngine(Path battlePath) throws IOException {
        if (!Files.isRegularFile(battlePath, new LinkOption[0])) {
            return;
        }
        String content = Files.readString(battlePath, StandardCharsets.UTF_8);
        if (content.contains("addPseudoWeather('shadowengine')") || content.contains("addPseudoWeather(\"shadowengine\")")) {
            Shadowedhearts.LOGGER.info("Battle already patched for shadowengine pseudo weather, skipping patch");
            return;
        }
        String anchor = "this.add(\"gametype\", this.gameType);";
        int idx = content.indexOf(anchor);
        if (idx < 0) {
            Shadowedhearts.LOGGER.info("Battle patch failed to find anchor, skipping patch");
            return;
        }
        int insertPos = idx + anchor.length();
        String injected = "\n    this.field.addPseudoWeather('shadowengine');";
        String patched = content.substring(0, insertPos) + injected + content.substring(insertPos);
        Files.writeString(battlePath, (CharSequence)patched, StandardCharsets.UTF_8, new OpenOption[0]);
        Shadowedhearts.LOGGER.info("Battle patched for shadowengine pseudo weather");
    }

    private static void patchFieldAddPseudoWeatherDebug(Path fieldPath) throws IOException {
        if (!Files.isRegularFile(fieldPath, new LinkOption[0])) {
            return;
        }
        String content = Files.readString(fieldPath, StandardCharsets.UTF_8);
        if (content.contains("status.id === 'shadowengine'")) {
            Shadowedhearts.LOGGER.info("Field already patched for shadowengine pseudo weather, skipping patch");
            return;
        }
        String needle = "if (!this.battle.singleEvent(\"FieldStart\", status, state, this, source, sourceEffect)) {\n      delete this.pseudoWeather[status.id];\n      return false;\n    }\n    this.battle.runEvent(\"PseudoWeatherChange\", source, source, status);\n    return true;";
        String replacement = "if (!this.battle.singleEvent(\"FieldStart\", status, state, this, source, sourceEffect)) {\n      delete this.pseudoWeather[status.id];\n      return false;\n    }\n    this.battle.runEvent(\"PseudoWeatherChange\", source, source, status);\n    return true;";
        if (content.contains(needle)) {
            String patched = content.replace(needle, replacement);
            Files.writeString(fieldPath, (CharSequence)patched, StandardCharsets.UTF_8, new OpenOption[0]);
            Shadowedhearts.LOGGER.info("Field pseudo weather patch applied successfully");
        }
    }

    private static void patchSideAddCallChoice(Path sidePath) throws IOException {
        if (!Files.isRegularFile(sidePath, new LinkOption[0])) {
            return;
        }
        String content = Files.readString(sidePath, StandardCharsets.UTF_8);
        if (content.contains("case \"call\":")) {
            Shadowedhearts.LOGGER.info("Side already patched for call choice, skipping patch");
            return;
        }
        String needle = "switch (choiceType) {";
        String replacement = "switch (choiceType) {\n        case \"call\":\n          const index = this.getChoiceIndex();\n          if (index >= this.active.length) return this.emitChoiceError(\"Can't call: All Pokemon have already acted\");\n          this.choice.actions.push({choice: \"call\", pokemon: this.active[index]});\n          break;";
        if (content.contains(needle)) {
            String patched = content.replace(needle, replacement);
            Files.writeString(sidePath, (CharSequence)patched, StandardCharsets.UTF_8, new OpenOption[0]);
            Shadowedhearts.LOGGER.info("Side call choice patch applied successfully");
        }
    }

    private static void patchBattleQueueAddCallOrder(Path queuePath) throws IOException {
        if (!Files.isRegularFile(queuePath, new LinkOption[0])) {
            return;
        }
        String content = Files.readString(queuePath, StandardCharsets.UTF_8);
        if (content.contains("call: 200")) {
            Shadowedhearts.LOGGER.info("Battle queue already patched for call order, skipping patch");
            return;
        }
        String needle = "residual: 300";
        String replacement = "residual: 300,\n        call: 200";
        if (content.contains(needle)) {
            String patched = content.replace(needle, replacement);
            Files.writeString(queuePath, (CharSequence)patched, StandardCharsets.UTF_8, new OpenOption[0]);
            Shadowedhearts.LOGGER.info("Battle queue call order patch applied successfully");
        }
    }

    private static void patchBattleAddCallAction(Path battlePath) throws IOException {
        if (!Files.isRegularFile(battlePath, new LinkOption[0])) {
            return;
        }
        String content = Files.readString(battlePath, StandardCharsets.UTF_8);
        if (content.contains("case \"call\":")) {
            Shadowedhearts.LOGGER.info("Battle already patched for call action, skipping patch");
            return;
        }
        String needle = "case \"move\":";
        String replacement = "case \"call\":\n        (this.dex.data.Scripts.shadowedhearts?.call || this.scripts.call).call(this, action.pokemon);\n        break;\n      case \"move\":";
        if (content.contains(needle)) {
            String patched = content.replace(needle, replacement);
            Files.writeString(battlePath, (CharSequence)patched, StandardCharsets.UTF_8, new OpenOption[0]);
            Shadowedhearts.LOGGER.info("Battle call action patch applied successfully");
        }
    }

    public static class DynamicInjector {
        public static void inject(Context context) {
            try {
                if (context == null) {
                    Shadowedhearts.LOGGER.info("Failed to access Showdown context object, skipping injection.");
                    return;
                }
                Value bindings = context.getBindings("js");
                if (!Platform.isModLoaded((String)"mega_showdown")) {
                    context.eval("js", (CharSequence)"if (typeof items === 'undefined') items = require('./data/mods/cobblemon/items');\nif (typeof conditions === 'undefined') conditions = require('./data/mods/cobblemon/conditions');\nif (typeof typechart === 'undefined') typechart = require('./data/mods/cobblemon/typechart');\nif (typeof scripts === 'undefined') scripts = require('./data/mods/cobblemon/scripts');\n\nif (typeof receiveConditionData === 'undefined') {\n    receiveConditionData = function(conditionId, conditionData) {\n        const target = conditions.Conditions || conditions;\n        target[conditionId] = eval(`(${conditionData})`);\n    };\n}\n\nif (typeof receiveTypeChartData === 'undefined') {\n    receiveTypeChartData = function(typeChartId, typeChartData) {\n        const target = typechart.TypeChart || typechart;\n        target[typeChartId] = eval(`(${typeChartData})`);\n    };\n}\n\nif (typeof receiveScriptData === 'undefined') {\n    receiveScriptData = function(scriptId, scriptData) {\n        const newFunctions = eval(`(${scriptData})`);\n        const target = scripts.Scripts || scripts;\n        if (!target[scriptId]) target[scriptId] = {};\n        Object.assign(target[scriptId], newFunctions);\n    };\n}\n\nif (typeof receiveHeldItemData === 'undefined') {\n    receiveHeldItemData = function(itemId, itemData) {\n        const target = items.Items || items;\n        target[itemId] = eval(`(${itemData})`);\n    };\n}");
                }
                if (bindings.hasMember("receiveConditionData")) {
                    Value receiveConditionDataFn = bindings.getMember("receiveConditionData");
                    DynamicInjector.injectCondition(receiveConditionDataFn, "shadowyaura", "/data/shadowedhearts/showdown/conditions/shadowyaura.js");
                    DynamicInjector.injectCondition(receiveConditionDataFn, "hypermode", "/data/shadowedhearts/showdown/conditions/hypermode.js");
                    DynamicInjector.injectCondition(receiveConditionDataFn, "reversemode", "/data/shadowedhearts/showdown/conditions/reversemode.js");
                    DynamicInjector.injectCondition(receiveConditionDataFn, "shadowengine", "/data/shadowedhearts/showdown/conditions/shadowengine.js");
                    Shadowedhearts.LOGGER.info("Injected custom conditions into Showdown...");
                } else {
                    Shadowedhearts.LOGGER.info("Failed to find receiveConditionData function, skipping injection.");
                }
                if (bindings.hasMember("receiveTypeChartData")) {
                    Value receiveTypeChartDataFn = bindings.getMember("receiveTypeChartData");
                    DynamicInjector.injectTypeChart(receiveTypeChartDataFn, "shadow", "/data/shadowedhearts/showdown/typecharts/shadow.js");
                    Shadowedhearts.LOGGER.info("Injected custom typechart into Showdown...");
                } else {
                    Shadowedhearts.LOGGER.info("Failed to find receiveTypeChartData function, skipping injection.");
                }
                if (bindings.hasMember("receiveScriptData")) {
                    Value receiveScriptDataFn = bindings.getMember("receiveScriptData");
                    DynamicInjector.injectScript(receiveScriptDataFn, "shadowedhearts", "/data/shadowedhearts/showdown/scripts/shadowedhearts.js");
                    Shadowedhearts.LOGGER.info("Injected custom scripts into Showdown.");
                } else {
                    Shadowedhearts.LOGGER.info("Failed to find receiveScriptData function, skipping injection.");
                }
                if (bindings.hasMember("receiveHeldItemData")) {
                    Value value = bindings.getMember("receiveHeldItemData");
                }
            }
            catch (Exception e) {
                Shadowedhearts.LOGGER.info("Failed to patch Showdown context object: " + String.valueOf(e));
                e.printStackTrace();
            }
        }

        private static void injectScript(Object fn, String id, String resourcePath) {
            String js = ShowdownRuntimePatcher.readResourceText(resourcePath);
            if (js != null) {
                js = js.replaceAll("//.*", "");
                js = ShowdownRuntimePatcher.extractExportedTemplate(js);
                if (id.equals("shadowedhearts")) {
                    IShadowConfig cfg = ShadowedHeartsConfigs.getInstance().getShadowConfig();
                    String configJs = String.format("\"Config\": { \"callButton\": { \"accuracyBoost\": %b, \"removeSleep\": %b }, \"hyperMode\": { \"enabled\": %b}, \"reverseMode\": { \"enabled\": %b}, \"GOdamageModifier\": { \"enabled\": %b}, \"shadowMoves\": { \"superEffectiveEnabled\": %b } },", cfg.callButtonAccuracyBoost(), cfg.callButtonRemoveSleep(), cfg.hyperModeEnabled(), cfg.reverseModeEnabled(), cfg.goDamageModifierEnabled(), cfg.superEffectiveShadowMovesEnabled());
                    js = js.replaceFirst("\\{", "{" + configJs);
                }
                js = js.replace("\n", " ").replace("\r", "");
                DynamicInjector.executeFn(fn, id, js);
            } else {
                Shadowedhearts.LOGGER.info("Failed to find script resource: " + resourcePath);
            }
        }

        private static void injectCondition(Object fn, String id, String resourcePath) {
            String js = ShowdownRuntimePatcher.readResourceText(resourcePath);
            if (js != null) {
                js = js.replaceAll("//.*", "");
                js = ShowdownRuntimePatcher.extractExportedTemplate(js);
                js = js.replace("\n", " ").replace("\r", "");
                DynamicInjector.executeFn(fn, id, js);
            } else {
                Shadowedhearts.LOGGER.info("Failed to find condition resource: " + resourcePath);
            }
        }

        private static void injectTypeChart(Object fn, String id, String resourcePath) {
            String js = ShowdownRuntimePatcher.readResourceText(resourcePath);
            if (js != null) {
                js = js.replaceAll("//.*", "");
                js = js.replace("\n", " ").replace("\r", "");
                DynamicInjector.executeFn(fn, id, js);
            } else {
                Shadowedhearts.LOGGER.info("Failed to find typechart resource: " + resourcePath);
            }
        }

        private static void executeFn(Object fn, Object ... args) {
            try {
                Method executeMethod = fn.getClass().getMethod("execute", Object[].class);
                executeMethod.invoke(fn, new Object[]{args});
            }
            catch (Exception e) {
                Shadowedhearts.LOGGER.info("Failed to execute Showdown injection function for args: " + Arrays.toString(args));
            }
        }
    }
}

