/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.snag;

import com.jayemceekay.shadowedhearts.core.ModItemComponents;
import com.jayemceekay.shadowedhearts.core.ModItems;
import com.jayemceekay.shadowedhearts.integration.accessories.SnagAccessoryBridgeHolder;
import com.jayemceekay.shadowedhearts.items.SnagMachineItem;
import com.jayemceekay.shadowedhearts.snag.PlayerSnagData;
import com.jayemceekay.shadowedhearts.snag.SnagEnergy;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public class SimplePlayerSnagData
implements PlayerSnagData {
    private final class_1657 player;

    public SimplePlayerSnagData(class_1657 player) {
        this.player = player;
    }

    public class_1799 findMachine() {
        if (this.player == null) {
            return class_1799.field_8037;
        }
        class_1799 accessory = SnagAccessoryBridgeHolder.INSTANCE.getEquippedStack(this.player);
        if (!accessory.method_7960()) {
            return accessory;
        }
        class_1799 off = this.player.method_6079();
        if (!off.method_7960() && (off.method_31574((class_1792)ModItems.SNAG_MACHINE_PROTOTYPE.get()) || off.method_31574((class_1792)ModItems.SNAG_MACHINE_ADVANCED.get()))) {
            return off;
        }
        try {
            class_1661 inv = this.player.method_31548();
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 st = inv.method_5438(i);
                if (st.method_7960() || !st.method_31574((class_1792)ModItems.SNAG_MACHINE_PROTOTYPE.get()) && !st.method_31574((class_1792)ModItems.SNAG_MACHINE_ADVANCED.get())) continue;
                return st;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return class_1799.field_8037;
    }

    private int machineCapacity(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return 0;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof SnagMachineItem) {
            SnagMachineItem sm = (SnagMachineItem)item;
            return Math.max(0, sm.capacity());
        }
        return 1000;
    }

    @Override
    public boolean hasSnagMachine() {
        return !this.findMachine().method_7960();
    }

    public class_1799 getMachineStack() {
        return this.findMachine();
    }

    @Override
    public boolean isArmed() {
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return false;
        }
        Boolean armed = (Boolean)machine.method_57824((class_9331)ModItemComponents.SNAG_ARMED.get());
        return armed != null && armed != false;
    }

    @Override
    public int energy() {
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return 0;
        }
        return SnagEnergy.get(machine);
    }

    @Override
    public int cooldown() {
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return 0;
        }
        Integer cd = (Integer)machine.method_57824((class_9331)ModItemComponents.SNAG_COOLDOWN.get());
        return cd != null ? cd : 0;
    }

    @Override
    public void setArmed(boolean v) {
        if (this.player != null && this.player.method_37908().field_9236) {
            return;
        }
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return;
        }
        machine.method_57379((class_9331)ModItemComponents.SNAG_ARMED.get(), (Object)v);
    }

    @Override
    public void consumeEnergy(int amt) {
        if (this.player != null && this.player.method_37908().field_9236) {
            return;
        }
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return;
        }
        SnagEnergy.consume(machine, amt, this.machineCapacity(machine));
    }

    @Override
    public void addEnergy(int amt) {
        if (this.player != null && this.player.method_37908().field_9236) {
            return;
        }
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return;
        }
        int capacity = this.machineCapacity(machine);
        int cur = SnagEnergy.get(machine);
        SnagEnergy.set(machine, cur + amt, capacity);
    }

    @Override
    public void setCooldown(int ticks) {
        if (this.player != null && this.player.method_37908().field_9236) {
            return;
        }
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return;
        }
        machine.method_57379((class_9331)ModItemComponents.SNAG_COOLDOWN.get(), (Object)Math.max(0, ticks));
    }

    @Override
    public boolean lastSyncedEligibility() {
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return false;
        }
        Boolean eligible = (Boolean)machine.method_57824((class_9331)ModItemComponents.SNAG_ELIGIBLE.get());
        return eligible != null && eligible != false;
    }

    @Override
    public void setLastSyncedEligibility(boolean v) {
        if (this.player != null && this.player.method_37908().field_9236) {
            return;
        }
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return;
        }
        machine.method_57379((class_9331)ModItemComponents.SNAG_ELIGIBLE.get(), (Object)v);
    }

    @Override
    public int failedSnagAttempts() {
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return 0;
        }
        Integer attempts = (Integer)machine.method_57824((class_9331)ModItemComponents.SNAG_FAIL_ATTEMPTS.get());
        return attempts != null ? attempts : 0;
    }

    @Override
    public void incrementFailedSnagAttempts() {
        if (this.player != null && this.player.method_37908().field_9236) {
            return;
        }
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return;
        }
        int current = this.failedSnagAttempts();
        machine.method_57379((class_9331)ModItemComponents.SNAG_FAIL_ATTEMPTS.get(), (Object)(current + 1));
    }

    @Override
    public void resetFailedSnagAttempts() {
        if (this.player != null && this.player.method_37908().field_9236) {
            return;
        }
        class_1799 machine = this.findMachine();
        if (machine.method_7960()) {
            return;
        }
        machine.method_57379((class_9331)ModItemComponents.SNAG_FAIL_ATTEMPTS.get(), (Object)0);
    }
}

