/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.snag;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.properties.UncatchableProperty;
import com.jayemceekay.shadowedhearts.client.snag.ClientSnagState;
import com.jayemceekay.shadowedhearts.snag.SnagCaps;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public final class SnagBattleUtil {
    private SnagBattleUtil() {
    }

    public static PokemonBattle getBattle(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return null;
        }
        class_3222 sp = (class_3222)player;
        try {
            return BattleRegistry.getBattleByParticipatingPlayer((class_3222)sp);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isInTrainerBattle(class_1657 player) {
        PokemonBattle battle = SnagBattleUtil.getBattle(player);
        return battle != null && battle.isPvN();
    }

    public static boolean hasEligibleShadowOpponent(class_1657 player) {
        PokemonBattle battle = SnagBattleUtil.getBattle(player);
        if (battle == null) {
            return false;
        }
        BattleActor actor = battle.getActor((class_3222)player);
        if (actor == null) {
            return false;
        }
        BattleSide otherSide = actor.getSide().getOppositeSide();
        boolean allNpc = true;
        for (BattleActor a : otherSide.getActors()) {
            if (a != null && a.getType() == ActorType.NPC) continue;
            allNpc = false;
            break;
        }
        if (!allNpc) {
            return false;
        }
        for (ActiveBattlePokemon abp : otherSide.getActivePokemon()) {
            PokemonEntity pe;
            if (abp == null || abp.getBattlePokemon() == null) continue;
            Pokemon effected = abp.getBattlePokemon().getEffectedPokemon();
            Set aspects = effected.getAspects();
            PokemonEntity entity = effected.getEntity();
            if (aspects == null || !aspects.contains("shadowedhearts:shadow") || entity instanceof PokemonEntity && !UncatchableProperty.INSTANCE.isCatchable(pe = entity)) continue;
            return true;
        }
        return false;
    }

    public static boolean canShowSnagButton(class_1657 player) {
        if (player == null) {
            return false;
        }
        if (player.method_37908().field_9236) {
            return ClientSnagState.isEligible();
        }
        if (!SnagCaps.hasMachineAvailable(player)) {
            return false;
        }
        if (!SnagBattleUtil.isInTrainerBattle(player)) {
            return false;
        }
        return SnagBattleUtil.hasEligibleShadowOpponent(player);
    }
}

