/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.snag;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.jayemceekay.shadowedhearts.advancements.ModCriteriaTriggers;
import com.jayemceekay.shadowedhearts.config.ISnagConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.network.ShadowedHeartsNetwork;
import com.jayemceekay.shadowedhearts.network.SnagArmedPacket;
import com.jayemceekay.shadowedhearts.network.SnagEligibilityPacket;
import com.jayemceekay.shadowedhearts.snag.PlayerSnagData;
import com.jayemceekay.shadowedhearts.snag.SnagBattleUtil;
import com.jayemceekay.shadowedhearts.snag.SnagCaps;
import dev.architectury.event.events.common.TickEvent;
import java.util.List;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class SnagEvents {
    private SnagEvents() {
    }

    public static void init() {
        TickEvent.PLAYER_POST.register(SnagEvents::onPlayerPostTick);
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, e -> {
            ISnagConfig cfg = ShadowedHeartsConfigs.getInstance().getSnagConfig();
            if (!cfg.rechargeOnVictory()) {
                return Unit.INSTANCE;
            }
            PokemonBattle battle = e.getBattle();
            if (battle == null) {
                return Unit.INSTANCE;
            }
            if (battle.isPvP() && !cfg.rechargeInPvp()) {
                return Unit.INSTANCE;
            }
            int nonPlayerActorCount = 0;
            int levelSum = 0;
            int levelCount = 0;
            boolean wildShadowDefeated = false;
            for (BattleActor loser : e.getLosers()) {
                if (loser == null || loser.getType() == ActorType.PLAYER) continue;
                ++nonPlayerActorCount;
                List list = loser.getPokemonList();
                if (list == null) continue;
                for (BattlePokemon bp : list) {
                    if (bp == null) continue;
                    try {
                        int lvl = bp.getEffectedPokemon().getLevel();
                        if (lvl > 0) {
                            levelSum += lvl;
                            ++levelCount;
                        }
                        if (loser.getType() != ActorType.WILD || !bp.getEffectedPokemon().getAspects().contains("shadowedhearts:shadow")) continue;
                        wildShadowDefeated = true;
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (nonPlayerActorCount <= 0 && !battle.isPvP()) {
                return Unit.INSTANCE;
            }
            if (wildShadowDefeated) {
                for (BattleActor winner : e.getWinners()) {
                    PlayerBattleActor pba;
                    if (!(winner instanceof PlayerBattleActor) || (pba = (PlayerBattleActor)winner).getEntity() == null) continue;
                    ModCriteriaTriggers.triggerWildShadowDefeated(pba.getEntity());
                }
            }
            double avgLevel = levelCount > 0 ? (double)levelSum / (double)levelCount : 1.0;
            double raw = (double)cfg.rechargeBase() + avgLevel * cfg.rechargePerLevel() + (double)(nonPlayerActorCount * cfg.rechargePerNpc());
            int award = (int)Math.round(raw);
            award = Math.max(cfg.rechargeMin(), Math.min(award, cfg.rechargeMax()));
            if (award <= 0) {
                return Unit.INSTANCE;
            }
            for (BattleActor winner : e.getWinners()) {
                PlayerSnagData cap;
                PlayerBattleActor pba;
                class_3222 sp;
                if (winner == null || winner.getType() != ActorType.PLAYER || !(winner instanceof PlayerBattleActor) || (sp = (pba = (PlayerBattleActor)winner).getEntity()) == null || !(cap = SnagCaps.get((class_1657)sp)).hasSnagMachine()) continue;
                int before = cap.energy();
                cap.addEnergy(award);
                int after = cap.energy();
                int gained = Math.max(0, after - before);
                if (gained <= 0) continue;
                sp.method_43496((class_2561)class_2561.method_43469((String)"message.shadowedhearts.snag_machine.recharged", (Object[])new Object[]{gained, after}));
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, e -> {
            if (e.getPokemon().getAspects().contains("shadowedhearts:shadow")) {
                ModCriteriaTriggers.triggerSnagFromNpc(e.getPlayer());
                e.getPokemon().getCustomProperties().removeIf(p -> p.asString().equals("battleClone") || p.asString().equals("uncatchable"));
            }
            return Unit.INSTANCE;
        });
    }

    private static void onPlayerPostTick(class_1657 player) {
        class_3222 sp;
        boolean eligible;
        if (player == null || player.method_37908().field_9236) {
            return;
        }
        PlayerSnagData cap = SnagCaps.get(player);
        int cd = cap.cooldown();
        if (cd > 0) {
            cap.setCooldown(cd - 1);
        }
        if (player instanceof class_3222 && (eligible = SnagBattleUtil.canShowSnagButton((class_1657)(sp = (class_3222)player))) != cap.lastSyncedEligibility()) {
            cap.setLastSyncedEligibility(eligible);
            ShadowedHeartsNetwork.sendToPlayer(sp, new SnagEligibilityPacket(eligible));
        }
        if (cap.isArmed() && !SnagBattleUtil.isInTrainerBattle(player)) {
            cap.setArmed(false);
            if (player instanceof class_3222) {
                sp = (class_3222)player;
                ShadowedHeartsNetwork.sendToPlayer(sp, new SnagArmedPacket(false));
            }
        } else if (cap.isArmed() && player instanceof class_3222) {
            BattleActor actor;
            sp = (class_3222)player;
            PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayerId((UUID)player.method_5667());
            if (battle != null && (actor = battle.getActor(sp)) != null) {
                try {
                    if (!actor.canFitForcedAction()) {
                        cap.setArmed(false);
                        ShadowedHeartsNetwork.sendToPlayer(sp, new SnagArmedPacket(false));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

