/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.storage.purification;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.ai.strongBattleAI.AIUtility;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0017\u001a\u00020\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001b\u001a\u00020\u001a2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010\u001f\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00192\u0006\u0010\u001e\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/jayemceekay/shadowedhearts/storage/purification/PurificationMath;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "p", "", "Lcom/cobblemon/mod/common/api/types/ElementalType;", "pokemonTypes", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Ljava/util/List;", "attacker", "defenderTypes", "", "effectiveness", "(Lcom/cobblemon/mod/common/api/types/ElementalType;Ljava/util/List;)D", "mult", "Lcom/jayemceekay/shadowedhearts/storage/purification/PurificationMath$Matchup;", "toMatchup", "(D)Lcom/jayemceekay/shadowedhearts/storage/purification/PurificationMath$Matchup;", "supports", "clockwiseSupportMatchups", "(Ljava/util/List;)Ljava/util/List;", "", "isPerfectSet", "(Ljava/util/List;)Z", "", "", "facingSupportIndex", "([Lcom/cobblemon/mod/common/pokemon/Pokemon;)I", "shadow", "globalPerfectSets", "computePurificationDeltaForSet", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;[Lcom/cobblemon/mod/common/pokemon/Pokemon;I)I", "Matchup", "ShadowedHearts-common"})
@SourceDebugExtension(value={"SMAP\nPurificationMath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PurificationMath.kt\ncom/jayemceekay/shadowedhearts/storage/purification/PurificationMath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1740#2,3:171\n*S KotlinDebug\n*F\n+ 1 PurificationMath.kt\ncom/jayemceekay/shadowedhearts/storage/purification/PurificationMath\n*L\n92#1:171,3\n*E\n"})
public final class PurificationMath {
    @NotNull
    public static final PurificationMath INSTANCE = new PurificationMath();

    private PurificationMath() {
    }

    private final List<ElementalType> pokemonTypes(Pokemon p) {
        return CollectionsKt.toList((Iterable)p.getTypes());
    }

    public final double effectiveness(@NotNull ElementalType attacker, @NotNull List<ElementalType> defenderTypes) {
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        Intrinsics.checkNotNullParameter(defenderTypes, (String)"defenderTypes");
        if (Intrinsics.areEqual((Object)attacker, (Object)ElementalTypes.NORMAL) && defenderTypes.size() == 1 && Intrinsics.areEqual((Object)defenderTypes.get(0), (Object)ElementalTypes.NORMAL)) {
            return 2.0;
        }
        double product = 1.0;
        boolean hasWeak = false;
        boolean hasResist = false;
        for (ElementalType def : defenderTypes) {
            double m = AIUtility.INSTANCE.getDamageMultiplier(attacker, def);
            if (m == 0.0) {
                hasResist = true;
            } else if (m > 1.0) {
                hasWeak = true;
            } else if (m < 1.0) {
                hasResist = true;
            }
            product *= m == 0.0 ? 0.5 : m;
        }
        if (product == 1.0 && hasWeak && hasResist) {
            return 2.0;
        }
        return product;
    }

    @NotNull
    public final Matchup toMatchup(double mult) {
        return mult > 1.0 ? Matchup.SUPER_EFFECTIVE : (mult < 1.0 ? Matchup.NOT_VERY_EFFECTIVE : Matchup.NEUTRAL);
    }

    @NotNull
    public final List<Matchup> clockwiseSupportMatchups(@NotNull List<? extends Pokemon> supports) {
        Intrinsics.checkNotNullParameter(supports, (String)"supports");
        if (supports.size() < 2) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Matchup> res = new ArrayList<Matchup>(supports.size());
        int n = ((Collection)supports).size();
        for (int i = 0; i < n; ++i) {
            Pokemon a = supports.get(i);
            Pokemon b = supports.get((i + 1) % supports.size());
            List<ElementalType> atkTypes = this.pokemonTypes(a);
            List<ElementalType> defTypes = this.pokemonTypes(b);
            double best = 1.0;
            for (ElementalType atk : atkTypes) {
                double m = this.effectiveness(atk, defTypes);
                if (!(m > best)) continue;
                best = m;
            }
            res.add(this.toMatchup(best));
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isPerfectSet(@NotNull List<? extends Pokemon> supports) {
        boolean bl;
        Intrinsics.checkNotNullParameter(supports, (String)"supports");
        if (supports.size() != 4) {
            return false;
        }
        Set seen = new LinkedHashSet();
        for (Pokemon pokemon : supports) {
            for (ElementalType t : this.pokemonTypes(pokemon)) {
                if (seen.add(t)) continue;
                return false;
            }
        }
        List<Matchup> edges = this.clockwiseSupportMatchups(supports);
        if (edges.size() != 4) return false;
        Iterable iterable = edges;
        boolean $i$f$all = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return true;
        }
        Iterator iterator2 = iterable.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            Matchup it = (Matchup)((Object)element$iv);
            boolean bl2 = false;
            if (it != Matchup.SUPER_EFFECTIVE) return false;
            bl = true;
        } while (bl);
        return false;
    }

    public final int facingSupportIndex(@NotNull Pokemon[] supports) {
        Intrinsics.checkNotNullParameter((Object)supports, (String)"supports");
        if (!(supports.length == 0) && supports[0] != null) {
            return 0;
        }
        int n = supports.length;
        for (int i = 0; i < n; ++i) {
            if (supports[i] == null) continue;
            return i;
        }
        return -1;
    }

    public final int computePurificationDeltaForSet(@Nullable Pokemon shadow, @NotNull Pokemon[] supports, int globalPerfectSets) {
        Intrinsics.checkNotNullParameter((Object)supports, (String)"supports");
        List ring = ArraysKt.filterNotNull((Object[])supports);
        if (shadow == null || ring.isEmpty()) {
            return 0;
        }
        int base = switch (ring.size()) {
            case 1 -> 10;
            case 2 -> 27;
            case 3 -> 49;
            default -> 96;
        };
        List<Matchup> edges = this.clockwiseSupportMatchups(ring);
        int sum = 0;
        for (Matchup m : edges) {
            switch (WhenMappings.$EnumSwitchMapping$0[m.ordinal()]) {
                case 1: {
                    sum += 6;
                    break;
                }
                case 2: {
                    sum -= 3;
                }
            }
        }
        if (ring.size() == 4) {
            sum *= 2;
        }
        int value = base + sum;
        int faceIdx = this.facingSupportIndex(supports);
        if (faceIdx >= 0) {
            List<ElementalType> shadowTypes = this.pokemonTypes(shadow);
            Pokemon pokemon = supports[faceIdx];
            Intrinsics.checkNotNull((Object)pokemon);
            List<ElementalType> defTypes = this.pokemonTypes(pokemon);
            double best = 1.0;
            for (ElementalType atk : shadowTypes) {
                double m = this.effectiveness(atk, defTypes);
                if (!(m > best)) continue;
                best = m;
            }
            value = switch (WhenMappings.$EnumSwitchMapping$0[this.toMatchup(best).ordinal()]) {
                case 1 -> (int)Math.ceil((double)value * 1.3333333333333333);
                case 2 -> (int)Math.ceil((double)value * 0.6666666666666666);
                default -> value;
            };
        }
        boolean isPerfect = this.isPerfectSet(ring);
        if (globalPerfectSets >= 2 && isPerfect) {
            int bonus = switch (globalPerfectSets) {
                case 2 -> 1;
                case 3 -> 5;
                case 4 -> 10;
                case 5 -> 15;
                case 6 -> 25;
                case 7 -> 35;
                case 8 -> 50;
                default -> 100;
            };
            value += bonus;
        }
        return -value;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jayemceekay/shadowedhearts/storage/purification/PurificationMath$Matchup;", "", "<init>", "(Ljava/lang/String;I)V", "SUPER_EFFECTIVE", "NEUTRAL", "NOT_VERY_EFFECTIVE", "ShadowedHearts-common"})
    public static final class Matchup
    extends Enum<Matchup> {
        public static final /* enum */ Matchup SUPER_EFFECTIVE = new Matchup();
        public static final /* enum */ Matchup NEUTRAL = new Matchup();
        public static final /* enum */ Matchup NOT_VERY_EFFECTIVE = new Matchup();
        private static final /* synthetic */ Matchup[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Matchup[] values() {
            return (Matchup[])$VALUES.clone();
        }

        public static Matchup valueOf(String value) {
            return Enum.valueOf(Matchup.class, value);
        }

        @NotNull
        public static EnumEntries<Matchup> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = matchupArray = new Matchup[]{Matchup.SUPER_EFFECTIVE, Matchup.NEUTRAL, Matchup.NOT_VERY_EFFECTIVE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Matchup.values().length];
            try {
                nArray[Matchup.SUPER_EFFECTIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Matchup.NOT_VERY_EFFECTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

