/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public final class HeldItemAnchorCache {
    public static int frameId = 0;
    private static final Object2ObjectMap<UUID, Anchor> CACHE = new Object2ObjectOpenHashMap();
    private static volatile Object currentLevelIdentity = null;
    private static long lastPruneMs = 0L;
    private static final int MAX_SIZE = 128;
    private static final long STALE_MS = 10000L;

    public static void capture(class_1657 p, class_4587 ps, int frameId) {
        class_638 level = class_310.method_1551().field_1687;
        if (level != currentLevelIdentity) {
            CACHE.clear();
            currentLevelIdentity = level;
        }
        long nowMs = System.currentTimeMillis();
        class_4184 cam = class_310.method_1551().field_1773.method_19418();
        class_243 camPos = cam.method_19326();
        Matrix4f m = new Matrix4f((Matrix4fc)ps.method_23760().method_23761());
        Vector3f o = m.transformPosition(new Vector3f(0.0f, 0.0f, 0.0f));
        class_243 world = camPos.method_1031((double)o.x, (double)o.y, (double)o.z);
        float scale = HeldItemAnchorCache.extractApproxUniformScale(m);
        CACHE.put((Object)p.method_5667(), (Object)new Anchor(world, scale, frameId, nowMs));
        HeldItemAnchorCache.pruneIfNeeded(nowMs);
    }

    @Nullable
    public static Anchor get(class_1657 p, int frameId) {
        long nowMs = System.currentTimeMillis();
        HeldItemAnchorCache.pruneIfNeeded(nowMs);
        Anchor a = (Anchor)CACHE.get((Object)p.method_5667());
        if (a == null) {
            return null;
        }
        CACHE.put((Object)p.method_5667(), (Object)new Anchor(a.worldPos(), a.approxScale(), a.frameId(), nowMs));
        return a;
    }

    private static float extractApproxUniformScale(Matrix4f m) {
        Vector3f x = m.transformDirection(new Vector3f(1.0f, 0.0f, 0.0f));
        Vector3f y = m.transformDirection(new Vector3f(0.0f, 1.0f, 0.0f));
        Vector3f z = m.transformDirection(new Vector3f(0.0f, 0.0f, 1.0f));
        return (x.length() + y.length() + z.length()) / 3.0f;
    }

    private static void pruneIfNeeded(long nowMs) {
        if (nowMs - lastPruneMs < 1000L && CACHE.size() <= 128) {
            return;
        }
        lastPruneMs = nowMs;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            CACHE.clear();
            return;
        }
        HashSet<UUID> livePlayers = new HashSet<UUID>();
        for (class_742 pl : level.method_18456()) {
            livePlayers.add(pl.method_5667());
        }
        ObjectIterator it = CACHE.object2ObjectEntrySet().iterator();
        while (it.hasNext()) {
            Object2ObjectMap.Entry e = (Object2ObjectMap.Entry)it.next();
            UUID id = (UUID)e.getKey();
            Anchor a = (Anchor)e.getValue();
            if (livePlayers.contains(id) && nowMs - a.lastSeenMs() <= 10000L) continue;
            it.remove();
        }
        if (CACHE.size() > 128) {
            ArrayList<AnchorWithId> list = new ArrayList<AnchorWithId>(CACHE.size());
            for (Object2ObjectMap.Entry e : CACHE.object2ObjectEntrySet()) {
                list.add(new AnchorWithId((UUID)e.getKey(), (Anchor)e.getValue()));
            }
            list.sort(Comparator.comparingLong(x -> x.anchor.lastSeenMs()));
            int toRemove = CACHE.size() - 128;
            for (int i = 0; i < toRemove; ++i) {
                CACHE.remove((Object)((AnchorWithId)list.get((int)i)).id);
            }
        }
    }

    public record Anchor(class_243 worldPos, float approxScale, int frameId, long lastSeenMs) {
    }

    private record AnchorWithId(UUID id, Anchor anchor) {
    }
}

