/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.worldgen;

import com.jayemceekay.shadowedhearts.config.IWorldAlterationConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.core.ModBlocks;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class CraterGenerator {
    private static final Random RANDOM = new Random();

    public static void generateCrater(class_1936 level, class_2338 center) {
        CraterGenerator.generateSlicedCrater(level, null, center, class_5819.method_43049((long)new Random().nextLong()));
    }

    public static void generateSlicedCrater(class_1936 level, class_1923 chunkPos, class_2338 center, class_5819 randomSource) {
        IWorldAlterationConfig config = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration();
        long seed = (long)center.method_10263() * 3121L + (long)center.method_10260() * 4961L + (long)center.method_10264() * 123L;
        class_5819 deterministicRandom = class_5819.method_43049((long)seed);
        int radius = config.minCraterRadius() + deterministicRandom.method_43048(config.maxCraterRadius() - config.minCraterRadius() + 1);
        int depth = radius / 2;
        double angleX = (deterministicRandom.method_43058() - 0.5) * 0.5;
        double angleZ = (deterministicRandom.method_43058() - 0.5) * 0.5;
        int checkRadius = radius + 4;
        int minX = chunkPos != null ? chunkPos.method_8326() : center.method_10263() - checkRadius;
        int maxX = chunkPos != null ? chunkPos.method_8327() : center.method_10263() + checkRadius;
        int minZ = chunkPos != null ? chunkPos.method_8328() : center.method_10260() - checkRadius;
        int maxZ = chunkPos != null ? chunkPos.method_8329() : center.method_10260() + checkRadius;
        class_2680 centerState = CraterGenerator.safeGetBlockState(level, chunkPos, center);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                double relX = x - center.method_10263();
                double relZ = z - center.method_10260();
                if (Math.abs(relX) > (double)checkRadius || Math.abs(relZ) > (double)checkRadius) continue;
                block2: for (int yOffset = -depth; yOffset <= radius / 4; ++yOffset) {
                    double distSq;
                    double shiftedX = relX - (double)yOffset * angleX;
                    double shiftedZ = relZ - (double)yOffset * angleZ;
                    double columnNoise = 0.8;
                    class_5819 noiseRand = class_5819.method_43049((long)((long)x * 31L + (long)z * 17L + seed));
                    columnNoise += noiseRand.method_43058() * 0.2;
                    columnNoise += noiseRand.method_43058() * 0.15;
                    if (!((distSq = shiftedX * shiftedX / ((double)(radius * radius) * (columnNoise *= 0.9 + noiseRand.method_43058() * 0.2)) + (double)(yOffset * yOffset) / (double)(depth * depth) + shiftedZ * shiftedZ / ((double)(radius * radius) * columnNoise)) <= 1.0)) continue;
                    class_2338 pos = center.method_10069((int)relX, yOffset, (int)relZ);
                    if (yOffset > 0) continue;
                    class_2680 currentState = CraterGenerator.safeGetBlockState(level, chunkPos, pos);
                    if (currentState.method_26227().method_15769()) {
                        if (CraterGenerator.shouldFillWithWater(level, chunkPos, pos, centerState)) {
                            CraterGenerator.safeSetBlock(level, chunkPos, pos, class_2246.field_10382.method_9564(), 3);
                        } else {
                            CraterGenerator.safeSetBlock(level, chunkPos, pos, class_2246.field_10124.method_9564(), 3);
                        }
                    }
                    int moveUp = 1;
                    while (center.method_10264() + yOffset + moveUp <= center.method_10264() + radius) {
                        double slantX = (double)moveUp * angleX;
                        double slantZ = (double)moveUp * angleZ;
                        int clearRange = 1 + moveUp / 4;
                        for (int dx = -clearRange; dx <= clearRange; ++dx) {
                            for (int dz = -clearRange; dz <= clearRange; ++dz) {
                                double aboveShiftedZ;
                                double aboveY;
                                double aboveShiftedX;
                                double aboveDistSq;
                                class_2338 abovePos = center.method_10069((int)(relX + slantX + (double)dx), yOffset + moveUp, (int)(relZ + slantZ + (double)dz));
                                if (chunkPos != null && !CraterGenerator.isWithinChunk(abovePos, chunkPos) || (aboveDistSq = (aboveShiftedX = relX - (double)yOffset * angleX + (double)dx) * aboveShiftedX / ((double)(radius * radius) * columnNoise) + (aboveY = (double)(yOffset + moveUp)) * aboveY / (double)(radius * radius) + (aboveShiftedZ = relZ - (double)yOffset * angleZ + (double)dz) * aboveShiftedZ / ((double)(radius * radius) * columnNoise)) > 1.0) continue;
                                class_2680 stateAbove = CraterGenerator.safeGetBlockState(level, chunkPos, abovePos);
                                if (dx != 0 || dz != 0 || !stateAbove.method_26215() || yOffset + moveUp > 5) {
                                    // empty if block
                                }
                                if (stateAbove.method_26215() || stateAbove.method_51176()) continue;
                                class_2680 fillState = CraterGenerator.shouldFillWithWater(level, chunkPos, abovePos, centerState) ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
                                CraterGenerator.safeSetBlock(level, chunkPos, abovePos, fillState, 3);
                            }
                        }
                        if (moveUp > 20 && moveUp % 5 == 0) {
                            class_2338 checkPos = center.method_10069((int)(relX + (double)(yOffset + moveUp) * angleX), yOffset + moveUp, (int)(relZ + (double)(yOffset + moveUp) * angleZ));
                            if ((chunkPos == null || CraterGenerator.isWithinChunk(checkPos, chunkPos)) && CraterGenerator.safeGetBlockState(level, chunkPos, checkPos).method_26215() && CraterGenerator.safeGetBlockState(level, chunkPos, checkPos.method_10086(10)).method_26215()) continue block2;
                        }
                        ++moveUp;
                    }
                }
            }
        }
        int coreXOffset = (int)((double)(-depth) * angleX);
        int coreZOffset = (int)((double)(-depth) * angleZ);
        CraterGenerator.generateCore(level, chunkPos, center.method_10069(coreXOffset, -depth + 1, coreZOffset), radius, seed);
    }

    private static void generateCore(class_1936 level, class_1923 chunkPos, class_2338 center, int radius, long seed) {
        int blobRadius;
        class_2680 coreBlock = ((class_2248)ModBlocks.SHADOWFALL_METEOROID.get()).method_9564();
        class_5819 random = class_5819.method_43049((long)(seed ^ 1L));
        int blobSize = 5 + random.method_43048(4);
        if (radius > 15) {
            blobSize += random.method_43048(radius / 10);
        }
        if ((blobRadius = blobSize / 2) < 1) {
            blobRadius = 1;
        }
        for (int x = -blobRadius - 1; x <= blobRadius + 1; ++x) {
            for (int y = -blobRadius - 1; y <= blobRadius + 1; ++y) {
                for (int z = -blobRadius - 1; z <= blobRadius + 1; ++z) {
                    class_2338 pos = center.method_10069(x, y - 1, z);
                    if (chunkPos != null && !CraterGenerator.isWithinChunk(pos, chunkPos)) continue;
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    class_5819 noiseRand = class_5819.method_43049((long)((long)x * 3121L + (long)y * 4961L + (long)z * 123L + seed));
                    double noise = 0.0;
                    noise += noiseRand.method_43058() * 0.5;
                    noise += noiseRand.method_43058() * 0.3;
                    double targetRadius = (double)blobSize / 2.0;
                    double noiseFactor = 0.6 + (noise += noiseRand.method_43058() * 0.2) * 0.6;
                    double threshold = targetRadius * noiseFactor;
                    if (!(dist <= threshold)) continue;
                    CraterGenerator.safeSetBlock(level, chunkPos, pos, coreBlock, 3);
                }
            }
        }
    }

    private static boolean shouldFillWithWater(class_1936 level, class_1923 chunkPos, class_2338 pos, class_2680 centerState) {
        if (!centerState.method_26227().method_15769()) {
            return true;
        }
        class_2338 above = pos.method_10084();
        if ((chunkPos == null || CraterGenerator.isWithinChunk(above, chunkPos)) && !level.method_8316(above).method_15769()) {
            return true;
        }
        int waterCount = 0;
        int airCount = 0;
        int range = 2;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    class_2338 neighbor = pos.method_10069(x, y, z);
                    class_2680 state = CraterGenerator.safeGetBlockState(level, chunkPos, neighbor);
                    if (!state.method_26227().method_15769()) {
                        ++waterCount;
                        continue;
                    }
                    if (!state.method_26215()) continue;
                    ++airCount;
                }
            }
        }
        return waterCount > airCount;
    }

    private static boolean isWithinChunk(class_2338 pos, class_1923 chunkPos) {
        return pos.method_10263() >= chunkPos.method_8326() && pos.method_10263() <= chunkPos.method_8327() && pos.method_10260() >= chunkPos.method_8328() && pos.method_10260() <= chunkPos.method_8329();
    }

    private static class_2680 safeGetBlockState(class_1936 level, class_1923 chunkPos, class_2338 pos) {
        if (chunkPos != null && !CraterGenerator.isWithinChunk(pos, chunkPos)) {
            return class_2246.field_10124.method_9564();
        }
        if (level instanceof class_5281) {
            class_5281 wgl = (class_5281)level;
            if (wgl.method_37368(pos)) {
                return level.method_8320(pos);
            }
        } else {
            return level.method_8320(pos);
        }
        return class_2246.field_10124.method_9564();
    }

    private static void safeSetBlock(class_1936 level, class_1923 chunkPos, class_2338 pos, class_2680 state, int flags) {
        if (chunkPos != null && !CraterGenerator.isWithinChunk(pos, chunkPos)) {
            return;
        }
        if (level instanceof class_5281) {
            class_5281 wgl = (class_5281)level;
            if (wgl.method_37368(pos)) {
                level.method_8652(pos, state, flags);
            }
        } else {
            level.method_8652(pos, state, flags);
        }
    }
}

