/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.worldgen;

import com.jayemceekay.shadowedhearts.config.IWorldAlterationConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.worldgen.PlayerActivityHeatmap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class ImpactLocationSelector {
    private static final Random RANDOM = new Random();

    public static Optional<class_2338> selectLocation(class_3218 level) {
        if (level.method_18456().isEmpty()) {
            return Optional.empty();
        }
        IWorldAlterationConfig config = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration();
        class_3222 targetPlayer = (class_3222)level.method_18456().get(RANDOM.nextInt(level.method_18456().size()));
        for (int i = 0; i < 10; ++i) {
            int z;
            double angle = RANDOM.nextDouble() * 2.0 * Math.PI;
            double distance = (double)config.minImpactDistanceToPlayer() + RANDOM.nextDouble() * (double)(config.maxImpactDistanceToPlayer() - config.minImpactDistanceToPlayer());
            int x = (int)(targetPlayer.method_23317() + Math.cos(angle) * distance);
            class_2338 pos = new class_2338(x, 0, z = (int)(targetPlayer.method_23321() + Math.sin(angle) * distance));
            Optional<class_2338> impactPos = ImpactLocationSelector.findImpactPos((class_1936)level, pos);
            if (!impactPos.isPresent()) continue;
            return impactPos;
        }
        return Optional.empty();
    }

    public static Optional<class_2338> findImpactPos(class_1936 level, class_2338 pos) {
        int surfaceY;
        class_2338 surfacePos;
        boolean isWater;
        int y;
        class_2338 impactPos;
        class_5281 worldGenLevel;
        if (level instanceof class_5281 && !(worldGenLevel = (class_5281)level).method_37368(pos)) {
            return Optional.empty();
        }
        class_1923 chunkPos = new class_1923(pos);
        int x = pos.method_10263();
        int z = pos.method_10260();
        if (ImpactLocationSelector.isSafeLocation(level, chunkPos, pos) && ImpactLocationSelector.canSeeSkyOrWater(level, impactPos = new class_2338(x, y = (isWater = level.method_8316((surfacePos = new class_2338(x, surfaceY = level.method_8624(class_2902.class_2903.field_13203, x, z), z)).method_10074()).method_15767(class_3486.field_15517)) ? level.method_8624(class_2902.class_2903.field_13200, x, z) : surfaceY, z))) {
            return Optional.of(impactPos);
        }
        return Optional.empty();
    }

    private static boolean canSeeSkyOrWater(class_1936 level, class_2338 pos) {
        int highestBlock = level.method_8624(class_2902.class_2903.field_13197, pos.method_10263(), pos.method_10260());
        if (highestBlock <= pos.method_10264()) {
            return true;
        }
        for (int y = pos.method_10264() + 1; y < highestBlock; ++y) {
            class_2338 checkPos = new class_2338(pos.method_10263(), y, pos.method_10260());
            class_2680 state = level.method_8320(checkPos);
            if (state.method_26215() || state.method_26227().method_15767(class_3486.field_15517)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafeLocation(class_1936 level, class_1923 chunkPos, class_2338 pos) {
        if (level instanceof class_3218) {
            class_2338 spawnPos;
            class_3218 serverLevel = (class_3218)level;
            if (serverLevel.method_14178().method_46642() != null && serverLevel.method_14178().method_12129().method_12100((class_5539)serverLevel) > 0 && pos.method_19771((class_2382)(spawnPos = serverLevel.method_43126()), (double)ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration().minImpactDistanceToSpawn())) {
                return false;
            }
            if (PlayerActivityHeatmap.isCivilized(serverLevel, chunkPos.field_9181, chunkPos.field_9180)) {
                return false;
            }
            IWorldAlterationConfig config = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration();
            class_6880 biome = serverLevel.method_23753(pos);
            if (!ImpactLocationSelector.isBiomeAllowed((class_6880<class_1959>)biome, config.meteoroidBiomeWhitelist(), config.meteoroidBiomeBlacklist())) {
                return false;
            }
            for (class_3222 player : serverLevel.method_18456()) {
                if (!pos.method_19771((class_2382)player.method_24515(), (double)ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration().minImpactDistanceToPlayer())) continue;
                return false;
            }
            int structureDistance = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration().minImpactDistanceToStructures();
            if (structureDistance > 0) {
                for (int dx = -structureDistance; dx <= structureDistance; dx += 16) {
                    for (int dz = -structureDistance; dz <= structureDistance; dz += 16) {
                        class_2338 checkPos = pos.method_10069(dx, 0, dz);
                        if (!serverLevel.method_27056().method_38852(checkPos)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static boolean isBiomeAllowed(class_6880<class_1959> biome, List<? extends String> whitelist, List<? extends String> blacklist) {
        if (!whitelist.isEmpty()) {
            boolean whitelisted = false;
            for (String string : whitelist) {
                if (!ImpactLocationSelector.matches(biome, string)) continue;
                whitelisted = true;
                break;
            }
            if (!whitelisted) {
                return false;
            }
        }
        for (String string : blacklist) {
            if (!ImpactLocationSelector.matches(biome, string)) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(class_6880<class_1959> biome, String entry) {
        if (entry.startsWith("#")) {
            class_2960 tagId = class_2960.method_12829((String)entry.substring(1));
            if (tagId != null) {
                return biome.method_40220(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tagId));
            }
        } else {
            return biome.method_40230().map(key -> key.method_29177().toString().equals(entry)).orElse(false);
        }
        return false;
    }
}

