/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.worldgen;

import com.jayemceekay.shadowedhearts.config.IWorldAlterationConfig;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import com.jayemceekay.shadowedhearts.worldgen.CraterGenerator;
import com.jayemceekay.shadowedhearts.worldgen.ImpactLocationSelector;
import dev.architectury.event.events.common.TickEvent;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class ImpactScheduler {
    private static final Random RANDOM = new Random();

    public static void init() {
        TickEvent.SERVER_LEVEL_POST.register(level -> {
            IWorldAlterationConfig config;
            class_3218 serverLevel;
            if (level instanceof class_3218 && !(serverLevel = level).method_18456().isEmpty() && (config = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration()).shadowfallActive() && RANDOM.nextInt(config.impactChanceOneInTicks()) == 0) {
                ImpactScheduler.attemptImpact(serverLevel);
            }
        });
    }

    public static void attemptImpact(class_3218 level) {
        ImpactLocationSelector.selectLocation(level).ifPresent(pos -> {
            CraterGenerator.generateCrater((class_1936)level, pos);
            IWorldAlterationConfig config = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration();
            int broadcastRadius = config.meteoroidImpactBroadcastRadius();
            level.method_18456().forEach(player -> {
                if (player.method_24515().method_19771((class_2382)pos, (double)broadcastRadius)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"A shadowfall meteoroid has impacted nearby!"), false);
                }
            });
        });
    }
}

