/*
 * Decompiled with CFR 0.152.
 */
package com.jayemceekay.shadowedhearts.worldgen;

import com.jayemceekay.shadowedhearts.Shadowedhearts;
import com.jayemceekay.shadowedhearts.config.ShadowedHeartsConfigs;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import it.unimi.dsi.fastutil.longs.Long2FloatMap;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class PlayerActivityHeatmap {
    private static final Map<class_5321<class_1937>, Long2FloatOpenHashMap> HEATMAPS = new ConcurrentHashMap<class_5321<class_1937>, Long2FloatOpenHashMap>();
    private static final Map<class_5321<class_1937>, Long2FloatOpenHashMap> DIRTY_ENTRIES = new ConcurrentHashMap<class_5321<class_1937>, Long2FloatOpenHashMap>();
    private static int decayTimer = 0;
    private static int flushTimer = 0;

    public static void init() {
        LifecycleEvent.SERVER_STARTED.register(server -> PlayerActivityHeatmap.loadAll(server));
        TickEvent.SERVER_LEVEL_POST.register(level -> {
            if (level instanceof class_3218) {
                class_3218 serverLevel = level;
                int decayTicks = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration().heatmapDecayTicks();
                if (++decayTimer >= decayTicks) {
                    decayTimer = 0;
                    PlayerActivityHeatmap.decay(serverLevel);
                }
                int range = ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration().heatmapPresenceRadius();
                for (class_3222 player : serverLevel.method_18456()) {
                    class_1923 center = player.method_31476();
                    for (int dx = -range; dx <= range; ++dx) {
                        for (int dz = -range; dz <= range; ++dz) {
                            float amount;
                            double distance = Math.sqrt(dx * dx + dz * dz);
                            if (distance > (double)range || !((amount = (float)(0.1 * (1.0 - distance / (double)(range + 1)))) > 0.0f)) continue;
                            PlayerActivityHeatmap.addActivity(serverLevel, center.field_9181 + dx, center.field_9180 + dz, amount);
                        }
                    }
                }
                if (++flushTimer >= ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration().heatmapFlushIntervalTicks()) {
                    flushTimer = 0;
                    PlayerActivityHeatmap.flushDirty(serverLevel.method_8503());
                }
            }
        });
        BlockEvent.PLACE.register((level, pos, state, entity) -> {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                PlayerActivityHeatmap.addActivity(serverLevel, pos.method_10263() >> 4, pos.method_10260() >> 4, 1.0f);
            }
            return EventResult.pass();
        });
        BlockEvent.BREAK.register((level, pos, state, player, xp) -> {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                PlayerActivityHeatmap.addActivity(serverLevel, pos.method_10263() >> 4, pos.method_10260() >> 4, 1.0f);
            }
            return EventResult.pass();
        });
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, hand, pos, direction) -> {
            class_3222 sp;
            class_1937 patt0$temp;
            if (player instanceof class_3222 && (patt0$temp = (sp = (class_3222)player).method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)patt0$temp;
                PlayerActivityHeatmap.addActivity(serverLevel, pos.method_10263() >> 4, pos.method_10260() >> 4, 0.5f);
            }
            return EventResult.pass();
        });
        LifecycleEvent.SERVER_STOPPING.register(server -> PlayerActivityHeatmap.flushDirty(server));
    }

    private static long packPos(int x, int z) {
        return class_1923.method_8331((int)x, (int)z);
    }

    public static void addActivity(class_3218 level, int chunkX, int chunkZ, float amount) {
        long pos = PlayerActivityHeatmap.packPos(chunkX, chunkZ);
        Long2FloatOpenHashMap map = HEATMAPS.computeIfAbsent((class_5321<class_1937>)level.method_27983(), k -> new Long2FloatOpenHashMap());
        float newVal = map.get(pos) + amount;
        map.put(pos, newVal);
        Long2FloatOpenHashMap dirtyMap = DIRTY_ENTRIES.computeIfAbsent((class_5321<class_1937>)level.method_27983(), k -> new Long2FloatOpenHashMap());
        dirtyMap.put(pos, newVal);
    }

    private static void decay(class_3218 level) {
        Long2FloatOpenHashMap levelMap = HEATMAPS.get(level.method_27983());
        if (levelMap == null || levelMap.isEmpty()) {
            return;
        }
        float decayAmount = (float)ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration().heatmapDecayAmount();
        Long2FloatOpenHashMap dirtyMap = DIRTY_ENTRIES.computeIfAbsent((class_5321<class_1937>)level.method_27983(), k -> new Long2FloatOpenHashMap());
        Long2FloatMap.FastEntrySet entries = levelMap.long2FloatEntrySet();
        ObjectIterator iterator2 = entries.iterator();
        while (iterator2.hasNext()) {
            Long2FloatMap.Entry entry = (Long2FloatMap.Entry)iterator2.next();
            float newVal = entry.getFloatValue() - decayAmount;
            long key = entry.getLongKey();
            if (newVal <= 0.0f) {
                iterator2.remove();
                dirtyMap.put(key, 0.0f);
                continue;
            }
            entry.setValue(newVal);
            dirtyMap.put(key, newVal);
        }
    }

    public static double getActivity(class_3218 level, int chunkX, int chunkZ) {
        Long2FloatOpenHashMap levelMap = HEATMAPS.get(level.method_27983());
        return levelMap == null ? 0.0 : (double)levelMap.get(PlayerActivityHeatmap.packPos(chunkX, chunkZ));
    }

    public static boolean isCivilized(class_3218 level, int chunkX, int chunkZ) {
        return PlayerActivityHeatmap.getActivity(level, chunkX, chunkZ) >= (double)ShadowedHeartsConfigs.getInstance().getShadowConfig().worldAlteration().civilizedHeatmapThreshold();
    }

    private static Path getDatabasePath(MinecraftServer server, class_5321<class_1937> dimension) {
        Path basePath = server.method_27050(class_5218.field_24188).resolve("shadowedhearts").resolve("heatmap");
        Object dimName = dimension.method_29177().method_12832();
        if (!dimension.method_29177().method_12836().equals("minecraft")) {
            dimName = dimension.method_29177().method_12836() + "_" + (String)dimName;
        }
        return basePath.resolve((String)dimName).resolve("heatmap.db");
    }

    private static Connection getConnection(Path dbPath) throws SQLException {
        try {
            Files.createDirectories(dbPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SQLException("Could not create directories for database", e);
        }
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (Exception e) {
            throw new SQLException("SQLite JDBC driver could not be initialized", e);
        }
        String url = "jdbc:sqlite:" + String.valueOf(dbPath.toAbsolutePath());
        Connection conn = DriverManager.getConnection(url);
        try (Statement stmt = conn.createStatement();){
            stmt.execute("PRAGMA journal_mode=WAL;");
            stmt.execute("CREATE TABLE IF NOT EXISTS heatmap (pos INTEGER PRIMARY KEY, value REAL);");
        }
        return conn;
    }

    private static void flushDirty(MinecraftServer server) {
        for (Map.Entry<class_5321<class_1937>, Long2FloatOpenHashMap> entry : DIRTY_ENTRIES.entrySet()) {
            class_5321<class_1937> dimension = entry.getKey();
            Long2FloatOpenHashMap dirtyMap = entry.getValue();
            if (dirtyMap.isEmpty()) continue;
            Path dbPath = PlayerActivityHeatmap.getDatabasePath(server, dimension);
            try {
                Connection conn = PlayerActivityHeatmap.getConnection(dbPath);
                try {
                    conn.setAutoCommit(false);
                    try (PreparedStatement upsertStmt = conn.prepareStatement("INSERT INTO heatmap(pos, value) VALUES(?, ?) ON CONFLICT(pos) DO UPDATE SET value=excluded.value");
                         PreparedStatement deleteStmt = conn.prepareStatement("DELETE FROM heatmap WHERE pos = ?");){
                        for (Long2FloatMap.Entry dirtyEntry : dirtyMap.long2FloatEntrySet()) {
                            if (dirtyEntry.getFloatValue() <= 0.0f) {
                                deleteStmt.setLong(1, dirtyEntry.getLongKey());
                                deleteStmt.addBatch();
                                continue;
                            }
                            upsertStmt.setLong(1, dirtyEntry.getLongKey());
                            upsertStmt.setFloat(2, dirtyEntry.getFloatValue());
                            upsertStmt.addBatch();
                        }
                        upsertStmt.executeBatch();
                        deleteStmt.executeBatch();
                    }
                    conn.commit();
                    dirtyMap.clear();
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                }
            }
            catch (SQLException e) {
                Shadowedhearts.LOGGER.error("Failed to flush heatmap for dimension {}", (Object)dimension.method_29177(), (Object)e);
            }
        }
    }

    private static void loadAll(MinecraftServer server) {
        for (class_3218 level : server.method_3738()) {
            class_5321 dimension = level.method_27983();
            Path dbPath = PlayerActivityHeatmap.getDatabasePath(server, (class_5321<class_1937>)dimension);
            if (!Files.exists(dbPath, new LinkOption[0])) continue;
            Long2FloatOpenHashMap map = HEATMAPS.computeIfAbsent((class_5321<class_1937>)dimension, k -> new Long2FloatOpenHashMap());
            try {
                Connection conn = PlayerActivityHeatmap.getConnection(dbPath);
                try {
                    Statement stmt = conn.createStatement();
                    try {
                        ResultSet rs = stmt.executeQuery("SELECT pos, value FROM heatmap");
                        try {
                            while (rs.next()) {
                                map.put(rs.getLong("pos"), rs.getFloat("value"));
                            }
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                }
            }
            catch (SQLException e) {
                Shadowedhearts.LOGGER.error("Failed to load heatmap for dimension {}", (Object)dimension.method_29177(), (Object)e);
            }
        }
    }
}

