/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.rendering;

import com.google.common.base.CaseFormat;
import com.google.common.base.Supplier;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.rendering.CustomDataRenderer;
import io.wispforest.accessories.api.client.rendering.RenderingFunctionPredicate;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.format.edm.EdmSerializer;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Experimental
public sealed interface RenderingFunction
permits CustomDataRenderer, Block, Compound, Conditional, Entity, Item, Model, Particle, Transformation {
    public static final Endec<RenderingFunction> ENDEC = Endec.dispatchedStruct(key -> switch (key) {
        case "transformation" -> Transformation.ENDEC;
        case "model" -> Model.ENDEC;
        case "block" -> Block.ENDEC;
        case "item" -> Item.ENDEC;
        case "entity" -> Entity.ENDEC;
        case "particle" -> Particle.ENDEC;
        case "compound" -> Compound.ENDEC;
        case "renderer" -> CustomDataRenderer.ENDEC;
        case "conditional" -> Conditional.ENDEC;
        default -> throw new IllegalStateException("A invalid rendering function was created meaning such is unable to be decoded!");
    }, RenderingFunction::key, (Endec)Endec.STRING, (String)"type");

    public static Transformation ofTransformation(List<io.wispforest.accessories.api.client.Transformation> transformations, RenderingFunction innerRendering) {
        return new Transformation(transformations, innerRendering);
    }

    public static Model ofModel(class_2960 id, String variant) {
        return new Model(id, variant);
    }

    public static Block ofBlock(class_2248 block) {
        return RenderingFunction.ofBlock(block.method_9564());
    }

    public static Block ofBlock(class_2680 state) {
        return new Block(state, null, new class_2487());
    }

    public static Block ofBlockEntity(class_2248 block, class_2591<? extends class_2586> type, class_1937 level) {
        return RenderingFunction.ofBlockEntity(block.method_9564(), type, level);
    }

    public static Block ofBlockEntity(class_2680 blockState, class_2591<? extends class_2586> type, class_1937 level) {
        class_2586 blockEntity = type.method_11032(class_2338.field_10980, blockState);
        if (blockEntity == null) {
            throw new IllegalStateException("Unable to create render function of the given block entity");
        }
        return RenderingFunction.ofBlockEntity(blockState, type, blockEntity.method_38244((class_7225.class_7874)level.method_30349()));
    }

    public static Block ofBlockEntity(class_2680 blockState, class_2591<? extends class_2586> type, class_2487 data) {
        return new Block(blockState, type, data);
    }

    public static Item ofItem(class_1799 stack) {
        return new Item(stack);
    }

    public static Entity ofEntity(class_1299<? extends class_1297> entityType, class_1937 level) {
        class_1297 entity = entityType.method_5883(level);
        if (entity == null) {
            throw new IllegalStateException("Unable to create render function of the given entity");
        }
        class_2487 compound = new class_2487();
        String string = entity.method_5653();
        if (string == null) {
            throw new IllegalStateException("Unable to create render function of the given entity");
        }
        compound.method_10582("id", string);
        entity.method_5647(compound);
        return new Entity(entityType, compound, true);
    }

    public static Entity ofEntity(class_1299<? extends class_1297> entityType, class_2487 data) {
        return new Entity(entityType, data, true);
    }

    public static Particle ofParticle(class_2960 uniqueId, float delay, class_2394 particleData, Vector3f delta, float speed, int count, boolean force) {
        return new Particle(uniqueId, delay, particleData, delta, speed, count, force);
    }

    default public String key() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.getClass().getSimpleName());
    }

    public record Transformation(List<io.wispforest.accessories.api.client.Transformation> transformations, RenderingFunction renderingFunction) implements RenderingFunction
    {
        public static final StructEndec<Transformation> ENDEC = StructEndecBuilder.of((StructField)io.wispforest.accessories.api.client.Transformation.ENDEC.listOf().fieldOf("transformations", Transformation::transformations), (StructField)ENDEC.fieldOf("rendering_function", Transformation::renderingFunction), Transformation::new);
    }

    public record Model(class_2960 id, String variant) implements RenderingFunction
    {
        public static final StructEndec<Model> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("id", Model::id), (StructField)Endec.STRING.optionalFieldOf("variant", Model::variant, () -> ""), Model::new);
    }

    public record Block(class_2680 state, @Nullable class_2591<?> type, class_2487 data) implements RenderingFunction
    {
        public static final StructEndec<Block> ENDEC = StructEndecBuilder.of((StructField)EndecUtils.blockStateEndec("id").flatFieldOf(Block::state), (StructField)CodecUtils.toEndec((Codec)class_7923.field_41181.method_39673()).optionalFieldOf("entity_id", Block::type, (Object)null), (StructField)NbtEndec.COMPOUND.optionalFieldOf("data", Block::data, class_2487::new), Block::new);
    }

    public record Item(class_1799 stack) implements RenderingFunction
    {
        public static final StructEndec<Item> ENDEC = StructEndecBuilder.of((StructField)new EndecUtils.LazyStructEndec(() -> {
            Codec baseCodec = class_1799.field_24671;
            try {
                Field field = baseCodec.getClass().getDeclaredField("wrapped");
                field.setAccessible(true);
                Supplier supplier = (Supplier)field.get(baseCodec);
                return CodecUtils.toStructEndec((MapCodec)((MapCodec.MapCodecCodec)supplier.get()).codec());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }).flatFieldOf(Item::stack), Item::new);
    }

    public record Entity(class_1299<?> entityType, class_2487 data, boolean allowTicking) implements RenderingFunction
    {
        public static final StructEndec<Entity> ENDEC = StructEndecBuilder.of((StructField)CodecUtils.toEndec((Codec)class_7923.field_41177.method_39673()).fieldOf("entity_id", Entity::entityType), (StructField)NbtEndec.COMPOUND.optionalFieldOf("stack", Entity::data, class_2487::new), (StructField)Endec.BOOLEAN.optionalFieldOf("allow_ticking", Entity::allowTicking, (Object)false), Entity::new);
    }

    public record Particle(class_2960 uniqueId, float delay, class_2394 particleData, Vector3f delta, float speed, int count, boolean force) implements RenderingFunction
    {
        private static final Endec<class_2394> PARTICLE_OPTIONS_ENDEC = CodecUtils.toEndec((Codec)class_2398.field_25125);
        public static final StructEndec<Particle> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.optionalFieldOf("unique_id", Particle::uniqueId, () -> Accessories.of("shared")), (StructField)Endec.FLOAT.optionalFieldOf("delay", Particle::delay, () -> Float.valueOf(20.0f)), (StructField)PARTICLE_OPTIONS_ENDEC.fieldOf("particle_data", Particle::particleData), (StructField)EndecUtils.VECTOR_3_F_ENDEC.flatFieldOf(Particle::delta), (StructField)Endec.FLOAT.optionalFieldOf("speed", Particle::speed, (Object)Float.valueOf(1.0f)), (StructField)Endec.INT.optionalFieldOf("count", Particle::count, (Object)1), (StructField)Endec.BOOLEAN.optionalFieldOf("force", Particle::force, (Object)false), Particle::new);

        @Override
        public boolean equals(Object obj) {
            EdmElement thatRawParticleData;
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Particle that = (Particle)obj;
            EdmElement rawParticleData = (EdmElement)PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, (Object)this.particleData);
            return Objects.equals(rawParticleData, thatRawParticleData = (EdmElement)PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, (Object)that.particleData)) && Objects.equals(this.delta, that.delta) && Float.floatToIntBits(this.speed) == Float.floatToIntBits(that.speed) && this.count == that.count && this.force == that.force;
        }

        @Override
        public int hashCode() {
            return Objects.hash(PARTICLE_OPTIONS_ENDEC.encodeFully(EdmSerializer::of, (Object)this.particleData), this.delta, Float.valueOf(this.speed), this.count, this.force);
        }

        @Override
        public String toString() {
            return "Particle[particleData=" + String.valueOf(this.particleData) + ", delta=" + String.valueOf(this.delta) + ", speed=" + this.speed + ", count=" + this.count + ", force=" + this.force + "]";
        }
    }

    public record Compound(List<RenderingFunction> renderingFunctions, ArmTarget firstPersonArmTarget) implements RenderingFunction
    {
        public static final StructEndec<Compound> ENDEC = StructEndecBuilder.of((StructField)ENDEC.listOf().fieldOf("rendering_functions", Compound::renderingFunctions), (StructField)Endec.forEnum(ArmTarget.class).optionalFieldOf("first_person_arm_target", Compound::firstPersonArmTarget, () -> ArmTarget.NONE), Compound::new);
    }

    public record Conditional(List<RenderingFunctionPredicate> predicates, RenderingFunction renderingFunction) implements RenderingFunction
    {
        public static final StructEndec<Conditional> ENDEC = StructEndecBuilder.of((StructField)RenderingFunctionPredicate.ENDEC.listOf().fieldOf("predicates", Conditional::predicates), (StructField)ENDEC.fieldOf("rendering_function", Conditional::renderingFunction), Conditional::new);
    }

    public static enum ArmTarget {
        LEFT(class_1306.field_6182),
        RIGHT(class_1306.field_6183),
        BOTH(class_1306.field_6182, class_1306.field_6183),
        NONE(new class_1306[0]);

        private final Set<class_1306> arms;

        private ArmTarget(class_1306 ... arms) {
            EnumSet<class_1306> result = EnumSet.noneOf(class_1306.class);
            result.addAll(Set.of(arms));
            this.arms = result;
        }

        public final boolean hasArm(class_1306 arm) {
            return this.arms.contains(arm);
        }
    }
}

