/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.EquipAction;
import io.wispforest.accessories.api.EquipCheck;
import io.wispforest.accessories.api.EquipmentChecking;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.caching.ItemStackPredicate;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.InstanceEndec;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.MapCarrier;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class AccessoriesCapabilityImpl
implements AccessoriesCapability,
InstanceEndec {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_1309 entity;
    private static final Cache<Integer, Boolean> validatedServerEntities = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(30L)).build();
    private static final Cache<Integer, Boolean> validatedClientEntities = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(30L)).build();
    private boolean updateContainersLock = false;

    public AccessoriesCapabilityImpl(class_1309 entity) {
        this.entity = entity;
    }

    @Override
    public class_1309 entity() {
        return this.entity;
    }

    @Override
    public AccessoriesHolder getHolder() {
        AccessoriesHolderImpl holder = (AccessoriesHolderImpl)AccessoriesInternals.getHolder(this.entity);
        if (holder.loadedFromTag) {
            if (this.entity.method_37908().method_8608()) {
                holder.init(this);
            } else {
                this.reset(true);
            }
        } else if (!this.isEntitySlotsValid(holder)) {
            holder.init(this);
        }
        return holder;
    }

    private boolean isEntitySlotsValid(AccessoriesHolderImpl holder) {
        int hash;
        Cache<Integer, Boolean> validEntities = this.entity.method_37908().method_8608() ? validatedClientEntities : validatedServerEntities;
        Boolean result = (Boolean)validEntities.getIfPresent((Object)(hash = Objects.hash(this.entity.method_5667(), this.entity.hashCode())));
        if (result != null) {
            if (result.booleanValue()) {
                return true;
            }
            validEntities.invalidate((Object)hash);
        }
        Map<String, AccessoriesContainer> currentContainers = holder.getSlotContainers();
        Map<String, SlotType> requiredSlotTypes = EntitySlotLoader.getEntitySlots(this.entity);
        result = currentContainers.size() == requiredSlotTypes.size();
        if (result.booleanValue()) {
            validEntities.put((Object)hash, (Object)true);
        }
        return result;
    }

    public static void clearValidationCache(boolean isClientSide) {
        (isClientSide ? validatedClientEntities : validatedServerEntities).invalidateAll();
    }

    private AccessoriesHolderImpl holder() {
        return (AccessoriesHolderImpl)this.getHolder();
    }

    @Override
    public Map<String, AccessoriesContainer> getContainers() {
        for (AccessoriesContainer container : this.holder().getAllSlotContainers().values()) {
            if (this.entity == container.capability().entity()) break;
            ((AccessoriesContainerImpl)container).capability = this;
        }
        return this.holder().getSlotContainers();
    }

    @Override
    public void reset(boolean loadedFromTag) {
        class_3222 serverPlayer;
        AccessoriesHolderImpl holder;
        block7: {
            block6: {
                Object currentContainers;
                if (this.entity.method_37908().method_8608()) {
                    return;
                }
                holder = (AccessoriesHolderImpl)AccessoriesInternals.getHolder(this.entity);
                if (!loadedFromTag) {
                    Map<String, AccessoriesContainer> oldContainers = Map.copyOf(holder.getAllSlotContainers());
                    holder.init(this);
                    currentContainers = holder.getAllSlotContainers();
                    oldContainers.forEach((arg_0, arg_1) -> AccessoriesCapabilityImpl.lambda$reset$0((Map)currentContainers, arg_0, arg_1));
                } else {
                    holder.init(this);
                }
                currentContainers = this.entity;
                if (!(currentContainers instanceof class_3222)) break block6;
                serverPlayer = (class_3222)currentContainers;
                if (serverPlayer.field_13987 != null) break block7;
            }
            return;
        }
        NbtMapCarrier carrier = NbtMapCarrier.of();
        holder.write(carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)this.entity.method_37908().method_30349())}));
        AccessoriesNetworking.sendToTrackingAndSelf((class_1297)serverPlayer, new SyncEntireContainer(serverPlayer.method_5628(), carrier));
    }

    @Override
    public void updateContainers() {
        boolean hasUpdateOccurred;
        if (this.updateContainersLock) {
            return;
        }
        Collection<AccessoriesContainer> containers = this.getContainers().values();
        this.updateContainersLock = true;
        do {
            hasUpdateOccurred = false;
            for (AccessoriesContainer container : containers) {
                if (!container.hasChanged()) continue;
                container.update();
                hasUpdateOccurred = true;
            }
        } while (hasUpdateOccurred);
        this.updateContainersLock = false;
    }

    @Override
    public void addTransientSlotModifiers(Multimap<String, class_1322> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(container::addTransientModifier);
        }
    }

    @Override
    public void addPersistentSlotModifiers(Multimap<String, class_1322> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(container::addPersistentModifier);
        }
    }

    @Override
    public void removeSlotModifiers(Multimap<String, class_1322> modifiers) {
        Map<String, AccessoriesContainer> containers = this.getContainers();
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            if (!containers.containsKey(entry.getKey())) continue;
            AccessoriesContainer container = containers.get(entry.getKey());
            ((Collection)entry.getValue()).forEach(modifier -> container.removeModifier(modifier.comp_2447()));
        }
    }

    @Override
    public Multimap<String, class_1322> getSlotModifiers() {
        HashMultimap modifiers = HashMultimap.create();
        this.getContainers().forEach((arg_0, arg_1) -> AccessoriesCapabilityImpl.lambda$getSlotModifiers$2((Multimap)modifiers, arg_0, arg_1));
        return modifiers;
    }

    @Override
    public void clearSlotModifiers() {
        this.getContainers().forEach((s, container) -> container.clearModifiers());
    }

    @Override
    public void clearCachedSlotModifiers() {
        HashMultimap slotModifiers = HashMultimap.create();
        Map<String, AccessoriesContainer> containers = this.getContainers();
        containers.forEach((name, container) -> {
            Set<class_1322> modifiers = container.getCachedModifiers();
            if (modifiers.isEmpty()) {
                return;
            }
            ExpandedSimpleContainer accessories = container.getAccessories();
            for (int i = 0; i < accessories.method_5439(); ++i) {
                class_1799 stack = accessories.method_5438(i);
                if (stack.method_7960()) continue;
                SlotReference slotReference = container.createReference(i);
                slotModifiers.putAll(AccessoriesAPI.getAttributeModifiers(stack, slotReference).getSlotModifiers());
            }
        });
        slotModifiers.asMap().forEach((name, modifiers) -> {
            if (!containers.containsKey(name)) {
                return;
            }
            AccessoriesContainer container = (AccessoriesContainer)containers.get(name);
            modifiers.forEach(container.getCachedModifiers()::remove);
            container.clearCachedModifiers();
        });
    }

    public Map<AccessoriesContainer, Boolean> getUpdatingInventories() {
        return this.holder().containersRequiringUpdates;
    }

    @Override
    @Nullable
    public it.unimi.dsi.fastutil.Pair<SlotReference, EquipAction> canEquipAccessory(class_1799 stack, boolean allowSwapping, EquipCheck extraCheck) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
        if (accessory == null) {
            return null;
        }
        HashMap<String, AccessoriesContainer> validContainers = new HashMap<String, AccessoriesContainer>();
        if (stack.method_7960() && allowSwapping) {
            Map<String, AccessoriesContainer> allContainers = this.getContainers();
            EntitySlotLoader.getEntitySlots(this.entity()).forEach((s, slotType) -> validContainers.put((String)s, (AccessoriesContainer)allContainers.get(slotType.name())));
        } else {
            for (AccessoriesContainer container : this.getContainers().values()) {
                boolean isValid;
                if (container.getSize() <= 0 || !(isValid = AccessoriesAPI.canInsertIntoSlot(stack, container.createReference(0))) || !ExtraSlotTypeProperties.getProperty(container.getSlotName(), this.entity.method_37908().field_9236).allowEquipFromUse()) continue;
                if (allowSwapping) {
                    validContainers.put(container.getSlotName(), container);
                }
                ExpandedSimpleContainer accessories = container.getAccessories();
                for (int i = 0; i < container.getSize(); ++i) {
                    class_1799 slotStack = accessories.method_5438(i);
                    SlotReference slotReference = container.createReference(i);
                    if (!slotStack.method_7960() || !AccessoriesAPI.canUnequip(slotStack, slotReference) || !AccessoriesAPI.canInsertIntoSlot(stack, slotReference) || !extraCheck.isValid(slotStack, false)) continue;
                    return it.unimi.dsi.fastutil.Pair.of((Object)container.createReference(i), newStack -> this.setStack(slotReference, newStack, false));
                }
            }
        }
        for (AccessoriesContainer validContainer : validContainers.values()) {
            ExpandedSimpleContainer accessories = validContainer.getAccessories();
            for (int i = 0; i < accessories.method_5439(); ++i) {
                class_1799 slotStack = accessories.method_5438(i).method_7972();
                SlotReference slotReference = validContainer.createReference(i);
                if (slotStack.method_7960() || !AccessoriesAPI.canUnequip(slotStack, slotReference) || !stack.method_7960() && (!AccessoriesAPI.canInsertIntoSlot(stack, slotReference) || !extraCheck.isValid(slotStack, true))) continue;
                return it.unimi.dsi.fastutil.Pair.of((Object)slotReference, newStack -> this.setStack(slotReference, newStack, true));
            }
        }
        return null;
    }

    private Optional<class_1799> setStack(SlotReference reference, class_1799 newStack, boolean shouldSwapStacks) {
        class_1799 oldStack = reference.getStack().method_7972();
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(oldStack);
        if (shouldSwapStacks) {
            class_1799 splitStack;
            class_1799 class_17992 = splitStack = newStack.method_7960() ? class_1799.field_8037 : newStack.method_7971(accessory.maxStackSize(newStack));
            if (!this.entity.method_37908().field_9236) {
                reference.setStack(splitStack);
            }
            return Optional.of(oldStack);
        }
        if (!this.entity.method_37908().field_9236) {
            class_1799 splitStack = newStack.method_7971(accessory.maxStackSize(newStack));
            reference.setStack(splitStack);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public SlotEntryReference getFirstEquipped(ItemStackBasedPredicate predicate, EquipmentChecking check) {
        AccessoriesHolderLookupCache cache = ((AccessoriesHolderImpl)this.getHolder()).getLookupCache();
        if (cache != null && !(predicate instanceof ItemStackPredicate)) {
            return cache.firstEquipped(predicate, check);
        }
        for (AccessoriesContainer container : this.getContainers().values()) {
            for (Pair<Integer, class_1799> stackEntry : container.getAccessories()) {
                SlotEntryReference entryReference;
                class_1799 cosmetic;
                class_1799 stack = (class_1799)stackEntry.getSecond();
                SlotReference reference = container.createReference((Integer)stackEntry.getFirst());
                if (check == EquipmentChecking.COSMETICALLY_OVERRIDABLE && !(cosmetic = container.getCosmeticAccessories().method_5438(reference.slot())).method_7960() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmetic;
                }
                if ((entryReference = AccessoryNestUtils.recursiveStackHandling(stack, reference, (innerStack, ref) -> !innerStack.method_7960() && predicate.test((class_1799)innerStack) ? new SlotEntryReference(reference, (class_1799)innerStack) : null)) == null) continue;
                return entryReference;
            }
        }
        return null;
    }

    @Override
    public List<SlotEntryReference> getAllEquipped(boolean recursiveStackLookup) {
        AccessoriesHolderLookupCache cache = ((AccessoriesHolderImpl)this.getHolder()).getLookupCache();
        if (cache != null) {
            return cache.getAllEquipped();
        }
        ArrayList<SlotEntryReference> references = new ArrayList<SlotEntryReference>();
        for (AccessoriesContainer container : this.getContainers().values()) {
            for (Pair<Integer, class_1799> stackEntry : container.getAccessories()) {
                class_1799 stack = (class_1799)stackEntry.getSecond();
                if (stack.method_7960()) continue;
                SlotReference reference = container.createReference((Integer)stackEntry.getFirst());
                if (recursiveStackLookup) {
                    AccessoryNestUtils.recursiveStackConsumption(stack, reference, (innerStack, ref) -> references.add(new SlotEntryReference((SlotReference)ref, (class_1799)innerStack)));
                    continue;
                }
                references.add(new SlotEntryReference(reference, stack));
            }
        }
        return references;
    }

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        this.holder().write(carrier, ctx);
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext ctx) {
        this.holder().read(carrier, ctx);
    }

    private static /* synthetic */ void lambda$getSlotModifiers$2(Multimap modifiers, String s, AccessoriesContainer container) {
        modifiers.putAll((Object)s, container.getModifiers().values());
    }

    private static /* synthetic */ void lambda$reset$0(Map currentContainers, String s, AccessoriesContainer oldContainer) {
        AccessoriesContainer currentContainer = (AccessoriesContainer)currentContainers.get(s);
        currentContainer.getAccessories().setFromPrev(oldContainer.getAccessories());
        currentContainer.markChanged(false);
    }
}

