/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import io.wispforest.accessories.pond.stack.PatchedDataComponentMapExtension;
import io.wispforest.accessories.utils.ItemStackMutation;
import io.wispforest.owo.util.EventStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9335;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_9335.class})
public abstract class PatchedDataComponentMapMixin
implements PatchedDataComponentMapExtension {
    @Unique
    private boolean changeCheckStack = false;
    @Nullable
    private class_1799 itemStack = null;
    @Nullable
    private EventStream<ItemStackMutation> mutationEvent = null;
    @Unique
    private boolean inApplyPatchLock = false;

    @Override
    public EventStream<ItemStackMutation> accessories$getMutationEvent(class_1799 itemStack) {
        Objects.requireNonNull(itemStack);
        this.itemStack = itemStack;
        if (this.mutationEvent == null) {
            this.mutationEvent = new EventStream(invokers -> (stack, types) -> invokers.forEach(itemStackMutation -> itemStackMutation.onMutation(stack, types)));
        }
        return this.mutationEvent;
    }

    @Override
    public boolean accessories$hasChanged() {
        boolean bl = this.changeCheckStack;
        this.changeCheckStack = false;
        return bl;
    }

    @Inject(method={"set"}, at={@At(value="HEAD")})
    private <T> void accessories$updateChangeValue_set(class_9331<? super T> component, @Nullable T value, CallbackInfoReturnable<T> cir) {
        this.changeCheckStack = true;
        this.accessories$handleMutationEvent(List.of(component));
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private <T> void accessories$updateChangeValue_remove(class_9331<? super T> component, CallbackInfoReturnable<T> cir) {
        this.changeCheckStack = true;
        this.accessories$handleMutationEvent(List.of(component));
    }

    @Inject(method={"applyPatch(Lnet/minecraft/core/component/DataComponentPatch;)V"}, at={@At(value="HEAD")})
    private void accessories$updateChangeValue_applyPatchHead(class_9326 patch, CallbackInfo ci) {
        this.changeCheckStack = true;
        this.inApplyPatchLock = true;
    }

    @Inject(method={"applyPatch(Lnet/minecraft/core/component/DataComponentPatch;)V"}, at={@At(value="TAIL")})
    private void accessories$updateChangeValue_applyPatchTail(class_9326 patch, CallbackInfo ci) {
        this.inApplyPatchLock = false;
        ArrayList list = new ArrayList();
        for (Map.Entry entry : patch.method_57846()) {
            list.add((class_9331)entry.getKey());
        }
        this.accessories$handleMutationEvent(list);
    }

    @Inject(method={"applyPatch(Lnet/minecraft/core/component/DataComponentType;Ljava/util/Optional;)V"}, at={@At(value="HEAD")})
    private void accessories$updateChangeValue_applyPatch(class_9331<?> component, Optional<?> value, CallbackInfo ci) {
        this.changeCheckStack = true;
        if (!this.inApplyPatchLock) {
            this.accessories$handleMutationEvent(List.of(component));
        }
    }

    @Inject(method={"restorePatch"}, at={@At(value="HEAD")})
    private void accessories$updateChangeValue_restorePatch(class_9326 patch, CallbackInfo ci) {
        this.changeCheckStack = true;
        ArrayList list = new ArrayList();
        for (Map.Entry entry : patch.method_57846()) {
            list.add((class_9331)entry.getKey());
        }
        this.accessories$handleMutationEvent(list);
    }

    @Unique
    private void accessories$handleMutationEvent(List<class_9331<?>> changedDataTypes) {
        if (this.mutationEvent == null) {
            return;
        }
        ((ItemStackMutation)this.mutationEvent.sink()).onMutation(this.itemStack, changedDataTypes);
    }
}

