/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.format.gson.GsonDeserializer;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.slf4j.Logger;

public abstract class EndecDataLoader<T>
extends class_4309 {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    protected final String type;
    protected final class_2960 id;
    protected final Endec<T> endec;
    protected SerializationContext context;

    protected EndecDataLoader(SerializationContext context, class_2960 id, String type, Endec<T> endec) {
        super(GSON, type);
        this.type = type;
        this.id = id;
        this.context = context;
        this.endec = endec;
    }

    public static <T> EndecDataLoader<T> client(class_2960 id, String type, Endec<T> endec, final BiConsumer<class_2960, T> handleEntry) {
        return new EndecDataLoader<T>(SerializationContext.empty(), id, type, endec){

            @Override
            public void handleRawEntry(class_2960 identifier, T t) {
                handleEntry.accept(identifier, t);
            }
        };
    }

    public static <T> EndecDataLoader<T> server(class_7225.class_7874 registries, class_2960 id, String type, Endec<T> endec, final BiConsumer<class_2960, T> handleEntry) {
        return new EndecDataLoader<T>(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)((class_5455)registries))}), id, type, endec){

            @Override
            public void handleRawEntry(class_2960 identifier, T t) {
                handleEntry.accept(identifier, t);
            }
        };
    }

    protected abstract void handleRawEntry(class_2960 var1, T var2);

    protected void apply(Map<class_2960, JsonElement> loadedObjects, class_3300 resourceManager, class_3695 profiler) {
        for (Map.Entry<class_2960, JsonElement> entry : loadedObjects.entrySet()) {
            class_2960 location = entry.getKey();
            try {
                Object t = this.endec.decodeFully(this.context, GsonDeserializer::of, (Object)entry.getValue());
                this.handleRawEntry(location, t);
            }
            catch (Exception e) {
                LOGGER.error("[EndecDataLoader: {}] An issue has occurred with attempting to decode the following entry: {}", new Object[]{this.getLoaderId(), location, e});
            }
        }
    }

    public class_2960 getLoaderId() {
        return this.id;
    }
}

