/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.client.events.cobblemon;

import com.cobblemon.mod.common.api.events.pokemon.interaction.PokemonInteractionGUICreationEvent;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelOption;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.client.ClientSyncedConfig;
import com.github.d0ctorleon.mythsandlegends.items.ZygardeCubeBundleItem;
import com.github.d0ctorleon.mythsandlegends.net.TriggerTransformationPacket;
import com.github.d0ctorleon.mythsandlegends.net.TriggerZygardeActionPacket;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class CobblemonGuiEventHandler {
    private static boolean fusionOptionsEnabled = true;
    private static boolean interactionOptionsEnabled = true;
    private static boolean zygardeOptionsEnabled = true;

    public static void setFusionOptionsEnabled(boolean enabled) {
        fusionOptionsEnabled = enabled;
    }

    public static boolean isFusionOptionsEnabled() {
        return fusionOptionsEnabled;
    }

    public static void setInteractionOptionsEnabled(boolean enabled) {
        interactionOptionsEnabled = enabled;
    }

    public static boolean isInteractionOptionsEnabled() {
        return interactionOptionsEnabled;
    }

    public static void setZygardeOptionsEnabled(boolean enabled) {
        zygardeOptionsEnabled = enabled;
    }

    public static boolean isZygardeOptionsEnabled() {
        return zygardeOptionsEnabled;
    }

    public static void handlePokemonInteractionGUICreation(PokemonInteractionGUICreationEvent event) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_1799 heldStack = player.method_5998(class_1268.field_5808);
        if (heldStack.method_7960()) {
            return;
        }
        UUID pokemonUuid = event.getPokemonID();
        class_1792 heldItem = heldStack.method_7909();
        if (ClientSyncedConfig.isFusionItem(heldItem)) {
            MythsAndLegends.getLogger().debug("Held item {} matches a synced fusion rule, adding GUI option.", (Object)class_7923.field_41178.method_10221((Object)heldItem));
            InteractWheelOption fusionOption = new InteractWheelOption(class_2960.method_60655((String)"mythsandlegends", (String)"textures/gui/interact/icon_fuse.png"), null, fusionOptionsEnabled, "mythsandlegends.ui.interact.fuse.tooltip", () -> null, () -> {
                if (!fusionOptionsEnabled) {
                    return Unit.INSTANCE;
                }
                MythsAndLegends.getLogger().debug("Fusion wheel option pressed for {}", (Object)pokemonUuid);
                TriggerTransformationPacket packet = new TriggerTransformationPacket(pokemonUuid);
                NetworkManager.sendToServer((class_8710)packet);
                client.method_1507(null);
                return Unit.INSTANCE;
            });
            event.addFillingOption(fusionOption);
            MythsAndLegends.getLogger().debug("Added fusion option to interaction wheel.");
        }
        if (ClientSyncedConfig.isInteractionItem(heldItem)) {
            MythsAndLegends.getLogger().debug("Held item {} matches a synced interaction rule, adding GUI option.", (Object)class_7923.field_41178.method_10221((Object)heldItem));
            InteractWheelOption interactionOption = new InteractWheelOption(class_2960.method_60655((String)"mythsandlegends", (String)"textures/gui/interact/icon_change_form.png"), null, interactionOptionsEnabled, "mythsandlegends.ui.interact.change_form.tooltip", () -> null, () -> {
                if (!interactionOptionsEnabled) {
                    return Unit.INSTANCE;
                }
                MythsAndLegends.getLogger().debug("Interaction change wheel option pressed for {}", (Object)pokemonUuid);
                TriggerTransformationPacket packet = new TriggerTransformationPacket(pokemonUuid);
                NetworkManager.sendToServer((class_8710)packet);
                client.method_1507(null);
                return Unit.INSTANCE;
            });
            event.addFillingOption(interactionOption);
            MythsAndLegends.getLogger().debug("Added interaction transformation option to interaction wheel.");
        }
        if (heldItem instanceof ZygardeCubeBundleItem) {
            MythsAndLegends.getLogger().debug("Held item is Zygarde Cube, adding Zygarde options (server will validate).");
            InteractWheelOption zygardeTransformOption = new InteractWheelOption(class_2960.method_60655((String)"mythsandlegends", (String)"textures/gui/interact/icon_zygarde_transform.png"), null, zygardeOptionsEnabled, "mythsandlegends.ui.interact.zygarde_transform.tooltip", () -> null, () -> {
                if (!zygardeOptionsEnabled) {
                    return Unit.INSTANCE;
                }
                MythsAndLegends.getLogger().debug("Zygarde Transform wheel option pressed for {}", (Object)pokemonUuid);
                TriggerZygardeActionPacket packet = new TriggerZygardeActionPacket(pokemonUuid, TriggerZygardeActionPacket.ZygardeActionType.TRANSFORM);
                NetworkManager.sendToServer((class_8710)packet);
                client.method_1507(null);
                return Unit.INSTANCE;
            });
            event.addFillingOption(zygardeTransformOption);
            InteractWheelOption zygardeChargeOption = new InteractWheelOption(class_2960.method_60655((String)"mythsandlegends", (String)"textures/gui/interact/icon_zygarde_charge.png"), null, zygardeOptionsEnabled, "mythsandlegends.ui.interact.zygarde_charge.tooltip", () -> null, () -> {
                if (!zygardeOptionsEnabled) {
                    return Unit.INSTANCE;
                }
                MythsAndLegends.getLogger().debug("Zygarde Charge wheel option pressed for {}", (Object)pokemonUuid);
                TriggerZygardeActionPacket packet = new TriggerZygardeActionPacket(pokemonUuid, TriggerZygardeActionPacket.ZygardeActionType.CHARGE);
                NetworkManager.sendToServer((class_8710)packet);
                client.method_1507(null);
                return Unit.INSTANCE;
            });
            event.addFillingOption(zygardeChargeOption);
            MythsAndLegends.getLogger().debug("Added Zygarde Transform and Charge options to interaction wheel.");
        }
    }
}

