/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.item;

import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.position.FishingSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.items.ZygardeCubeBundleItem;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class ZygardeCubeChargeCondition
implements AppendageCondition {
    public int required_cells;
    public int required_cores;

    public boolean fits(@NotNull SpawnablePosition spawnablePosition) {
        FishingSpawnablePosition fishingSpawnablePosition;
        SpawnCause fishingContextCause;
        class_1297 causeEntity;
        if (this.required_cells <= 0 && this.required_cores <= 0) {
            return true;
        }
        class_3222 targetPlayer = null;
        Spawner spawner = spawnablePosition.getSpawner();
        if (spawner instanceof PlayerSpawner) {
            PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
            targetPlayer = MythsAndLegendsConditions.getPlayerFromUUID(spawnablePosition.getWorld(), playerSpawner.getUuid());
        } else if (spawnablePosition instanceof FishingSpawnablePosition && (causeEntity = (fishingContextCause = (fishingSpawnablePosition = (FishingSpawnablePosition)spawnablePosition).getCause()).getEntity()) instanceof class_3222) {
            class_3222 serverPlayerEntity;
            targetPlayer = serverPlayerEntity = (class_3222)causeEntity;
        }
        if (targetPlayer != null) {
            int checkCells = this.required_cells;
            int checkCores = this.required_cores;
            class_1792 zygardeCubeItem = ZygardeCubeBundleItem.getZygardeCubeItem();
            class_1792 cellItem = ZygardeCubeBundleItem.getCellItem();
            class_1792 coreItem = ZygardeCubeBundleItem.getCoreItem();
            if (zygardeCubeItem == null || zygardeCubeItem == class_1802.field_8162 || cellItem == null || cellItem == class_1802.field_8162 || coreItem == null || coreItem == class_1802.field_8162) {
                MythsAndLegends.getLogger().debug("Zygarde Cube items not found/registered. Condition check fails.");
                return false;
            }
            for (class_1799 stack : targetPlayer.method_31548().field_7547) {
                class_9276 contents;
                if (stack == null || stack.method_7960() || !stack.method_31574(zygardeCubeItem) || (contents = (class_9276)stack.method_57824(class_9334.field_49650)) == null || contents.method_57429()) continue;
                ArrayList<class_1799> cubeContents = new ArrayList<class_1799>();
                contents.method_59708().forEach(cubeContents::add);
                int cellsInThisCube = ZygardeCubeBundleItem.countItemsOfType(cubeContents, cellItem);
                int coresInThisCube = ZygardeCubeBundleItem.countItemsOfType(cubeContents, coreItem);
                if (cellsInThisCube < checkCells || coresInThisCube < checkCores) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public int getRequired_cells() {
        return this.required_cells;
    }

    public int getRequired_cores() {
        return this.required_cores;
    }
}

