/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.configs;

import com.github.d0ctorleon.mythsandlegends.configs.BroadcastConfig;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.moandjiezana.toml.Toml;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.class_2960;

public class ConfigManager {
    private static final Logger LOG = Logger.getLogger(ConfigManager.class.getName());
    private final File configFile;
    private ConfigVariables config;

    public ConfigManager() {
        Path configDirectoryPath = Platform.getConfigFolder().resolve("mythsandlegends");
        File configDirectory = configDirectoryPath.toFile();
        if (!configDirectory.exists() && !configDirectory.mkdirs()) {
            LOG.severe("Failed to create configuration directory: " + String.valueOf(configDirectory));
        }
        this.configFile = configDirectoryPath.resolve("config.toml").toFile();
        this.loadConfig(this.configFile);
    }

    private void loadConfig(File configFile) {
        ConfigVariables defaults = new ConfigVariables();
        boolean fallbackToDefaults = false;
        if (!configFile.exists()) {
            LOG.info("Configuration file not found. Creating a new one with default values.");
            this.config = defaults;
            fallbackToDefaults = true;
        } else {
            try {
                Toml toml = new Toml().read(configFile);
                ConfigVariables loaded = new ConfigVariables();
                loaded.inventory_check_interval = this.toInt(toml.getLong("inventory_check_interval"), defaults.inventory_check_interval);
                loaded.item_consumption_mode = this.toInt(toml.getLong("item_consumption_mode"), defaults.item_consumption_mode);
                loaded.inventory_check_shulker_boxes = this.toBoolean(toml.getBoolean("inventory_check_shulker_boxes"), defaults.inventory_check_shulker_boxes);
                loaded.inventory_check_bundles = this.toBoolean(toml.getBoolean("inventory_check_bundles"), defaults.inventory_check_bundles);
                loaded.isBroadcastEnabled = this.toBoolean(toml.getBoolean("isBroadcastEnabled"), defaults.isBroadcastEnabled);
                loaded.enable_force_spawning = this.toBoolean(toml.getBoolean("enable_force_spawning"), defaults.enable_force_spawning);
                loaded.force_spawning_spawn_pool = toml.getString("force_spawning_spawn_pool", defaults.force_spawning_spawn_pool);
                loaded.enable_vouchers = this.toBoolean(toml.getBoolean("enable_vouchers"), defaults.enable_vouchers);
                loaded.force_spawn_item_cooldown = this.toInt(toml.getLong("force_spawn_item_cooldown"), defaults.force_spawn_item_cooldown);
                loaded.global_item_cooldown = this.toBoolean(toml.getBoolean("global_item_cooldown"), defaults.global_item_cooldown);
                loaded.force_spawning_vouchers = this.toInt(toml.getLong("force_spawning_vouchers"), defaults.force_spawning_vouchers);
                loaded.global_item_vouchers = this.toBoolean(toml.getBoolean("global_item_vouchers"), defaults.global_item_vouchers);
                loaded.force_spawn_check_width = this.toInt(toml.getLong("force_spawn_check_width"), defaults.force_spawn_check_width);
                loaded.force_spawn_check_height = this.toInt(toml.getLong("force_spawn_check_height"), defaults.force_spawn_check_height);
                loaded.zygarde_cell_min_count = this.toInt(toml.getLong("zygarde_cell_min_count"), defaults.zygarde_cell_min_count);
                loaded.zygarde_cell_max_count = this.toInt(toml.getLong("zygarde_cell_max_count"), defaults.zygarde_cell_max_count);
                loaded.zygarde_core_min_count = this.toInt(toml.getLong("zygarde_core_min_count"), defaults.zygarde_core_min_count);
                loaded.zygarde_core_max_count = this.toInt(toml.getLong("zygarde_core_max_count"), defaults.zygarde_core_max_count);
                loaded.form_changes = this.toBoolean(toml.getBoolean("form_changes"), defaults.form_changes);
                loaded.debug_mode = this.toBoolean(toml.getBoolean("debug_mode"), defaults.debug_mode);
                loaded.ULTRA_RARE_ITEMS = this.readStringList(toml, "ULTRA_RARE_ITEMS", defaults.ULTRA_RARE_ITEMS);
                loaded.RARE_ITEMS = this.readStringList(toml, "RARE_ITEMS", defaults.RARE_ITEMS);
                loaded.COMMON_ITEMS = this.readStringList(toml, "COMMON_ITEMS", defaults.COMMON_ITEMS);
                List broadcastTables = toml.getTables("broadcast_settings");
                if (broadcastTables != null && !broadcastTables.isEmpty()) {
                    ArrayList<BroadcastConfig> bcList = new ArrayList<BroadcastConfig>();
                    for (Object t : broadcastTables) {
                        String name = t.getString("settingName");
                        Boolean value = t.getBoolean("settingValue");
                        if (name == null || value == null) continue;
                        bcList.add(new BroadcastConfig(name, value));
                    }
                    loaded.broadcast_settings = bcList;
                } else {
                    loaded.broadcast_settings = defaults.broadcast_settings;
                }
                Toml commonTable = toml.getTable("common_chest_chances");
                if (commonTable != null) {
                    HashMap<class_2960, Float> map = new HashMap<class_2960, Float>();
                    for (Map.Entry e : commonTable.entrySet()) {
                        Object rawValue = e.getValue();
                        if (!(rawValue instanceof Number)) continue;
                        Number number = (Number)rawValue;
                        String key = this.normalizeTomlKey((String)e.getKey());
                        try {
                            class_2960 id = class_2960.method_60654((String)key);
                            map.put(id, Float.valueOf(number.floatValue()));
                        }
                        catch (Exception ex) {
                            Logger.getLogger(ConfigManager.class.getName()).warning("Invalid entry in common_chest_chances: " + (String)e.getKey() + " = " + String.valueOf(rawValue));
                        }
                    }
                    loaded.common_chest_chances = map;
                } else {
                    loaded.common_chest_chances = defaults.common_chest_chances;
                }
                Toml rareTable = toml.getTable("rare_chest_chances");
                if (rareTable != null) {
                    HashMap<class_2960, Float> map = new HashMap<class_2960, Float>();
                    for (Map.Entry e : rareTable.entrySet()) {
                        Object rawValue = e.getValue();
                        if (!(rawValue instanceof Number)) continue;
                        Number number = (Number)rawValue;
                        String key = this.normalizeTomlKey((String)e.getKey());
                        try {
                            class_2960 id = class_2960.method_60654((String)key);
                            map.put(id, Float.valueOf(number.floatValue()));
                        }
                        catch (Exception ex) {
                            Logger.getLogger(ConfigManager.class.getName()).warning("Invalid entry in rare_chest_chances: " + (String)e.getKey() + " = " + String.valueOf(rawValue));
                        }
                    }
                    loaded.rare_chest_chances = map;
                } else {
                    loaded.rare_chest_chances = defaults.rare_chest_chances;
                }
                this.applyDefaultsIfNeeded(loaded);
                this.config = loaded;
            }
            catch (Exception e) {
                LOG.severe("Failed to load configuration file: " + e.getMessage() + ". Using default values.");
                this.config = defaults;
                fallbackToDefaults = true;
            }
        }
        this.saveConfigWithGeneralDescriptions(this.configFile);
        if (fallbackToDefaults) {
            LOG.info("Config was reset to defaults due to an error or missing file.");
        }
    }

    private String normalizeTomlKey(String key) {
        if (key == null) {
            return "";
        }
        if ((key = key.trim()).startsWith("\"") && key.endsWith("\"") || key.startsWith("'") && key.endsWith("'")) {
            key = key.substring(1, key.length() - 1);
        }
        return key;
    }

    private void applyDefaultsIfNeeded(ConfigVariables loadedConfig) {
        ConfigVariables defaults = new ConfigVariables();
        if (loadedConfig.broadcast_settings == null || loadedConfig.broadcast_settings.isEmpty()) {
            loadedConfig.broadcast_settings = defaults.broadcast_settings;
        } else {
            HashMap<String, Boolean> loadedMap = new HashMap<String, Boolean>();
            for (BroadcastConfig bc : loadedConfig.broadcast_settings) {
                if (bc == null || bc.settingName == null) continue;
                loadedMap.put(bc.settingName, bc.settingValue);
            }
            for (BroadcastConfig defaultBc : defaults.broadcast_settings) {
                if (loadedMap.containsKey(defaultBc.settingName)) continue;
                loadedConfig.broadcast_settings.add(new BroadcastConfig(defaultBc.settingName, defaultBc.settingValue));
            }
        }
        if (loadedConfig.common_chest_chances == null) {
            loadedConfig.common_chest_chances = defaults.common_chest_chances;
        }
        if (loadedConfig.rare_chest_chances == null) {
            loadedConfig.rare_chest_chances = defaults.rare_chest_chances;
        }
        if (loadedConfig.ULTRA_RARE_ITEMS == null) {
            loadedConfig.ULTRA_RARE_ITEMS = defaults.ULTRA_RARE_ITEMS;
        }
        if (loadedConfig.RARE_ITEMS == null) {
            loadedConfig.RARE_ITEMS = defaults.RARE_ITEMS;
        }
        if (loadedConfig.COMMON_ITEMS == null) {
            loadedConfig.COMMON_ITEMS = defaults.COMMON_ITEMS;
        }
    }

    private int toInt(Long value, int defaultValue) {
        return value != null ? value.intValue() : defaultValue;
    }

    private boolean toBoolean(Boolean value, boolean defaultValue) {
        return value != null ? value : defaultValue;
    }

    private List<String> readStringList(Toml toml, String key, List<String> defaultValue) {
        List raw = toml.getList(key);
        if (raw == null) {
            return defaultValue;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object o : raw) {
            if (o == null) continue;
            result.add(o.toString());
        }
        return result;
    }

    public void saveConfig() {
        this.saveConfigWithGeneralDescriptions(this.configFile);
    }

    private void saveConfigWithGeneralDescriptions(File configFile) {
        if (this.config == null) {
            LOG.severe("Config object is null, initializing defaults before saving.");
            this.config = new ConfigVariables();
        }
        StringBuilder tomlContent = new StringBuilder();
        tomlContent.append("# === Inventory Check Settings ===\n\n");
        tomlContent.append("# Interval in Minecraft ticks for checking player inventories. Default: 3600 (3 minutes).\n");
        tomlContent.append("inventory_check_interval = ").append(this.config.inventory_check_interval).append("\n\n");
        tomlContent.append("# Controls how items are consumed during spawning events. Default: 1.\n");
        tomlContent.append("# Modes:\n");
        tomlContent.append("# 0: No items consumed.\n");
        tomlContent.append("# 1: Legacy Mode - Consumes Key Items, Zygarde items, and CustomItems marked 'consume: true' on regular spawns.\n");
        tomlContent.append("# 2: Force Spawn Only - Consumes triggering item + required items ONLY on successful force spawns.\n");
        tomlContent.append("# 3: Always Consume - Consumes required items on both regular and force spawns, ignoring 'consume' flag.\n");
        tomlContent.append("# 4: Consume Flag Only - Consumes CustomItems marked 'consume: true' on regular/force spawns. Key/Zygarde items only consumed if used as force spawn trigger.\n");
        tomlContent.append("item_consumption_mode = ").append(this.config.item_consumption_mode).append("\n\n");
        tomlContent.append("# Scan shulker boxes during inventory checks? Default: true.\n");
        tomlContent.append("inventory_check_shulker_boxes = ").append(this.config.inventory_check_shulker_boxes).append("\n\n");
        tomlContent.append("# Scan bundles during inventory checks? Default: true.\n");
        tomlContent.append("inventory_check_bundles = ").append(this.config.inventory_check_bundles).append("\n\n");
        tomlContent.append("# === Broadcasting Settings ===\n\n");
        tomlContent.append("# Master switch to enable/disable all broadcast messages from this mod. Default: false\n");
        tomlContent.append("isBroadcastEnabled = ").append(this.config.isBroadcastEnabled).append("\n\n");
        tomlContent.append("# Specific settings for broadcast messages when certain Pokemon spawn.\n");
        tomlContent.append("# Format: { settingName = \"Name\", settingValue = true/false }\n");
        tomlContent.append("broadcast_settings = [\n");
        HashMap<String, String> broadcastComments = new HashMap<String, String>();
        broadcastComments.put("BroadcastToAll", " # Broadcast to all players? Default: true.");
        broadcastComments.put("DisplayName", "  # Show Pokemon name? Default: true.");
        broadcastComments.put("Legendarys", " # Broadcast Legendary spawns? Default: true.");
        broadcastComments.put("Mythicals", " # Broadcast Mythical spawns? Default: true.");
        broadcastComments.put("UltraBeasts", " # Broadcast Ultra Beast spawns? Default: false.");
        broadcastComments.put("Location", " # Include spawn location? Default: true.");
        broadcastComments.put("Shiny", " # Announce if shiny? Default: false.");
        broadcastComments.put("Level", " # Include Pokemon level? Default: true.");
        broadcastComments.put("XaerosMinimapSupport", " # Add Xaero's Minimap waypoint format if Location is true? Default: false.");
        if (this.config.broadcast_settings != null) {
            int lastCommaIndex;
            for (BroadcastConfig setting : this.config.broadcast_settings) {
                if (setting == null || setting.settingName == null) continue;
                tomlContent.append("  { settingName = \"").append(setting.settingName).append("\", settingValue = ").append(setting.settingValue).append(" },").append(broadcastComments.getOrDefault(setting.settingName, "")).append("\n");
            }
            if (!this.config.broadcast_settings.isEmpty() && (lastCommaIndex = tomlContent.lastIndexOf(",")) != -1 && lastCommaIndex > tomlContent.lastIndexOf("[")) {
                tomlContent.deleteCharAt(lastCommaIndex);
            }
        } else {
            LOG.warning("broadcast_settings list is null during save.");
        }
        tomlContent.append("]\n\n");
        tomlContent.append("# === Force Spawning Settings ===\n\n");
        tomlContent.append("# Allow players to force spawn Pokemon by right-clicking specific 'key items'? Default: true\n");
        tomlContent.append("enable_force_spawning = ").append(this.config.enable_force_spawning).append("\n\n");
        tomlContent.append("# Which spawn pool rarity to check when attempting a force spawn (e.g., common, rare, ultra-rare). Default: ultra-rare\n");
        tomlContent.append("# Note: This influences WHICH Pokemon are considered, not their inherent rarity defined in datapacks.\n");
        tomlContent.append("force_spawning_spawn_pool = \"").append(this.config.force_spawning_spawn_pool).append("\"\n\n");
        tomlContent.append("# --- Voucher & Cooldown Settings (for Force Spawning) ---\n\n");
        tomlContent.append("# Master switch for the voucher/cooldown system for force spawning. If false, items can be used limitlessly. Default: false\n");
        tomlContent.append("enable_vouchers = ").append(this.config.enable_vouchers).append("\n\n");
        tomlContent.append("# Cooldown (in seconds) after using a key item for force spawning (only if enable_vouchers=true). Default: 20\n");
        tomlContent.append("force_spawn_item_cooldown = ").append(this.config.force_spawn_item_cooldown).append("\n\n");
        tomlContent.append("# Apply cooldown globally? If true, using *any* key item puts *all* key items on cooldown (only if enable_vouchers=true). Default: false\n");
        tomlContent.append("global_item_cooldown = ").append(this.config.global_item_cooldown).append("\n\n");
        tomlContent.append("# Max number of uses ('vouchers') before a key item goes on cooldown (only if enable_vouchers=true). Default: 1\n");
        tomlContent.append("force_spawning_vouchers = ").append(this.config.force_spawning_vouchers).append("\n\n");
        tomlContent.append("# Share voucher limit globally? If true, players have a total pool of uses across all key items (only if enable_vouchers=true). Default: false\n");
        tomlContent.append("global_item_vouchers = ").append(this.config.global_item_vouchers).append("\n\n");
        tomlContent.append("# === Spawning Area Settings (for Force Spawning) ===\n\n");
        tomlContent.append("# Width (X/Z diameter) around player to check for valid spawn locations during force spawn. Default: 100\n");
        tomlContent.append("# Set to -1 to use Cobblemon's default worldSliceDiameter. Larger values may increase lag.\n");
        tomlContent.append("force_spawn_check_width = ").append(this.config.force_spawn_check_width).append("\n\n");
        tomlContent.append("# Height (Y range) around player to check for valid spawn locations during force spawn. Default: 50\n");
        tomlContent.append("# Set to -1 to use Cobblemon's default worldSliceHeight. Larger values may increase lag.\n");
        tomlContent.append("force_spawn_check_height = ").append(this.config.force_spawn_check_height).append("\n\n");
        tomlContent.append("# === Item Rarity Lists ===\n\n");
        tomlContent.append("# Lists of item IDs used to categorize items by rarity for various mod functions (e.g., potential spawn triggers).\n");
        tomlContent.append("ULTRA_RARE_ITEMS = ").append(this.listToString(this.config.ULTRA_RARE_ITEMS)).append("\n\n");
        tomlContent.append("RARE_ITEMS = ").append(this.listToString(this.config.RARE_ITEMS)).append("\n\n");
        tomlContent.append("COMMON_ITEMS = ").append(this.listToString(this.config.COMMON_ITEMS)).append("\n\n");
        tomlContent.append("# === Loot Chest Configuration ===\n\n");
        tomlContent.append("# Defines chances (0.0 to 1.0) to attempt injecting this mod's loot\n");
        tomlContent.append("# into specific vanilla/modded loot tables (identified by their ID string).\n\n");
        tomlContent.append("# Settings for common chests/loot sources.\n");
        tomlContent.append("[common_chest_chances]\n");
        if (this.config.common_chest_chances != null) {
            for (Map.Entry<class_2960, Float> entry : this.config.common_chest_chances.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                tomlContent.append("  \"").append(entry.getKey().toString()).append("\" = ").append(entry.getValue()).append("\n");
            }
        } else {
            LOG.warning("common_chest_chances map is null during save.");
            tomlContent.append("  # common_chest_chances map was null, defaults might apply on load.\n");
        }
        tomlContent.append("\n");
        tomlContent.append("# Settings for rare chests/loot sources.\n");
        tomlContent.append("[rare_chest_chances]\n");
        if (this.config.rare_chest_chances != null) {
            for (Map.Entry<class_2960, Float> entry : this.config.rare_chest_chances.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                tomlContent.append("  \"").append(entry.getKey().toString()).append("\" = ").append(entry.getValue()).append("\n");
            }
        } else {
            LOG.warning("rare_chest_chances map is null during save.");
            tomlContent.append("  # rare_chest_chances map was null, defaults might apply on load.\n");
        }
        tomlContent.append("\n");
        tomlContent.append("# === Zygarde Cell/Core Counts ===\n\n");
        tomlContent.append("# Minimum and maximum count for Zygarde Cells when generated/dropped.\n");
        tomlContent.append("zygarde_cell_min_count = ").append(this.config.zygarde_cell_min_count).append("\n");
        tomlContent.append("zygarde_cell_max_count = ").append(this.config.zygarde_cell_max_count).append("\n\n");
        tomlContent.append("# Minimum and maximum count for Zygarde Cores when generated/dropped.\n");
        tomlContent.append("zygarde_core_min_count = ").append(this.config.zygarde_core_min_count).append("\n");
        tomlContent.append("zygarde_core_max_count = ").append(this.config.zygarde_core_max_count).append("\n\n");
        tomlContent.append("# === Other Settings ===\n\n");
        tomlContent.append("# Enable form changes triggered by items (e.g., DNA Splicers, Griseous Orb)? Default: true\n");
        tomlContent.append("form_changes = ").append(this.config.form_changes).append("\n\n");
        tomlContent.append("# Enable extensive debug logging? Only intended for development. LEAVE FALSE. Default: false\n");
        tomlContent.append("debug_mode = ").append(this.config.debug_mode).append("\n\n");
        try (FileWriter writer = new FileWriter(configFile);){
            writer.write(tomlContent.toString());
        }
        catch (IOException e) {
            LOG.severe("Failed to write config file: " + configFile.getPath() + " - " + e.getMessage());
        }
    }

    private String listToString(List<String> list) {
        int lastCommaIndex;
        if (list == null) {
            LOG.warning("Attempted to save a null list to config.");
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[\n");
        for (String item : list) {
            if (item != null) {
                String escapedItem = item.replace("\\", "\\\\").replace("\"", "\\\"");
                sb.append("  \"").append(escapedItem).append("\",\n");
                continue;
            }
            LOG.warning("Null item found in list being saved to config.");
        }
        if (!list.isEmpty() && (lastCommaIndex = sb.lastIndexOf(",")) != -1) {
            sb.delete(lastCommaIndex, lastCommaIndex + 2);
        }
        sb.append("\n]");
        return sb.toString();
    }

    public ConfigVariables getConfig() {
        return this.config;
    }
}

