/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.configs;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.utils.FusionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.HeldItemTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.InteractionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationConfig;
import com.github.d0ctorleon.mythsandlegends.utils.gson.ResourceLocationTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class FormChangeConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(class_2960.class, (Object)new ResourceLocationTypeAdapter()).create();
    private static final String CONFIG_FILE_NAME = "transformations.json";
    private static final Path CONFIG_PATH = Platform.getConfigFolder().resolve("mythsandlegends").resolve("transformations.json");
    private static TransformationConfig loadedConfig = new TransformationConfig();

    public static void loadConfig() {
        MythsAndLegends.getLogger().info("Loading transformations config from: {}", (Object)CONFIG_PATH);
        File configFile = CONFIG_PATH.toFile();
        boolean createdNew = false;
        if (!configFile.exists()) {
            MythsAndLegends.getLogger().warn("Transformations config file not found! Creating default.");
            FormChangeConfig.createDefaultConfig(configFile);
            createdNew = true;
        }
        try (FileReader reader = new FileReader(configFile, StandardCharsets.UTF_8);){
            TransformationConfig config = (TransformationConfig)GSON.fromJson((Reader)reader, TransformationConfig.class);
            if (config != null) {
                loadedConfig = config;
                MythsAndLegends.getLogger().info("Successfully parsed transformations config.");
                FormChangeConfig.validateConfig(loadedConfig);
                MythsAndLegends.getLogger().info("Validated config: {} held item changes, {} interaction changes, {} fusions remain active.", (Object)FormChangeConfig.loadedConfig.heldItemChanges.size(), (Object)FormChangeConfig.loadedConfig.interactionChanges.size(), (Object)FormChangeConfig.loadedConfig.fusions.size());
            } else if (!createdNew) {
                MythsAndLegends.getLogger().error("Failed to parse transformations config file (result was null). Using empty defaults.");
                loadedConfig = new TransformationConfig();
            } else {
                MythsAndLegends.getLogger().info("Using empty default config created.");
                loadedConfig = new TransformationConfig();
            }
        }
        catch (IOException e) {
            MythsAndLegends.getLogger().error("Error reading transformations config file: {}", (Object)e.getMessage(), (Object)e);
            loadedConfig = new TransformationConfig();
        }
        catch (Exception e) {
            MythsAndLegends.getLogger().error("Error parsing transformations config file: {}", (Object)e.getMessage(), (Object)e);
            loadedConfig = new TransformationConfig();
        }
    }

    private static void createDefaultConfig(File configFile) {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            TransformationConfig defaultConfig = new TransformationConfig();
            defaultConfig.heldItemChanges.add(new HeldItemTransformation("dialga", class_2960.method_60655((String)"mythsandlegends", (String)"adamant_orb"), "origin", true, true));
            defaultConfig.heldItemChanges.add(new HeldItemTransformation("palkia", class_2960.method_60655((String)"mythsandlegends", (String)"lustrous_orb"), "origin", true, true));
            defaultConfig.heldItemChanges.add(new HeldItemTransformation("giratina", class_2960.method_60655((String)"mythsandlegends", (String)"griseous_orb"), "origin", true, true));
            defaultConfig.interactionChanges.add(new InteractionTransformation("hoopa", class_2960.method_60655((String)"mythsandlegends", (String)"prison_bottle"), "unbound", true, true));
            defaultConfig.interactionChanges.add(new InteractionTransformation("tornadus", class_2960.method_60655((String)"mythsandlegends", (String)"reveal_glass"), "therian", true, true));
            defaultConfig.interactionChanges.add(new InteractionTransformation("thundurus", class_2960.method_60655((String)"mythsandlegends", (String)"reveal_glass"), "therian", true, true));
            defaultConfig.interactionChanges.add(new InteractionTransformation("landorus", class_2960.method_60655((String)"mythsandlegends", (String)"reveal_glass"), "therian", true, true));
            defaultConfig.interactionChanges.add(new InteractionTransformation("enamorus", class_2960.method_60655((String)"mythsandlegends", (String)"reveal_glass"), "therian", true, true));
            defaultConfig.fusions.add(new FusionTransformation("calyrex", "spectrier", class_2960.method_60655((String)"mythsandlegends", (String)"reins_of_unity"), "shadow", true, false));
            defaultConfig.fusions.add(new FusionTransformation("calyrex", "glastrier", class_2960.method_60655((String)"mythsandlegends", (String)"reins_of_unity"), "ice", true, false));
            defaultConfig.fusions.add(new FusionTransformation("kyurem", "reshiram", class_2960.method_60655((String)"mythsandlegends", (String)"dna_splicer"), "white", true, false));
            defaultConfig.fusions.add(new FusionTransformation("kyurem", "zekrom", class_2960.method_60655((String)"mythsandlegends", (String)"dna_splicer"), "black", true, false));
            try (FileWriter writer = new FileWriter(configFile, StandardCharsets.UTF_8);){
                GSON.toJson((Object)defaultConfig, (Appendable)writer);
                MythsAndLegends.getLogger().info("Created default transformations config file with predefined values.");
            }
        }
        catch (IOException e) {
            MythsAndLegends.getLogger().error("Could not create default transformations config file: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void validateConfig(TransformationConfig config) {
        MythsAndLegends.getLogger().info("Validating transformation rules...");
        int initialHeld = config.heldItemChanges.size();
        int initialInteraction = config.interactionChanges.size();
        int initialFusion = config.fusions.size();
        FormChangeConfig.validateHeldItemRules(config.heldItemChanges.iterator());
        FormChangeConfig.validateInteractionRules(config.interactionChanges.iterator());
        FormChangeConfig.validateFusionRules(config.fusions.iterator());
        int removedHeld = initialHeld - config.heldItemChanges.size();
        int removedInteraction = initialInteraction - config.interactionChanges.size();
        int removedFusion = initialFusion - config.fusions.size();
        if (removedHeld > 0 || removedInteraction > 0 || removedFusion > 0) {
            MythsAndLegends.getLogger().warn("Removed invalid rules during validation: {} held item, {} interaction, {} fusion.", (Object)removedHeld, (Object)removedInteraction, (Object)removedFusion);
        } else {
            MythsAndLegends.getLogger().info("All transformation rules validated successfully.");
        }
    }

    private static void validateHeldItemRules(Iterator<HeldItemTransformation> iterator) {
        while (iterator.hasNext()) {
            HeldItemTransformation rule = iterator.next();
            Species species = FormChangeConfig.findSpecies(rule.pokemon);
            boolean remove = false;
            if (species == null) {
                FormChangeConfig.logValidationWarning("HeldItem", rule.pokemon, "Invalid base species");
                remove = true;
            } else {
                if (!FormChangeConfig.isValidForm(species, rule.targetForm)) {
                    FormChangeConfig.logValidationWarning("HeldItem", rule.pokemon, "Invalid targetForm '" + rule.targetForm + "'");
                    remove = true;
                }
                if (!FormChangeConfig.isValidItem(rule.item)) {
                    FormChangeConfig.logValidationWarning("HeldItem", rule.pokemon, "Invalid item '" + String.valueOf(rule.item) + "'");
                    remove = true;
                }
            }
            if (!remove) continue;
            iterator.remove();
        }
    }

    private static void validateInteractionRules(Iterator<InteractionTransformation> iterator) {
        while (iterator.hasNext()) {
            InteractionTransformation rule = iterator.next();
            Species species = FormChangeConfig.findSpecies(rule.pokemon);
            boolean remove = false;
            if (species == null) {
                FormChangeConfig.logValidationWarning("Interaction", rule.pokemon, "Invalid base species");
                remove = true;
            } else {
                if (!FormChangeConfig.isValidForm(species, rule.targetForm)) {
                    FormChangeConfig.logValidationWarning("Interaction", rule.pokemon, "Invalid targetForm '" + rule.targetForm + "'");
                    remove = true;
                }
                if (!FormChangeConfig.isValidItem(rule.item)) {
                    FormChangeConfig.logValidationWarning("Interaction", rule.pokemon, "Invalid item '" + String.valueOf(rule.item) + "'");
                    remove = true;
                }
            }
            if (!remove) continue;
            iterator.remove();
        }
    }

    private static void validateFusionRules(Iterator<FusionTransformation> iterator) {
        while (iterator.hasNext()) {
            FusionTransformation rule = iterator.next();
            Species baseSpecies = FormChangeConfig.findSpecies(rule.basePokemon);
            Species partnerSpecies = FormChangeConfig.findSpecies(rule.partnerPokemon);
            boolean remove = false;
            if (baseSpecies == null) {
                FormChangeConfig.logValidationWarning("Fusion", rule.basePokemon + "/" + rule.partnerPokemon, "Invalid base species '" + rule.basePokemon + "'");
                remove = true;
            } else if (!FormChangeConfig.isValidForm(baseSpecies, rule.resultingForm)) {
                FormChangeConfig.logValidationWarning("Fusion", rule.basePokemon + "/" + rule.partnerPokemon, "Invalid resultingForm '" + rule.resultingForm + "' for base species");
                remove = true;
            }
            if (partnerSpecies == null) {
                FormChangeConfig.logValidationWarning("Fusion", rule.basePokemon + "/" + rule.partnerPokemon, "Invalid partner species '" + rule.partnerPokemon + "'");
                remove = true;
            }
            if (!FormChangeConfig.isValidItem(rule.item)) {
                FormChangeConfig.logValidationWarning("Fusion", rule.basePokemon + "/" + rule.partnerPokemon, "Invalid item '" + String.valueOf(rule.item) + "'");
                remove = true;
            }
            if (!remove) continue;
            iterator.remove();
        }
    }

    public static Species findSpecies(String name) {
        if (name == null || name.isBlank()) {
            return null;
        }
        return PokemonSpecies.INSTANCE.getSpecies().stream().filter(species -> species.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private static boolean isValidForm(Species species, String formName) {
        if (species == null || formName == null || formName.isBlank()) {
            return false;
        }
        return species.getForms().stream().anyMatch(f -> f.getName().equalsIgnoreCase(formName));
    }

    private static boolean isValidItem(class_2960 itemId) {
        if (itemId == null) {
            return false;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
        return item != class_1802.field_8162;
    }

    private static void logValidationWarning(String ruleType, String ruleKeyInfo, String message) {
        MythsAndLegends.getLogger().warn("Validation Error [{} Rule for {}]: {}", (Object)ruleType, (Object)ruleKeyInfo, (Object)message);
    }

    public static TransformationConfig getConfig() {
        return loadedConfig;
    }
}

