/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.net;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.FormChangeConfig;
import com.github.d0ctorleon.mythsandlegends.net.SyncTransformConfigPacket;
import com.github.d0ctorleon.mythsandlegends.net.TriggerTransformationPacket;
import com.github.d0ctorleon.mythsandlegends.net.TriggerZygardeActionPacket;
import com.github.d0ctorleon.mythsandlegends.utils.FusionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.InteractionTransformation;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationConfig;
import com.github.d0ctorleon.mythsandlegends.utils.TransformationHelper;
import com.github.d0ctorleon.mythsandlegends.utils.ZygardeUtil;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Logger;

public class MythsAndLegendsNetworking {
    private static final Logger LOGGER = MythsAndLegends.getLogger();

    public static void init() {
        MythsAndLegendsNetworking.registerPacketsC2S();
        if (Platform.getEnv().equals((Object)EnvType.SERVER)) {
            MythsAndLegendsNetworking.registerS2CServer();
        }
    }

    private static void registerS2CServer() {
        NetworkManager.registerS2CPayloadType(SyncTransformConfigPacket.ID, SyncTransformConfigPacket.CODEC);
        LOGGER.info("Registered S2C SyncTransformConfigPacket payload type on server.");
    }

    public static void registerPacketsC2S() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, TriggerTransformationPacket.ID, TriggerTransformationPacket.CODEC, (packet, context) -> {
            class_1657 player = context.getPlayer();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                context.queue(() -> MythsAndLegendsNetworking.handleTransformationTrigger(serverPlayer, packet.pokemonId()));
            } else {
                LOGGER.warn("Received TriggerTransformationPacket from a non-ServerPlayerEntity or null player: {}", (Object)player);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, TriggerZygardeActionPacket.ID, TriggerZygardeActionPacket.CODEC, (packet, context) -> {
            class_1657 player = context.getPlayer();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (packet.actionType() == TriggerZygardeActionPacket.ZygardeActionType.TRANSFORM) {
                    context.queue(() -> ZygardeUtil.handleZygardeFormChange(serverPlayer, packet.pokemonId()));
                } else if (packet.actionType() == TriggerZygardeActionPacket.ZygardeActionType.CHARGE) {
                    context.queue(() -> ZygardeUtil.handleZygardeCharge(serverPlayer, packet.pokemonId()));
                }
            } else {
                LOGGER.warn("Received TriggerZygardeActionPacket from a non-ServerPlayerEntity or null player: {}", (Object)player);
            }
        });
        LOGGER.info("Registered C2S network packets for Myths and Legends.");
    }

    private static void handleTransformationTrigger(class_3222 player, UUID pokemonId) {
        if (player == null || player.method_51469() == null) {
            LOGGER.warn("Received transformation trigger packet with null player or world.");
            return;
        }
        class_1297 entity = player.method_51469().method_14190(pokemonId);
        if (!(entity instanceof PokemonEntity)) {
            LOGGER.warn("Received transformation trigger packet for non-Pokemon entity or invalid UUID: {}", (Object)pokemonId);
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        if (pokemonEntity.getPokemon().getOwnerUUID() != null && !pokemonEntity.getPokemon().getOwnerUUID().equals(player.method_5667())) {
            LOGGER.warn("Player {} tried to trigger transformation on Pokemon {} they don't own via packet.", (Object)player.method_5477().getString(), (Object)pokemonId);
            return;
        }
        if (pokemonEntity.isBattleClone()) {
            LOGGER.debug("Transformation trigger ignored for battle clone {}", (Object)pokemonId);
            return;
        }
        Pokemon targetPokemon = pokemonEntity.getPokemon();
        class_1799 heldStack = player.method_6047();
        String speciesName = targetPokemon.getSpecies().getName().toLowerCase();
        TransformationConfig config = FormChangeConfig.getConfig();
        LOGGER.debug("Handling transformation trigger for {} from player {} with item {}", (Object)speciesName, (Object)player.method_5477().getString(), (Object)heldStack.method_7909());
        for (FusionTransformation fusionTransformation : config.fusions) {
            if (!fusionTransformation.basePokemon.equalsIgnoreCase(speciesName)) continue;
            LOGGER.debug("Checking fusion/unfusion rule for {}", (Object)speciesName);
            if (!TransformationHelper.tryApplyFusionOrUnfusion(player, targetPokemon, heldStack, fusionTransformation, class_1268.field_5808)) continue;
            LOGGER.debug("Applied fusion/unfusion based on rule via packet.");
            player.method_6104(class_1268.field_5808);
            return;
        }
        for (InteractionTransformation interactionTransformation : config.interactionChanges) {
            if (!interactionTransformation.pokemon.equalsIgnoreCase(speciesName)) continue;
            LOGGER.debug("Checking interaction rule for {}", (Object)speciesName);
            if (!TransformationHelper.tryApplyInteractionChange(player, targetPokemon, heldStack, interactionTransformation)) continue;
            LOGGER.debug("Applied interaction form change based on rule via packet.");
            player.method_6104(class_1268.field_5808);
            return;
        }
        LOGGER.debug("No matching transformation rule found for {} with item {} via packet trigger.", (Object)speciesName, (Object)heldStack.method_7909());
    }
}

