/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.utils.gson.ResourceLocationTypeAdapter;
import com.github.d0ctorleon.mythsandlegends.utils.gson.UUIDTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3545;

public class DebtUtils {
    private final String DEBT_FILE;
    private Map<UUID, Map<class_2960, Integer>> playerDebts = new HashMap<UUID, Map<class_2960, Integer>>();
    private Gson gson = new Gson();

    public DebtUtils(Path configDirectoryPath) {
        this.DEBT_FILE = configDirectoryPath.resolve("debts.json").toString();
        this.gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeAdapter(class_2960.class, (Object)new ResourceLocationTypeAdapter()).create();
        this.loadDebts();
    }

    public Map<UUID, Map<class_2960, Integer>> getDebts() {
        return this.playerDebts;
    }

    public Map<class_2960, Integer> getDebtsForPlayer(UUID playerId) {
        Map<class_2960, Integer> debts = this.playerDebts.get(playerId);
        if (debts == null || debts.isEmpty()) {
            return Collections.emptyMap();
        }
        return new HashMap<class_2960, Integer>(debts);
    }

    public void addDebt(UUID playerId, class_2960 itemId, int count) {
        Map playerDebt = this.playerDebts.computeIfAbsent(playerId, k -> new HashMap());
        playerDebt.put(itemId, playerDebt.getOrDefault(itemId, 0) + count);
        this.saveDebts();
    }

    public void clearDebt(UUID playerId, class_2960 itemId) {
        Map<class_2960, Integer> playerDebt = this.playerDebts.get(playerId);
        if (playerDebt != null) {
            playerDebt.remove(itemId);
            if (playerDebt.isEmpty()) {
                this.playerDebts.remove(playerId);
            }
        }
        this.saveDebts();
    }

    public class_3545<String, String> splitIdentifier(class_2960 identifier) {
        String namespace = identifier.method_12836();
        String path = identifier.method_12832();
        return new class_3545((Object)namespace, (Object)path);
    }

    public boolean isInDebt(UUID playerId, class_2960 itemId) {
        Map<class_2960, Integer> playerDebt = this.playerDebts.get(playerId);
        return playerDebt != null && playerDebt.containsKey(itemId);
    }

    public int getDebtAmount(UUID playerId, class_2960 itemId) {
        Map<class_2960, Integer> playerDebt = this.playerDebts.get(playerId);
        return playerDebt != null ? playerDebt.getOrDefault(itemId, 0) : 0;
    }

    private void saveDebts() {
        try (FileWriter writer = new FileWriter(this.DEBT_FILE);){
            this.gson.toJson(this.playerDebts, (Appendable)writer);
        }
        catch (IOException e) {
            MythsAndLegends.getLogger().error("Failed to save debts to file: " + this.DEBT_FILE);
        }
    }

    public void loadDebts() {
        File file = new File(this.DEBT_FILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
                this.playerDebts = new HashMap<UUID, Map<class_2960, Integer>>();
                this.saveDebts();
            }
            catch (IOException e) {
                MythsAndLegends.getLogger().error("Failed to create debts file: " + this.DEBT_FILE);
            }
        } else {
            try (FileReader reader = new FileReader(file);){
                this.playerDebts = (Map)this.gson.fromJson((Reader)reader, new TypeToken<HashMap<UUID, Map<class_2960, Integer>>>(this){}.getType());
            }
            catch (IOException e) {
                MythsAndLegends.getLogger().error("Failed to load debts from file: " + this.DEBT_FILE);
            }
        }
    }
}

