/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ConfigVariables;
import com.github.d0ctorleon.mythsandlegends.utils.DebtUtils;
import com.github.d0ctorleon.mythsandlegends.utils.InventoryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2480;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5537;
import net.minecraft.class_7923;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class PlayerDataUtils {
    private static final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private static ConfigVariables modConfig;

    public static void setModConfig(ConfigVariables config) {
        modConfig = config;
    }

    public static PlayerData getPlayerData(class_1657 player) {
        return playerDataMap.computeIfAbsent(player.method_5667(), k -> new PlayerData());
    }

    public static void updatePlayerData(class_1657 player) {
        PlayerData data = PlayerDataUtils.getPlayerData(player);
        data.clearTrackedData();
        HashMap<class_1792, Integer> currentItemCounts = new HashMap<class_1792, Integer>();
        DebtUtils debtUtils = MythsAndLegends.getDebtUtils();
        debtUtils.loadDebts();
        Map<class_2960, Integer> playerDebts = debtUtils.getDebtsForPlayer(player.method_5667());
        if (!playerDebts.isEmpty() && player instanceof class_3222) {
            Iterator serverPlayerEntity = (class_3222)player;
            for (Map.Entry<class_2960, Integer> debtEntry : playerDebts.entrySet()) {
                class_2960 debtItemId = debtEntry.getKey();
                Optional debtItemOpt = class_7923.field_41178.method_17966(debtItemId);
                if (debtItemOpt.isPresent()) {
                    int debtCount;
                    class_1792 debtItem = (class_1792)debtItemOpt.get();
                    if (InventoryUtils.removeItemFromInventory(serverPlayerEntity, debtItem, debtCount = debtEntry.getValue().intValue(), false, false)) {
                        debtUtils.clearDebt(player.method_5667(), debtItemId);
                        MythsAndLegends.getLogger().info("Cleared debt for {} item {} x{}", (Object)player.method_5477().getString(), (Object)debtItemId, (Object)debtCount);
                        continue;
                    }
                    MythsAndLegends.getLogger().warn("Failed to remove debt item {} x{} for {}", (Object)debtItemId, (Object)debtCount, (Object)player.method_5477().getString());
                    continue;
                }
                MythsAndLegends.getLogger().error("Debt item ID not found in registry: {}", (Object)debtItemId);
            }
        }
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960()) continue;
            class_1792 currentItem = stack.method_7909();
            data.setItemState(currentItem, true);
            currentItemCounts.merge(currentItem, stack.method_7947(), Integer::sum);
            if (PlayerDataUtils.modConfig.inventory_check_bundles && currentItem instanceof class_5537) {
                PlayerDataUtils.checkItemsInContainer(stack, data, currentItemCounts);
            }
            if (!PlayerDataUtils.modConfig.inventory_check_shulker_boxes || !(currentItem instanceof class_1747) || !(((class_1747)currentItem).method_7711() instanceof class_2480)) continue;
            PlayerDataUtils.checkItemsInContainer(stack, data, currentItemCounts);
        }
        for (Map.Entry entry : currentItemCounts.entrySet()) {
            data.setItemCount((class_1792)entry.getKey(), (Integer)entry.getValue());
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            List<Pokemon> currentParty = PlayerDataUtils.getPokemonsInPlayerParty(serverPlayer);
            data.setPartyPokemon(currentParty);
        } else {
            data.setPartyPokemon(Collections.emptyList());
        }
    }

    public static List<Pokemon> getPokemonsInPlayerParty(class_3222 player) {
        ArrayList<Pokemon> pokemons = new ArrayList<Pokemon>();
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (partyStore == null) {
            MythsAndLegends.getLogger().warn("Could not retrieve party store for player {}", (Object)player.method_5477().getString());
            return pokemons;
        }
        for (int slot = 0; slot < partyStore.size(); ++slot) {
            Pokemon pokemon = partyStore.get(slot);
            if (pokemon == null) continue;
            pokemons.add(pokemon);
        }
        return pokemons;
    }

    public static boolean hasPokemonSpeciesInParty(class_3222 player, Species speciesToCheck) {
        if (speciesToCheck == null) {
            return false;
        }
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (partyStore == null) {
            return false;
        }
        for (Pokemon partyPokemon : partyStore) {
            if (partyPokemon == null || !speciesToCheck.equals(partyPokemon.getSpecies())) continue;
            return true;
        }
        return false;
    }

    public static List<Species> getPokemonSpeciesInParty(class_3222 player) {
        ArrayList<Species> pokemonSpeciesInParty = new ArrayList<Species>();
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (partyStore == null) {
            return pokemonSpeciesInParty;
        }
        for (Pokemon partyPokemon : partyStore) {
            if (partyPokemon == null) continue;
            pokemonSpeciesInParty.add(partyPokemon.getSpecies());
        }
        return pokemonSpeciesInParty;
    }

    private static void checkItemsInContainer(class_1799 containerStack, PlayerData data, Map<class_1792, Integer> currentItemCounts) {
        block4: {
            class_9288 containerComponent;
            class_1792 containerItem;
            block3: {
                containerItem = containerStack.method_7909();
                if (!(containerItem instanceof class_5537)) break block3;
                class_9276 bundleContents = (class_9276)containerStack.method_57824(class_9334.field_49650);
                if (bundleContents == null) break block4;
                for (class_1799 bundleItem : bundleContents.method_59708()) {
                    if (bundleItem.method_7960()) continue;
                    data.setItemState(bundleItem.method_7909(), true);
                    currentItemCounts.merge(bundleItem.method_7909(), bundleItem.method_7947(), Integer::sum);
                }
                break block4;
            }
            if (containerItem instanceof class_1747 && ((class_1747)containerItem).method_7711() instanceof class_2480 && (containerComponent = (class_9288)containerStack.method_57824(class_9334.field_49622)) != null) {
                for (class_1799 shulkerItem : containerComponent.method_59714()) {
                    if (shulkerItem.method_7960()) continue;
                    data.setItemState(shulkerItem.method_7909(), true);
                    currentItemCounts.merge(shulkerItem.method_7909(), shulkerItem.method_7947(), Integer::sum);
                }
            }
        }
    }

    public static class PlayerData {
        private final Map<class_1792, Boolean> itemStates = new HashMap<class_1792, Boolean>();
        private final Map<class_1792, Integer> itemCounts = new HashMap<class_1792, Integer>();
        private List<Pokemon> partyPokemon = new ArrayList<Pokemon>();

        public void clearTrackedData() {
            this.itemStates.clear();
            this.itemCounts.clear();
            this.partyPokemon.clear();
        }

        public void setItemState(class_1792 item, boolean hasItem) {
            if (hasItem) {
                this.itemStates.put(item, true);
            }
        }

        public boolean hasItem(class_1792 item) {
            return this.itemStates.getOrDefault(item, false);
        }

        public void setItemCount(class_1792 item, int count) {
            if (count <= 0) {
                this.itemCounts.remove(item);
                this.itemStates.remove(item);
            } else {
                this.itemCounts.put(item, count);
                this.itemStates.put(item, true);
            }
        }

        public int getItemCount(class_1792 item) {
            return this.itemCounts.getOrDefault(item, 0);
        }

        public String getFormattedItemsWithCounts() {
            if (this.itemCounts.isEmpty()) {
                return "";
            }
            StringBuilder itemsWithCounts = new StringBuilder();
            ArrayList<class_1792> sortedItems = new ArrayList<class_1792>(this.itemCounts.keySet());
            sortedItems.sort(Comparator.comparing(item -> class_7923.field_41178.method_10221(item).toString()));
            for (class_1792 item2 : sortedItems) {
                int itemCount = this.itemCounts.get(item2);
                String itemName = item2.method_7848().getString();
                if (itemName == null || itemName.isEmpty()) {
                    itemName = class_7923.field_41178.method_10221((Object)item2).method_12832();
                }
                itemsWithCounts.append(itemName).append(": ").append(itemCount).append(", ");
            }
            if (itemsWithCounts.length() > 2) {
                itemsWithCounts.setLength(itemsWithCounts.length() - 2);
            }
            return itemsWithCounts.toString();
        }

        public void setPartyPokemon(List<Pokemon> party) {
            this.partyPokemon = new ArrayList<Pokemon>(party != null ? party : Collections.emptyList());
        }

        public List<Pokemon> getPartyPokemon() {
            return Collections.unmodifiableList(this.partyPokemon);
        }

        public List<Species> getPartyPokemonSpecies() {
            return this.partyPokemon.stream().map(Pokemon::getSpecies).collect(Collectors.toList());
        }

        public boolean hasPokemonSpeciesInParty(Species speciesToCheck) {
            if (speciesToCheck == null) {
                return false;
            }
            for (Pokemon p : this.partyPokemon) {
                if (!speciesToCheck.equals(p.getSpecies())) continue;
                return true;
            }
            return false;
        }

        public boolean hasPokemonSpeciesInParty(String speciesName) {
            if (speciesName == null || speciesName.trim().isEmpty()) {
                return false;
            }
            String lowerCaseName = speciesName.trim().toLowerCase();
            for (Pokemon p : this.partyPokemon) {
                if (!p.getSpecies().getName().toLowerCase().equals(lowerCaseName)) continue;
                return true;
            }
            return false;
        }
    }
}

