/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.battle;

import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.battles.AlreadyInBattleError;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleStartError;
import com.cobblemon.mod.common.battles.BattleType;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.gitlab.srcmc.rctapi.api.RCTApi;
import com.gitlab.srcmc.rctapi.api.battle.BattleContext;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import com.gitlab.srcmc.rctapi.api.battle.BattleState;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2561;

public class BattleContextValidator {
    public ErroredBattleStart validate(ErroredBattleStart errors, BattleContext context) {
        BattleActor primaryActor;
        BattleType battleType = context.getBattleFormat().getCobblemonBattleFormat().getBattleType();
        int actorsPersSide = battleType.getActorsPerSide();
        int slotsPerActor = battleType.getSlotsPerActor();
        HashSet<UUID> actorIds = new HashSet<UUID>();
        if (context.getBattleSide1().getActors().length > 0 && !((primaryActor = context.getBattleSide1().getActors()[0]) instanceof PlayerBattleActor)) {
            errors.getParticipantErrors().get(primaryActor).add(BattleStartError.Companion.canceledByEvent(class_2561.method_43470((String)String.format("Primary actor '%s' is not a player", primaryActor.getName().getString()))));
        }
        for (List<Trainer> trainers : List.of(context.getParticipants1(), context.getParticipants2())) {
            block1: for (Trainer trainer : trainers) {
                Iterator it = RCTApi.getInstances().map(e -> (RCTApi)e.getValue()).iterator();
                while (it.hasNext()) {
                    BattleManager bm = ((RCTApi)it.next()).getBattleManager();
                    BattleState bs = bm.getStates().stream().filter(b -> b.isParticipating(trainer)).findFirst().orElse(null);
                    if (bs == null) continue;
                    BattleActor actor = bs.getBattle().getActor(trainer.getEntity().method_5667());
                    if (actor != null) {
                        errors.getParticipantErrors().get(actor).add(AlreadyInBattleError.Companion.alreadyInBattle(actor));
                        continue block1;
                    }
                    errors.getGeneralErrors().add(BattleStartError.Companion.canceledByEvent(class_2561.method_43470((String)String.format("%s is already in a battle!", trainer.getName().getComponent(new Object[0]).getString()))));
                    continue block1;
                }
            }
        }
        for (BattleSide side : List.of(context.getBattleSide1(), context.getBattleSide2())) {
            if (side.getActors().length != actorsPersSide) {
                errors.getGeneralErrors().add(BattleStartError.Companion.incorrectActorCount(actorsPersSide, side.getActors().length));
            }
            for (BattleActor actor : side.getActors()) {
                EntityBackedBattleActor entityBacked;
                if (actor instanceof EntityBackedBattleActor && (entityBacked = (EntityBackedBattleActor)actor).getEntity() != null && !entityBacked.getEntity().method_5752().contains("rctapi:dummy") && entityBacked.getEntity().method_5805()) {
                    if (!entityBacked.getEntity().method_37908().method_8477(entityBacked.getEntity().method_24515())) {
                        errors.getParticipantErrors().get(actor).add(BattleStartError.Companion.canceledByEvent(class_2561.method_43470((String)String.format("%s is too far away (not loaded)", actor.getName().getString()))));
                    }
                    if (actor.getPokemonList().size() < slotsPerActor) {
                        errors.getParticipantErrors().get(actor).add(BattleStartError.Companion.insufficientPokemon((class_1297)entityBacked.getEntity(), slotsPerActor, actor.getPokemonList().size()));
                    }
                    if (actorIds.contains(actor.getUuid())) {
                        errors.getParticipantErrors().get(actor).add(AlreadyInBattleError.Companion.alreadyInBattle(actor));
                        continue;
                    }
                    actorIds.add(actor.getUuid());
                    continue;
                }
                errors.getParticipantErrors().get(actor).add(BattleStartError.Companion.canceledByEvent(class_2561.method_43470((String)String.format("%s is not attached to an entity", actor.getName().getString()))));
            }
        }
        return errors;
    }
}

