/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.block.entity.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.andrespr.casinorocket.block.entity.ModBlockEntities;
import net.andrespr.casinorocket.data.PlayerBlackjackData;
import net.andrespr.casinorocket.games.blackjack.BlackjackGameController;
import net.andrespr.casinorocket.network.s2c.sender.BlackjackStateSender;
import net.andrespr.casinorocket.screen.custom.blackjack.BlackjackTableScreenHandler;
import net.andrespr.casinorocket.screen.opening.BlackjackTableOpenData;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BlackjackTableEntity
extends class_2586
implements ExtendedScreenHandlerFactory<BlackjackTableOpenData> {
    private UUID currentUser;
    private final Map<UUID, BlackjackGameController> controllers = new HashMap<UUID, BlackjackGameController>();

    public BlackjackTableEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.BLACKJACK_TABLE_BE, pos, state);
    }

    public boolean isInUse() {
        return this.currentUser != null;
    }

    public boolean isUsedBy(class_1657 player) {
        return this.currentUser != null && this.currentUser.equals(player.method_5667());
    }

    public boolean tryLock(class_1657 player) {
        UUID id = player.method_5667();
        if (this.currentUser == null) {
            this.currentUser = id;
            this.method_5431();
            return true;
        }
        return this.currentUser.equals(id);
    }

    public void unlock(class_1657 player) {
        if (this.currentUser != null && this.currentUser.equals(player.method_5667())) {
            this.controllers.remove(player.method_5667());
            this.currentUser = null;
            this.method_5431();
        }
    }

    public void forceUnlock() {
        if (this.currentUser != null) {
            this.controllers.remove(this.currentUser);
            this.currentUser = null;
            this.method_5431();
        }
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"gui.casinorocket.blackjack_table");
    }

    public BlackjackTableOpenData getScreenOpeningData(class_3222 player) {
        MinecraftServer server = Objects.requireNonNull(player.method_5682());
        PlayerBlackjackData storage = PlayerBlackjackData.get(server);
        UUID uuid = player.method_5667();
        long balance = storage.getBalance(uuid);
        int index = storage.getBetIndex(uuid);
        return new BlackjackTableOpenData(this.field_11867, "blackjack", balance, index);
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        long balance = 0L;
        int index = 0;
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            MinecraftServer server = Objects.requireNonNull(sp.method_5682());
            PlayerBlackjackData storage = PlayerBlackjackData.get(server);
            UUID uuid = sp.method_5667();
            balance = storage.getBalance(uuid);
            index = storage.getBetIndex(uuid);
            this.sendState(sp);
        }
        return new BlackjackTableScreenHandler(syncId, inv, this.method_11016(), "blackjack", balance, index);
    }

    public BlackjackGameController getOrCreateController(class_3222 player) {
        return this.controllers.computeIfAbsent(player.method_5667(), id -> new BlackjackGameController((UUID)id, PlayerBlackjackData.get(Objects.requireNonNull(player.method_5682()))));
    }

    public void sendState(class_3222 player) {
        MinecraftServer server = Objects.requireNonNull(player.method_5682());
        PlayerBlackjackData storage = PlayerBlackjackData.get(server);
        BlackjackGameController controller = this.getOrCreateController(player);
        BlackjackStateSender.send(player, this.method_11016(), storage, controller);
    }
}

