/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.block.entity.custom;

import java.util.Objects;
import java.util.UUID;
import net.andrespr.casinorocket.block.entity.ModBlockEntities;
import net.andrespr.casinorocket.data.PlayerSlotMachineData;
import net.andrespr.casinorocket.screen.custom.slot.SlotMachineScreenHandler;
import net.andrespr.casinorocket.screen.opening.SlotMachineOpenData;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SlotMachineEntity
extends class_2586
implements ExtendedScreenHandlerFactory<SlotMachineOpenData> {
    private UUID currentUser;

    public SlotMachineEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.SLOT_MACHINE_BE, pos, state);
    }

    public boolean isInUse() {
        return this.currentUser != null;
    }

    public boolean isUsedBy(class_1657 player) {
        return this.currentUser != null && this.currentUser.equals(player.method_5667());
    }

    public boolean tryLock(class_1657 player) {
        UUID id = player.method_5667();
        if (this.currentUser == null) {
            this.currentUser = id;
            this.method_5431();
            return true;
        }
        return this.currentUser.equals(id);
    }

    public void unlock(class_1657 player) {
        if (this.currentUser != null && this.currentUser.equals(player.method_5667())) {
            this.currentUser = null;
            this.method_5431();
        }
    }

    public void forceUnlock() {
        if (this.currentUser != null) {
            this.currentUser = null;
            this.method_5431();
        }
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"gui.casinorocket.slot_machine");
    }

    public SlotMachineOpenData getScreenOpeningData(class_3222 player) {
        MinecraftServer server = Objects.requireNonNull(player.method_5682());
        PlayerSlotMachineData storage = PlayerSlotMachineData.get(server);
        UUID uuid = player.method_5667();
        long balance = storage.getBalance(uuid);
        int betBase = storage.getBetBase(uuid);
        int lines = storage.getLinesMode(uuid);
        return new SlotMachineOpenData(this.field_11867, "slots", balance, betBase, lines);
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            MinecraftServer server = Objects.requireNonNull(sp.method_5682());
            PlayerSlotMachineData storage = PlayerSlotMachineData.get(server);
            UUID uuid = sp.method_5667();
            long balance = storage.getBalance(uuid);
            int betBase = storage.getBetBase(uuid);
            int lines = storage.getLinesMode(uuid);
            return new SlotMachineScreenHandler(syncId, inv, this.method_11016(), "slots", balance, betBase, lines);
        }
        return new SlotMachineScreenHandler(syncId, inv, this.method_11016(), "slots", 0L, 10, 1);
    }
}

