/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Objects;
import net.andrespr.casinorocket.games.gachapon.GachaMachinesUtils;
import net.andrespr.casinorocket.games.gachapon.GachaponUtils;
import net.andrespr.casinorocket.games.gachapon.PlushiesGachaponUtils;
import net.andrespr.casinorocket.games.gachapon.PokemonGachaponUtils;
import net.andrespr.casinorocket.util.CommandUtils;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class GachaponCommands {
    public static LiteralArgumentBuilder<class_2168> buildSubcommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gachapon").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rates").then(class_2170.method_9247((String)"item").then(class_2170.method_9244((String)"pool", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            GachaponUtils.getPools().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(GachaponCommands::executeRatesForItem)))).then(class_2170.method_9247((String)"pokemon").then(class_2170.method_9244((String)"pool", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            PokemonGachaponUtils.getPools().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(GachaponCommands::executeRatesForPokemon)))).then(class_2170.method_9247((String)"plushies").executes(GachaponCommands::executeRatesForPlushies))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"machine").then(class_2170.method_9247((String)"base").then(class_2170.method_9244((String)"coin", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            GachaMachinesUtils.getCoinKeys().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> GachaponCommands.executeRatesForMachine((CommandContext<class_2168>)ctx, false))))).then(class_2170.method_9247((String)"pity").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils::suggestPlayerNames).then(class_2170.method_9244((String)"coin", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            GachaMachinesUtils.getCoinKeys().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> GachaponCommands.executeRatesForMachine((CommandContext<class_2168>)ctx, true)))))))).then(class_2170.method_9247((String)"stats").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils::suggestPlayerNames).executes(GachaponCommands::executeForMachineStats)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"leaderboard").then(class_2170.method_9247((String)"rarity").then(class_2170.method_9244((String)"rarity", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            GachaMachinesUtils.getRarityKeys().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> GachaponCommands.executeForLeaderboard((CommandContext<class_2168>)ctx, "rarity"))))).then(class_2170.method_9247((String)"coins").then(class_2170.method_9244((String)"coin", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            GachaMachinesUtils.getCoinKeys().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> GachaponCommands.executeForLeaderboard((CommandContext<class_2168>)ctx, "coins")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cleandata").requires(source -> source.method_9259(2))).executes(GachaponCommands::executeCleanData)).then(class_2170.method_9247((String)"confirm").executes(GachaponCommands::confirmCleanData)));
    }

    private static int executeRatesForItem(CommandContext<class_2168> context) {
        String poolKey = StringArgumentType.getString(context, (String)"pool");
        class_3222 player = GachaponCommands.getPlayer(context);
        if (player == null) {
            return 0;
        }
        player.method_7353(GachaponUtils.getPoolPercentages(poolKey), false);
        return 1;
    }

    private static int executeRatesForPokemon(CommandContext<class_2168> context) {
        String poolKey = StringArgumentType.getString(context, (String)"pool");
        class_3222 player = GachaponCommands.getPlayer(context);
        if (player == null) {
            return 0;
        }
        player.method_7353(PokemonGachaponUtils.getPoolPercentages(poolKey), false);
        return 1;
    }

    private static int executeRatesForMachine(CommandContext<class_2168> context, boolean includePity) {
        String coinKey;
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3222 sender = GachaponCommands.getPlayer(context);
        if (sender == null) {
            return 0;
        }
        class_3222 target = null;
        if (includePity) {
            String name = StringArgumentType.getString(context, (String)"player");
            coinKey = StringArgumentType.getString(context, (String)"coin");
            target = server.method_3760().method_14566(name);
            if (target == null) {
                sender.method_7353((class_2561)class_2561.method_43470((String)("Player '" + name + "' is not online.")).method_27692(class_124.field_1061), false);
                return 0;
            }
        } else {
            coinKey = StringArgumentType.getString(context, (String)"coin");
        }
        class_2561 msg = GachaMachinesUtils.getMachineRatesText(target, coinKey, includePity);
        sender.method_7353(msg, false);
        return 1;
    }

    private static int executeForMachineStats(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3222 sender = GachaponCommands.getPlayer(context);
        if (sender == null) {
            return 0;
        }
        class_3222 target = server.method_3760().method_14566(name);
        class_2561 statsText = target != null ? GachaMachinesUtils.getPlayerStatsText(target, server) : GachaMachinesUtils.getPlayerStatsText(name, server);
        sender.method_7353(statsText, false);
        return 1;
    }

    private static int executeForLeaderboard(CommandContext<class_2168> context, String category) {
        String key = StringArgumentType.getString(context, (String)(category.equals("rarity") ? "rarity" : "coin"));
        class_3222 sender = GachaponCommands.getPlayer(context);
        if (sender == null) {
            return 0;
        }
        sender.method_7353(GachaMachinesUtils.getLeaderboardText(((class_2168)context.getSource()).method_9211(), category, key), false);
        return 1;
    }

    private static int executeCleanData(CommandContext<class_2168> context) {
        class_3222 sender = GachaponCommands.getPlayer(context);
        if (sender == null) {
            return 0;
        }
        class_2561 response = GachaMachinesUtils.clearAllGachaData(Objects.requireNonNull(sender.method_5682()), false, sender);
        sender.method_7353(response, false);
        return 1;
    }

    private static int confirmCleanData(CommandContext<class_2168> context) {
        class_3222 sender = GachaponCommands.getPlayer(context);
        if (sender == null) {
            return 0;
        }
        class_2561 response = GachaMachinesUtils.clearAllGachaData(Objects.requireNonNull(sender.method_5682()), true, sender);
        sender.method_7353(response, false);
        return 1;
    }

    private static int executeRatesForPlushies(CommandContext<class_2168> context) {
        class_3222 player = GachaponCommands.getPlayer(context);
        if (player == null) {
            return 0;
        }
        player.method_7353(PlushiesGachaponUtils.getRates(), false);
        return 1;
    }

    @Nullable
    private static class_3222 getPlayer(CommandContext<class_2168> context) {
        try {
            return ((class_2168)context.getSource()).method_44023();
        }
        catch (Exception e) {
            return null;
        }
    }
}

