/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.TreeMap;
import net.andrespr.casinorocket.CasinoRocket;
import net.andrespr.casinorocket.network.SuitSync;
import net.andrespr.casinorocket.util.IdleYawData;
import net.andrespr.casinorocket.util.LookPlayerData;
import net.andrespr.casinorocket.util.SuitData;
import net.andrespr.casinorocket.villager.ShopsRegistry;
import net.andrespr.casinorocket.villager.VillagerNbtFactory;
import net.andrespr.casinorocket.villager.VillagerTradeHelper;
import net.andrespr.casinorocket.villager.shops.IShop;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_7923;

public final class VillagerCommands {
    private static final Map<String, IShop> SHOP_TYPES = ShopsRegistry.all();
    private static final Map<String, Integer> SUIT_NAMES = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);

    private VillagerCommands() {
    }

    public static LiteralArgumentBuilder<class_2168> buildSubcommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"villager").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"spawn").then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> {
            for (String k : SHOP_TYPES.keySet()) {
                builder.suggest(k);
            }
            return builder.buildFuture();
        }).executes(ctx -> VillagerCommands.executeSpawn(StringArgumentType.getString((CommandContext)ctx, (String)"type"), (class_2168)ctx.getSource()))))).then(class_2170.method_9247((String)"setsuit").then(class_2170.method_9244((String)"suit", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> {
            SUIT_NAMES.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> VillagerCommands.executeSetSuit((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"suit")))))).then(class_2170.method_9247((String)"setai").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> VillagerCommands.executeSetAi((class_2168)ctx.getSource(), BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))))).then(class_2170.method_9247((String)"lookplayer").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> VillagerCommands.executeLookPlayer((class_2168)ctx.getSource(), BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))))).then(class_2170.method_9247((String)"lookdirection").then(class_2170.method_9244((String)"dir", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> {
            b.suggest("north");
            b.suggest("south");
            b.suggest("east");
            b.suggest("west");
            return b.buildFuture();
        }).executes(ctx -> VillagerCommands.executeLookDirection((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"dir")))));
    }

    private static int executeSpawn(String type, class_2168 source) {
        boolean spawned;
        class_1646 villager;
        IShop shop = SHOP_TYPES.get(type);
        if (shop == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown casino worker type: " + type)));
            return 0;
        }
        class_3218 world = source.method_9225();
        class_2338 blockPos = class_2338.method_49638((class_2374)source.method_9222());
        class_2338 villagerPos = blockPos.method_10078();
        VillagerTradeHelper.ShopData data = shop.build();
        String blockId = data.jobBlockId != null ? data.jobBlockId : "cobblemon:display_case";
        class_2248 jobBlock = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockId));
        world.method_8501(blockPos, jobBlock.method_9564());
        String formattedType = ShopsRegistry.all().keySet().stream().filter(k -> k.equalsIgnoreCase(type)).findFirst().orElse(type);
        class_2487 root = VillagerNbtFactory.createBaseVillagerNbt(formattedType, blockPos, data.profession, data.suitId);
        if (data.shops != null && !data.shops.isEmpty()) {
            root.method_10566("CobbleMerchantShop", (class_2520)data.shops);
        }
        if (data.offersNbt != null && data.offersNbt.method_10545("Recipes")) {
            root.method_10566("Offers", (class_2520)data.offersNbt);
        }
        try {
            villager = (class_1646)class_1299.field_6077.method_5883((class_1937)world);
            if (villager == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Failed to create villager entity."));
                return 0;
            }
            villager.method_5651(root);
        }
        catch (Exception e) {
            CasinoRocket.LOGGER.error("Error creating villager from NBT", (Throwable)e);
            source.method_9213((class_2561)class_2561.method_43470((String)("Error creating villager from NBT: " + e.getMessage())));
            return 0;
        }
        class_3222 player = source.method_44023();
        float yaw = player != null ? player.method_36454() : 0.0f;
        villager.method_5808((double)villagerPos.method_10263() + 0.5, (double)villagerPos.method_10264(), (double)villagerPos.method_10260() + 0.5, yaw, 0.0f);
        try {
            spawned = world.method_8649((class_1297)villager);
        }
        catch (Exception e) {
            CasinoRocket.LOGGER.error("Exception when spawning entity", (Throwable)e);
            source.method_9213((class_2561)class_2561.method_43470((String)("Exception when spawning entity: " + e.getMessage())));
            return 0;
        }
        if (!spawned) {
            source.method_9213((class_2561)class_2561.method_43470((String)"The entity couldn't be spawned in the world."));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7a\u00a1" + type + " spawned correctly!")), false);
        return 1;
    }

    private static int executeSetSuit(class_2168 source, String suitName) {
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by a player."));
            return 0;
        }
        Integer suitValue = SUIT_NAMES.get(suitName);
        if (suitValue == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown suit name: " + suitName)));
            return 0;
        }
        class_1646 villager = VillagerCommands.getLookedVillager(source);
        if (villager == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be looking at a Villager!"));
            return 0;
        }
        int current = SuitData.getSuit(villager);
        if (current == suitValue) {
            source.method_9226(() -> class_2561.method_43470((String)("Suit already set to " + suitName)), false);
            return 1;
        }
        SuitData.setSuitServer(villager, suitValue);
        SuitSync.sendSuitSync(villager, suitValue);
        source.method_9226(() -> class_2561.method_43470((String)(suitName + " set to " + villager.method_5477().getString())), true);
        return 1;
    }

    private static int executeSetAi(class_2168 source, boolean enabled) {
        class_1646 villager = VillagerCommands.getLookedVillager(source);
        if (villager == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be looking at a Villager!"));
            return 0;
        }
        villager.method_5977(!enabled);
        source.method_9226(() -> class_2561.method_43470((String)("AI set to " + enabled + " for " + villager.method_5477().getString())), true);
        return 1;
    }

    private static int executeLookPlayer(class_2168 source, boolean enabled) {
        class_1646 villager = VillagerCommands.getLookedVillager(source);
        if (villager == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be looking at a Villager!"));
            return 0;
        }
        LookPlayerData.setLookPlayer(villager, enabled ? 1 : 0);
        source.method_9226(() -> class_2561.method_43470((String)("LookPlayer set to " + enabled + " for " + villager.method_5477().getString())), true);
        return 1;
    }

    private static int executeLookDirection(class_2168 source, String dir) {
        class_1646 villager = VillagerCommands.getLookedVillager(source);
        if (villager == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be looking at a Villager!"));
            return 0;
        }
        Float yaw = VillagerCommands.directionToYaw(dir);
        if (yaw == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Invalid direction: " + dir)));
            return 0;
        }
        IdleYawData.set(villager, yaw.floatValue());
        villager.method_36456(yaw.floatValue());
        villager.field_6283 = yaw.floatValue();
        villager.field_6241 = yaw.floatValue();
        villager.method_36457(0.0f);
        villager.field_5982 = yaw.floatValue();
        villager.field_6220 = yaw.floatValue();
        villager.field_6259 = yaw.floatValue();
        villager.field_6004 = 0.0f;
        source.method_9226(() -> class_2561.method_43470((String)("Idle direction set to " + dir + " for " + villager.method_5477().getString())), true);
        return 1;
    }

    private static Float directionToYaw(String dir) {
        return switch (dir.toLowerCase()) {
            case "south" -> Float.valueOf(0.0f);
            case "west" -> Float.valueOf(90.0f);
            case "north" -> Float.valueOf(180.0f);
            case "east" -> Float.valueOf(-90.0f);
            default -> null;
        };
    }

    public static class_1646 getLookedVillager(class_2168 source) {
        try {
            class_1646 v;
            class_238 box;
            class_243 lookVec;
            class_243 endVec;
            class_3222 player = source.method_44023();
            if (player == null) {
                return null;
            }
            class_1937 world = player.method_37908();
            double reachDistance = 10.0;
            class_243 eyePos = player.method_5836(1.0f);
            class_3966 hit = class_1675.method_18077((class_1937)world, (class_1297)player, (class_243)eyePos, (class_243)(endVec = eyePos.method_1019((lookVec = player.method_5828(1.0f)).method_1021(reachDistance))), (class_238)(box = player.method_5829().method_18804(lookVec.method_1021(reachDistance)).method_1014(1.0)), entity -> entity instanceof class_1646 && entity.method_5805());
            class_1297 e = hit != null ? hit.method_17782() : null;
            return e instanceof class_1646 ? (v = (class_1646)e) : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        SUIT_NAMES.put("None", 0);
        SUIT_NAMES.put("Black Tuxedo", 1);
        SUIT_NAMES.put("White Tuxedo", 2);
        SUIT_NAMES.put("Gold Tuxedo", 3);
    }
}

