/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="gacha_machines")
public class GachaMachinesConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public RarityBaseWeights rarity_base_weights = new RarityBaseWeights();
    @ConfigEntry.Gui.CollapsibleObject
    public CoinMultipliers coin_multipliers = new CoinMultipliers();
    @ConfigEntry.Gui.CollapsibleObject
    public PityConfig pity = new PityConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public PremierBonus premier_bonus = new PremierBonus();
    @ConfigEntry.Gui.CollapsibleObject
    public GachaStore gacha_store = new GachaStore();

    public Map<String, Double> baseWeightsMap() {
        LinkedHashMap<String, Double> m = new LinkedHashMap<String, Double>();
        m.put("common", this.rarity_base_weights.common);
        m.put("uncommon", this.rarity_base_weights.uncommon);
        m.put("rare", this.rarity_base_weights.rare);
        m.put("ultrarare", this.rarity_base_weights.ultrarare);
        m.put("legendary", this.rarity_base_weights.legendary);
        return m;
    }

    public Coin coin(String coinKey) {
        return switch (coinKey = coinKey.toLowerCase(Locale.ROOT)) {
            case "iron" -> this.coin_multipliers.iron;
            case "gold" -> this.coin_multipliers.gold;
            case "diamond" -> this.coin_multipliers.diamond;
            default -> this.coin_multipliers.copper;
        };
    }

    public Map<String, Double> normalizedProbabilities(String coinKey) {
        Map<String, Double> base = this.baseWeightsMap();
        Map<String, Double> mult = this.coin(coinKey).toMap();
        double sum = 0.0;
        LinkedHashMap<String, Double> weighted = new LinkedHashMap<String, Double>();
        for (Map.Entry<String, Double> e : base.entrySet()) {
            double v = e.getValue() * mult.get(e.getKey());
            weighted.put(e.getKey(), v);
            sum += v;
        }
        if (sum <= 0.0) {
            return Collections.emptyMap();
        }
        for (String k : weighted.keySet()) {
            weighted.put(k, (Double)weighted.get(k) / sum);
        }
        return weighted;
    }

    public String getCoinPrice(String coinId) {
        int coinValue = switch (coinId = coinId.toLowerCase(Locale.ROOT)) {
            case "casinorocket:copper_coin" -> this.gacha_store.coin_prices.copper;
            case "casinorocket:iron_coin" -> this.gacha_store.coin_prices.iron;
            case "casinorocket:gold_coin" -> this.gacha_store.coin_prices.gold;
            case "casinorocket:diamond_coin" -> this.gacha_store.coin_prices.diamond;
            case "casinorocket:event_coin" -> this.gacha_store.coin_prices.event;
            case "casinorocket:primogem" -> this.gacha_store.coin_prices.primogem;
            default -> 1000;
        };
        return String.valueOf(coinValue);
    }

    public String getGachaponPrice(String gachaponId) {
        int gachaponValue = switch (gachaponId = gachaponId.toLowerCase(Locale.ROOT)) {
            case "casinorocket:poke_gachapon" -> this.gacha_store.gachapon_store.item_poke_gachapon.price;
            case "casinorocket:great_gachapon" -> this.gacha_store.gachapon_store.item_great_gachapon.price;
            case "casinorocket:ultra_gachapon" -> this.gacha_store.gachapon_store.item_ultra_gachapon.price;
            case "casinorocket:master_gachapon" -> this.gacha_store.gachapon_store.item_master_gachapon.price;
            case "casinorocket:cherish_gachapon" -> this.gacha_store.gachapon_store.item_cherish_gachapon.price;
            case "casinorocket:premier_gachapon" -> this.gacha_store.gachapon_store.item_premier_gachapon.price;
            case "casinorocket:pokemon_poke_gachapon" -> this.gacha_store.gachapon_store.pokemon_poke_gachapon.price;
            case "casinorocket:pokemon_great_gachapon" -> this.gacha_store.gachapon_store.pokemon_great_gachapon.price;
            case "casinorocket:pokemon_ultra_gachapon" -> this.gacha_store.gachapon_store.pokemon_ultra_gachapon.price;
            case "casinorocket:pokemon_master_gachapon" -> this.gacha_store.gachapon_store.pokemon_master_gachapon.price;
            case "casinorocket:pokemon_cherish_gachapon" -> this.gacha_store.gachapon_store.pokemon_cherish_gachapon.price;
            case "casinorocket:pokemon_premier_gachapon" -> this.gacha_store.gachapon_store.pokemon_premier_gachapon.price;
            default -> 10000;
        };
        return String.valueOf(gachaponValue);
    }

    public boolean getGachaponEnable(String gachaponId) {
        return switch (gachaponId = gachaponId.toLowerCase(Locale.ROOT)) {
            case "casinorocket:poke_gachapon" -> this.gacha_store.gachapon_store.item_poke_gachapon.enableToBuy;
            case "casinorocket:great_gachapon" -> this.gacha_store.gachapon_store.item_great_gachapon.enableToBuy;
            case "casinorocket:ultra_gachapon" -> this.gacha_store.gachapon_store.item_ultra_gachapon.enableToBuy;
            case "casinorocket:master_gachapon" -> this.gacha_store.gachapon_store.item_master_gachapon.enableToBuy;
            case "casinorocket:cherish_gachapon" -> this.gacha_store.gachapon_store.item_cherish_gachapon.enableToBuy;
            case "casinorocket:premier_gachapon" -> this.gacha_store.gachapon_store.item_premier_gachapon.enableToBuy;
            case "casinorocket:pokemon_poke_gachapon" -> this.gacha_store.gachapon_store.pokemon_poke_gachapon.enableToBuy;
            case "casinorocket:pokemon_great_gachapon" -> this.gacha_store.gachapon_store.pokemon_great_gachapon.enableToBuy;
            case "casinorocket:pokemon_ultra_gachapon" -> this.gacha_store.gachapon_store.pokemon_ultra_gachapon.enableToBuy;
            case "casinorocket:pokemon_master_gachapon" -> this.gacha_store.gachapon_store.pokemon_master_gachapon.enableToBuy;
            case "casinorocket:pokemon_cherish_gachapon" -> this.gacha_store.gachapon_store.pokemon_cherish_gachapon.enableToBuy;
            case "casinorocket:pokemon_premier_gachapon" -> this.gacha_store.gachapon_store.pokemon_premier_gachapon.enableToBuy;
            default -> false;
        };
    }

    public static class RarityBaseWeights
    implements ConfigData {
        public double common = 60.0;
        public double uncommon = 25.0;
        public double rare = 10.0;
        public double ultrarare = 4.0;
        public double legendary = 1.0;
    }

    public static class CoinMultipliers
    implements ConfigData {
        @ConfigEntry.Gui.CollapsibleObject
        public Coin copper = new Coin(1.0, 1.0, 1.0, 1.0, 0.1);
        @ConfigEntry.Gui.CollapsibleObject
        public Coin iron = new Coin(0.85, 1.1, 1.4, 1.6, 0.5);
        @ConfigEntry.Gui.CollapsibleObject
        public Coin gold = new Coin(0.55, 1.2, 2.1, 2.5, 0.95);
        @ConfigEntry.Gui.CollapsibleObject
        public Coin diamond = new Coin(0.32, 1.1, 3.0, 3.2, 2.3);
    }

    public static class PityConfig
    implements ConfigData {
        public boolean enable = true;
        public boolean pityUpdateMessages = true;
        @ConfigEntry.Gui.CollapsibleObject
        public CoinPity iron = new CoinPity(0, 0.0);
        @ConfigEntry.Gui.CollapsibleObject
        public CoinPity gold = new CoinPity(80, 0.25);
        @ConfigEntry.Gui.CollapsibleObject
        public CoinPity diamond = new CoinPity(25, 0.25);

        public static class CoinPity
        implements ConfigData {
            public int usesToMax;
            public double maxLegendaryChance;

            public CoinPity() {
            }

            public CoinPity(int usesToMax, double maxLegendaryChance) {
                this.usesToMax = usesToMax;
                this.maxLegendaryChance = maxLegendaryChance;
            }
        }
    }

    public static class PremierBonus
    implements ConfigData {
        public boolean enable = true;
        public int coinsToBonus = 10;
    }

    public static class GachaStore
    implements ConfigData {
        @ConfigEntry.Gui.CollapsibleObject
        public CoinPrices coin_prices = new CoinPrices(1000, 10000, 100000, 500000, 50000, 50000);
        @ConfigEntry.Gui.CollapsibleObject
        public GachaponStoreConfig gachapon_store = new GachaponStoreConfig();

        public static class CoinPrices
        implements ConfigData {
            public int copper;
            public int iron;
            public int gold;
            public int diamond;
            public int event;
            public int primogem;

            public CoinPrices() {
            }

            public CoinPrices(int copper, int iron, int gold, int diamond, int event, int primogem) {
                this.copper = copper;
                this.iron = iron;
                this.gold = gold;
                this.diamond = diamond;
                this.event = event;
                this.primogem = primogem;
            }
        }

        public static class GachaponStoreConfig
        implements ConfigData {
            @ConfigEntry.Gui.CollapsibleObject
            public boolean enableItemGachaponStore = true;
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon item_poke_gachapon = new Gachapon(true, 5000);
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon item_great_gachapon = new Gachapon(true, 50000);
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon item_ultra_gachapon = new Gachapon(true, 500000);
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon item_master_gachapon = new Gachapon(false, 2500000);
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon item_cherish_gachapon = new Gachapon(false, 10000000);
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon item_premier_gachapon = new Gachapon(false, 10000);
            @ConfigEntry.Gui.CollapsibleObject
            public boolean enablePokemonGachaponStore = true;
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon pokemon_poke_gachapon = new Gachapon(true, 5000);
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon pokemon_great_gachapon = new Gachapon(true, 50000);
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon pokemon_ultra_gachapon = new Gachapon(true, 500000);
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon pokemon_master_gachapon = new Gachapon(false, 2500000);
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon pokemon_cherish_gachapon = new Gachapon(false, 10000000);
            @ConfigEntry.Gui.CollapsibleObject
            public Gachapon pokemon_premier_gachapon = new Gachapon(false, 10000);
        }
    }

    public static class Coin
    implements ConfigData {
        public double common;
        public double uncommon;
        public double rare;
        public double ultrarare;
        public double legendary;

        public Coin() {
        }

        public Coin(double common, double uncommon, double rare, double ultrarare, double legendary) {
            this.common = common;
            this.uncommon = uncommon;
            this.rare = rare;
            this.ultrarare = ultrarare;
            this.legendary = legendary;
        }

        public Map<String, Double> toMap() {
            LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
            map.put("common", this.common);
            map.put("uncommon", this.uncommon);
            map.put("rare", this.rare);
            map.put("ultrarare", this.ultrarare);
            map.put("legendary", this.legendary);
            return map;
        }
    }

    public static class Gachapon
    implements ConfigData {
        public boolean enableToBuy;
        public int price;

        public Gachapon() {
        }

        public Gachapon(boolean enableToBuy, int price) {
            this.enableToBuy = enableToBuy;
            this.price = price;
        }
    }
}

