/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.config;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.andrespr.casinorocket.games.slot.SlotSymbol;

@Config(name="slot_machine")
public class SlotMachineConfig
implements ConfigData {
    public List<Integer> betValues = new ArrayList<Integer>(List.of(10, 25, 50, 100, 250, 500, 1000, 5000, 10000, 25000, 50000, 100000, 250000, 500000, 1000000, 5000000));
    @ConfigEntry.Gui.CollapsibleObject
    public BetMultipliers betMultipliers = new BetMultipliers(1, 3, 5);
    @ConfigEntry.Gui.CollapsibleObject
    public Reels reels = Reels.defaultReels();

    public int defaultBetBase() {
        return this.betValues.isEmpty() ? 10 : this.betValues.getFirst();
    }

    public int getBetMultiplierForMode(int mode) {
        return switch (mode) {
            case 2 -> this.betMultipliers.mode2;
            case 3 -> this.betMultipliers.mode3;
            default -> this.betMultipliers.mode1;
        };
    }

    public void validatePostLoad() {
        if (this.betValues == null) {
            this.betValues = new ArrayList<Integer>();
        }
        this.betValues = this.betValues.stream().filter(v -> v != null && v > 0).distinct().sorted().toList().stream().collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        if (this.betValues.isEmpty()) {
            this.betValues.add(10);
        }
        if (this.betMultipliers == null) {
            this.betMultipliers = new BetMultipliers(1, 3, 5);
        }
        this.betMultipliers.mode1 = Math.max(1, this.betMultipliers.mode1);
        this.betMultipliers.mode2 = Math.max(1, this.betMultipliers.mode2);
        this.betMultipliers.mode3 = Math.max(1, this.betMultipliers.mode3);
        if (this.reels == null) {
            this.reels = Reels.defaultReels();
        }
        this.reels.reelSize = SlotMachineConfig.clamp(this.reels.reelSize, 16, 4096);
        SlotMachineConfig.sanitizeStrip(this.reels.reel1);
        SlotMachineConfig.sanitizeStrip(this.reels.reel2);
        SlotMachineConfig.sanitizeStrip(this.reels.reel3);
    }

    private static int clamp(int v, int min, int max) {
        return Math.max(min, Math.min(max, v));
    }

    private static void sanitizeStrip(ReelStrip strip) {
        if (strip == null) {
            return;
        }
        if (strip.counts == null) {
            strip.counts = new EnumMap<SlotSymbol, Integer>(SlotSymbol.class);
        }
        if (strip.fillSymbol == null) {
            strip.fillSymbol = SlotSymbol.HAUNTER;
        }
        strip.counts.replaceAll((k, val) -> val == null ? 0 : Math.max(0, val));
    }

    public static class BetMultipliers
    implements ConfigData {
        public int mode1;
        public int mode2;
        public int mode3;

        public BetMultipliers() {
        }

        public BetMultipliers(int mode1, int mode2, int mode3) {
            this.mode1 = mode1;
            this.mode2 = mode2;
            this.mode3 = mode3;
        }
    }

    public static class Reels
    implements ConfigData {
        public int reelSize = 256;
        @ConfigEntry.Gui.CollapsibleObject
        public ReelStrip reel1 = ReelStrip.defaultReel1();
        @ConfigEntry.Gui.CollapsibleObject
        public ReelStrip reel2 = ReelStrip.defaultReel2();
        @ConfigEntry.Gui.CollapsibleObject
        public ReelStrip reel3 = ReelStrip.defaultReel3();

        public static Reels defaultReels() {
            return new Reels();
        }
    }

    public static class ReelStrip
    implements ConfigData {
        public Map<SlotSymbol, Integer> counts = new EnumMap<SlotSymbol, Integer>(SlotSymbol.class);
        public SlotSymbol fillSymbol = SlotSymbol.HAUNTER;

        public static ReelStrip defaultCommonBase() {
            ReelStrip r = new ReelStrip();
            r.counts.put(SlotSymbol.SEVEN, 6);
            r.counts.put(SlotSymbol.ROCKET, 10);
            r.counts.put(SlotSymbol.MEW, 16);
            r.counts.put(SlotSymbol.PIKACHU, 22);
            r.counts.put(SlotSymbol.CHARMANDER, 32);
            r.counts.put(SlotSymbol.SQUIRTLE, 38);
            r.counts.put(SlotSymbol.BULBASAUR, 46);
            return r;
        }

        public static ReelStrip defaultReel1() {
            ReelStrip r = ReelStrip.defaultCommonBase();
            r.counts.put(SlotSymbol.CHERRY, 64);
            return r;
        }

        public static ReelStrip defaultReel2() {
            ReelStrip r = ReelStrip.defaultCommonBase();
            r.counts.put(SlotSymbol.CHERRY, 76);
            return r;
        }

        public static ReelStrip defaultReel3() {
            ReelStrip r = ReelStrip.defaultCommonBase();
            r.counts.put(SlotSymbol.CHERRY, 76);
            return r;
        }
    }
}

