/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.andrespr.casinorocket.data.GachaStats;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class GachaDataStorage
extends class_18 {
    public Map<UUID, Map<String, Integer>> pityTracker = new HashMap<UUID, Map<String, Integer>>();
    public Map<UUID, GachaStats> playerStats = new HashMap<UUID, GachaStats>();
    private static final String STORAGE_KEY = "casinorocket_gacha_data";

    public static GachaDataStorage get(MinecraftServer server) {
        class_26 manager = Objects.requireNonNull(server.method_3847(class_1937.field_25179)).method_17983();
        class_18.class_8645 type = new class_18.class_8645(GachaDataStorage::new, GachaDataStorage::readNbt, null);
        return (GachaDataStorage)manager.method_17924(type, STORAGE_KEY);
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2487 pityTag = new class_2487();
        for (Map.Entry<UUID, Map<String, Integer>> entry : this.pityTracker.entrySet()) {
            UUID uuid = entry.getKey();
            class_2487 coinMap = new class_2487();
            for (Map.Entry<String, Integer> coinEntry : entry.getValue().entrySet()) {
                coinMap.method_10569(coinEntry.getKey(), coinEntry.getValue().intValue());
            }
            pityTag.method_10566(uuid.toString(), (class_2520)coinMap);
        }
        nbt.method_10566("PityTracker", (class_2520)pityTag);
        class_2487 statsTag = new class_2487();
        for (Map.Entry<UUID, GachaStats> entry : this.playerStats.entrySet()) {
            statsTag.method_10566(entry.getKey().toString(), (class_2520)entry.getValue().toNbt());
        }
        nbt.method_10566("PlayerStats", (class_2520)statsTag);
        return nbt;
    }

    private static GachaDataStorage readNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        UUID uuid2;
        GachaDataStorage data = new GachaDataStorage();
        if (nbt.method_10573("PityTracker", 10)) {
            class_2487 pityTag = nbt.method_10562("PityTracker");
            for (String uuidStr : pityTag.method_10541()) {
                try {
                    uuid2 = UUID.fromString(uuidStr);
                    class_2487 coinTag = pityTag.method_10562(uuidStr);
                    HashMap<String, Integer> coinMap = new HashMap<String, Integer>();
                    for (String coin : coinTag.method_10541()) {
                        coinMap.put(coin, coinTag.method_10550(coin));
                    }
                    data.pityTracker.put(uuid2, coinMap);
                }
                catch (Exception uuid2) {}
            }
        }
        if (nbt.method_10573("PlayerStats", 10)) {
            class_2487 statsTag = nbt.method_10562("PlayerStats");
            for (String uuidStr : statsTag.method_10541()) {
                try {
                    uuid2 = UUID.fromString(uuidStr);
                    data.playerStats.put(uuid2, GachaStats.fromNbt(statsTag.method_10562(uuidStr)));
                }
                catch (Exception exception) {}
            }
        }
        return data;
    }

    public boolean method_79() {
        return true;
    }
}

