/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.data;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2487;

public class GachaStats {
    private String playerName;
    public int totalCoinsUsed = 0;
    public int copperUsed = 0;
    public int ironUsed = 0;
    public int goldUsed = 0;
    public int diamondUsed = 0;
    public int common = 0;
    public int uncommon = 0;
    public int rare = 0;
    public int ultrarare = 0;
    public int legendary = 0;
    public int bonus = 0;

    public GachaStats(String playerName) {
        this.playerName = playerName;
    }

    public void recordUse(String coinKey, String rarity) {
        ++this.totalCoinsUsed;
        switch (coinKey.toLowerCase()) {
            case "copper": {
                ++this.copperUsed;
                break;
            }
            case "iron": {
                ++this.ironUsed;
                break;
            }
            case "gold": {
                ++this.goldUsed;
                break;
            }
            case "diamond": {
                ++this.diamondUsed;
            }
        }
        switch (rarity.toLowerCase()) {
            case "common": {
                ++this.common;
                break;
            }
            case "uncommon": {
                ++this.uncommon;
                break;
            }
            case "rare": {
                ++this.rare;
                break;
            }
            case "ultrarare": {
                ++this.ultrarare;
                break;
            }
            case "legendary": {
                ++this.legendary;
                break;
            }
            case "bonus": {
                ++this.bonus;
            }
        }
    }

    public void recordBonus() {
        ++this.bonus;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("playerName", this.playerName);
        nbt.method_10569("totalCoinsUsed", this.totalCoinsUsed);
        nbt.method_10569("copperUsed", this.copperUsed);
        nbt.method_10569("ironUsed", this.ironUsed);
        nbt.method_10569("goldUsed", this.goldUsed);
        nbt.method_10569("diamondUsed", this.diamondUsed);
        nbt.method_10569("common", this.common);
        nbt.method_10569("uncommon", this.uncommon);
        nbt.method_10569("rare", this.rare);
        nbt.method_10569("ultrarare", this.ultrarare);
        nbt.method_10569("legendary", this.legendary);
        nbt.method_10569("bonus", this.bonus);
        return nbt;
    }

    public static GachaStats fromNbt(class_2487 nbt) {
        String name = nbt.method_10558("playerName");
        GachaStats stats = new GachaStats(name);
        stats.totalCoinsUsed = nbt.method_10550("totalCoinsUsed");
        stats.copperUsed = nbt.method_10550("copperUsed");
        stats.ironUsed = nbt.method_10550("ironUsed");
        stats.goldUsed = nbt.method_10550("goldUsed");
        stats.diamondUsed = nbt.method_10550("diamondUsed");
        stats.common = nbt.method_10550("common");
        stats.uncommon = nbt.method_10550("uncommon");
        stats.rare = nbt.method_10550("rare");
        stats.ultrarare = nbt.method_10550("ultrarare");
        stats.legendary = nbt.method_10550("legendary");
        stats.bonus = nbt.method_10550("bonus");
        return stats;
    }

    public int getTotalCoinsUsed() {
        return this.totalCoinsUsed;
    }

    public int getRarityCount(String rarity) {
        return switch (rarity.toLowerCase(Locale.ROOT)) {
            case "common" -> this.common;
            case "uncommon" -> this.uncommon;
            case "rare" -> this.rare;
            case "ultrarare" -> this.ultrarare;
            case "legendary" -> this.legendary;
            case "bonus" -> this.bonus;
            default -> 0;
        };
    }

    public Map<String, Integer> getRarityCounts() {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        m.put("common", this.common);
        m.put("uncommon", this.uncommon);
        m.put("rare", this.rare);
        m.put("ultrarare", this.ultrarare);
        m.put("legendary", this.legendary);
        m.put("bonus", this.bonus);
        return m;
    }

    public int getCoinCount(String coinKey) {
        return switch (coinKey.toLowerCase(Locale.ROOT)) {
            case "copper" -> this.copperUsed;
            case "iron" -> this.ironUsed;
            case "gold" -> this.goldUsed;
            case "diamond" -> this.diamondUsed;
            default -> 0;
        };
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String name) {
        this.playerName = name;
    }
}

