/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.andrespr.casinorocket.games.blackjack.BlackjackRules;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class PlayerBlackjackData
extends class_18 {
    private static final String STORAGE_KEY = "casinorocket_blackjack_data";
    private final Map<UUID, Long> balances = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> betIndex = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> totalDeposited = new HashMap<UUID, Long>();
    private final Map<UUID, Long> totalWon = new HashMap<UUID, Long>();
    private final Map<UUID, Long> highestWin = new HashMap<UUID, Long>();
    private final Map<UUID, Long> lastWin = new HashMap<UUID, Long>();
    private final Map<UUID, Long> totalSpent = new HashMap<UUID, Long>();

    public static PlayerBlackjackData get(MinecraftServer server) {
        class_26 manager = Objects.requireNonNull(server.method_3847(class_1937.field_25179)).method_17983();
        class_18.class_8645 type = new class_18.class_8645(PlayerBlackjackData::new, PlayerBlackjackData::readNbt, null);
        return (PlayerBlackjackData)manager.method_17924(type, STORAGE_KEY);
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2487 balTag = new class_2487();
        this.balances.forEach((uuid, val) -> balTag.method_10544(uuid.toString(), val.longValue()));
        nbt.method_10566("balances", (class_2520)balTag);
        class_2487 betTag = new class_2487();
        this.betIndex.forEach((uuid, val) -> betTag.method_10569(uuid.toString(), val.intValue()));
        nbt.method_10566("betIndex", (class_2520)betTag);
        class_2487 depTag = new class_2487();
        this.totalDeposited.forEach((uuid, val) -> depTag.method_10544(uuid.toString(), val.longValue()));
        nbt.method_10566("totalDeposited", (class_2520)depTag);
        class_2487 wonTag = new class_2487();
        this.totalWon.forEach((uuid, val) -> wonTag.method_10544(uuid.toString(), val.longValue()));
        nbt.method_10566("totalWon", (class_2520)wonTag);
        class_2487 highTag = new class_2487();
        this.highestWin.forEach((uuid, val) -> highTag.method_10544(uuid.toString(), val.longValue()));
        nbt.method_10566("highestWin", (class_2520)highTag);
        class_2487 lastTag = new class_2487();
        this.lastWin.forEach((uuid, val) -> lastTag.method_10544(uuid.toString(), val.longValue()));
        nbt.method_10566("lastWin", (class_2520)lastTag);
        class_2487 spentTag = new class_2487();
        this.totalSpent.forEach((uuid, val) -> spentTag.method_10544(uuid.toString(), val.longValue()));
        nbt.method_10566("totalSpent", (class_2520)spentTag);
        return nbt;
    }

    private static PlayerBlackjackData readNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2487 t;
        PlayerBlackjackData data = new PlayerBlackjackData();
        if (nbt.method_10573("balances", 10)) {
            class_2487 bal = nbt.method_10562("balances");
            bal.method_10541().forEach(key -> {
                try {
                    data.balances.put(UUID.fromString(key), bal.method_10537(key));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (nbt.method_10573("betIndex", 10)) {
            t = nbt.method_10562("betIndex");
            t.method_10541().forEach(k -> {
                try {
                    data.betIndex.put(UUID.fromString(k), t.method_10550(k));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (nbt.method_10573("totalDeposited", 10)) {
            t = nbt.method_10562("totalDeposited");
            t.method_10541().forEach(k -> {
                try {
                    data.totalDeposited.put(UUID.fromString(k), t.method_10537(k));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (nbt.method_10573("totalWon", 10)) {
            t = nbt.method_10562("totalWon");
            t.method_10541().forEach(k -> {
                try {
                    data.totalWon.put(UUID.fromString(k), t.method_10537(k));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (nbt.method_10573("highestWin", 10)) {
            t = nbt.method_10562("highestWin");
            t.method_10541().forEach(k -> {
                try {
                    data.highestWin.put(UUID.fromString(k), t.method_10537(k));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (nbt.method_10573("lastWin", 10)) {
            t = nbt.method_10562("lastWin");
            t.method_10541().forEach(k -> {
                try {
                    data.lastWin.put(UUID.fromString(k), t.method_10537(k));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (nbt.method_10573("totalSpent", 10)) {
            t = nbt.method_10562("totalSpent");
            t.method_10541().forEach(k -> {
                try {
                    data.totalSpent.put(UUID.fromString(k), t.method_10537(k));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        return data;
    }

    public boolean method_79() {
        return true;
    }

    public long getBalance(UUID id) {
        return this.balances.getOrDefault(id, 0L);
    }

    public int getBetIndex(UUID id) {
        return this.betIndex.getOrDefault(id, 0);
    }

    public long getBetAmount(UUID id) {
        int index = this.getBetIndex(id);
        return BlackjackRules.BET_VALUES.get(index);
    }

    public long getTotalDeposited(UUID id) {
        return this.totalDeposited.getOrDefault(id, 0L);
    }

    public long getTotalWon(UUID id) {
        return this.totalWon.getOrDefault(id, 0L);
    }

    public long getHighestWin(UUID id) {
        return this.highestWin.getOrDefault(id, 0L);
    }

    public long getLastWin(UUID id) {
        return this.lastWin.getOrDefault(id, 0L);
    }

    public long getTotalSpent(UUID id) {
        return this.totalSpent.getOrDefault(id, 0L);
    }

    public long getTotalLost(UUID id) {
        return this.getTotalWon(id) - this.getTotalSpent(id);
    }

    public Set<UUID> getAllKnownPlayers() {
        HashSet<UUID> s = new HashSet<UUID>();
        s.addAll(this.balances.keySet());
        s.addAll(this.betIndex.keySet());
        s.addAll(this.totalDeposited.keySet());
        s.addAll(this.totalWon.keySet());
        s.addAll(this.highestWin.keySet());
        s.addAll(this.lastWin.keySet());
        s.addAll(this.totalSpent.keySet());
        return s;
    }

    public void setBalance(UUID id, long value) {
        this.balances.put(id, Math.max(0L, value));
        this.method_80();
    }

    public void setBetIndex(UUID id, int index) {
        int max = BlackjackRules.BET_VALUES.size() - 1;
        if (index < 0 || index > max) {
            return;
        }
        this.betIndex.put(id, index);
        this.method_80();
    }

    public void setLastWin(UUID id, long amount) {
        this.lastWin.put(id, Math.max(0L, amount));
        this.method_80();
    }

    public void addBalance(UUID id, long amount) {
        this.balances.merge(id, amount, Long::sum);
        if (this.balances.getOrDefault(id, 0L) < 0L) {
            this.balances.put(id, 0L);
        }
        this.method_80();
    }

    public void addTotalDeposited(UUID id, long amount) {
        if (amount <= 0L) {
            return;
        }
        this.totalDeposited.merge(id, amount, Long::sum);
        this.method_80();
    }

    public void addTotalWon(UUID id, long amount) {
        if (amount <= 0L) {
            return;
        }
        this.totalWon.merge(id, amount, Long::sum);
        this.method_80();
    }

    public void updateHighestWin(UUID id, long win) {
        if (win <= 0L) {
            return;
        }
        long prev = this.highestWin.getOrDefault(id, 0L);
        if (win > prev) {
            this.highestWin.put(id, win);
            this.method_80();
        }
    }

    public void addTotalSpent(UUID id, long amount) {
        if (amount <= 0L) {
            return;
        }
        this.totalSpent.merge(id, amount, Long::sum);
        this.method_80();
    }

    public void incrementBetIndex(UUID id) {
        int idx = this.getBetIndex(id);
        if (idx < BlackjackRules.BET_VALUES.size() - 1) {
            this.betIndex.put(id, idx + 1);
            this.method_80();
        }
    }

    public void decrementBetIndex(UUID id) {
        int idx = this.getBetIndex(id);
        if (idx > 0) {
            this.betIndex.put(id, idx - 1);
            this.method_80();
        }
    }
}

