/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.blackjack;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import net.andrespr.casinorocket.games.blackjack.BlackjackCard;
import net.andrespr.casinorocket.games.blackjack.BlackjackRank;
import net.andrespr.casinorocket.games.blackjack.BlackjackSuit;

public final class BlackjackDeck {
    private final Deque<BlackjackCard> cards = new ArrayDeque<BlackjackCard>();

    public BlackjackDeck() {
        this.resetAndShuffle();
    }

    public void resetAndShuffle() {
        this.cards.clear();
        ArrayList<BlackjackCard> temp = new ArrayList<BlackjackCard>(52);
        for (BlackjackSuit suit : BlackjackSuit.values()) {
            for (BlackjackRank rank : BlackjackRank.values()) {
                temp.add(new BlackjackCard(rank, suit));
            }
        }
        Collections.shuffle(temp);
        for (BlackjackCard card : temp) {
            this.cards.addLast(card);
        }
    }

    public BlackjackCard draw() {
        if (this.cards.isEmpty()) {
            this.resetAndShuffle();
        }
        return this.cards.removeFirst();
    }

    public int remaining() {
        return this.cards.size();
    }
}

