/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.blackjack;

import net.andrespr.casinorocket.games.blackjack.BlackjackDeck;
import net.andrespr.casinorocket.games.blackjack.BlackjackHand;
import net.andrespr.casinorocket.games.blackjack.BlackjackPhase;
import net.andrespr.casinorocket.games.blackjack.BlackjackRound;

public final class BlackjackEngine {
    private BlackjackEngine() {
    }

    public static EngineResult startRound(BlackjackRound round, BlackjackDeck deck, long bet) {
        if (bet <= 0L) {
            return EngineResult.ongoing();
        }
        round.resetForNewRound(bet);
        round.getPlayerHand().add(deck.draw());
        round.getDealerHand().add(deck.draw());
        round.getPlayerHand().add(deck.draw());
        round.getDealerHand().add(deck.draw());
        return EngineResult.ongoing();
    }

    public static EngineResult playerHit(BlackjackRound round, BlackjackDeck deck) {
        if (!round.canHit()) {
            return EngineResult.ongoing();
        }
        round.getPlayerHand().add(deck.draw());
        if (round.getPlayerHand().isBust()) {
            round.finishWithPayout(0L);
            return EngineResult.ended(0L, 0L);
        }
        return EngineResult.ongoing();
    }

    public static EngineResult playerStand(BlackjackRound round, BlackjackDeck deck) {
        if (!round.canStand()) {
            return EngineResult.ongoing();
        }
        round.setPhase(BlackjackPhase.DEALER_TURN);
        return BlackjackEngine.dealerPlayAndResolve(round, deck);
    }

    public static EngineResult playerDoubleDown(BlackjackRound round, BlackjackDeck deck, long balance) {
        long prevBet;
        if (!round.canDoubleDown(balance)) {
            return EngineResult.ongoing();
        }
        long extraCost = prevBet = round.getCurrentBet();
        long newBet = BlackjackEngine.safeMul(prevBet, 2L);
        round.setCurrentBet(newBet);
        round.getPlayerHand().add(deck.draw());
        if (round.getPlayerHand().isBust()) {
            round.finishWithPayout(0L);
            return EngineResult.ended(extraCost, 0L);
        }
        round.setPhase(BlackjackPhase.DEALER_TURN);
        EngineResult resolved = BlackjackEngine.dealerPlayAndResolve(round, deck);
        if (resolved.roundEnded()) {
            return EngineResult.ended(extraCost, resolved.payout());
        }
        return new EngineResult(extraCost, 0L, false);
    }

    private static EngineResult dealerPlayAndResolve(BlackjackRound round, BlackjackDeck deck) {
        round.revealDealerHole();
        BlackjackHand dealer = round.getDealerHand();
        BlackjackHand player = round.getPlayerHand();
        long bet = round.getCurrentBet();
        if (dealer.isNaturalBlackjack()) {
            long payout = player.isNaturalBlackjack() ? BlackjackEngine.safeMul(bet, 1L) : BlackjackEngine.safeMul(bet, 0L);
            round.finishWithPayout(payout);
            return EngineResult.ended(0L, payout);
        }
        while (BlackjackEngine.shouldDealerHit(dealer)) {
            dealer.add(deck.draw());
            if (!dealer.isBust()) continue;
        }
        long payout = BlackjackEngine.evaluatePayout(bet, player, dealer);
        round.finishWithPayout(payout);
        return EngineResult.ended(0L, payout);
    }

    private static boolean shouldDealerHit(BlackjackHand dealer) {
        if (dealer.isBust()) {
            return false;
        }
        int v = dealer.bestValue();
        if (v < 17) {
            return true;
        }
        if (v > 17) {
            return false;
        }
        if (dealer.isSoft()) {
            return false;
        }
        return false;
    }

    private static long evaluatePayout(long bet, BlackjackHand player, BlackjackHand dealer) {
        int dv;
        if (player.isBust()) {
            return BlackjackEngine.safeMul(bet, 0L);
        }
        if (dealer.isBust()) {
            return BlackjackEngine.safeMul(bet, 2L);
        }
        if (dealer.isNaturalBlackjack()) {
            return player.isNaturalBlackjack() ? BlackjackEngine.safeMul(bet, 1L) : BlackjackEngine.safeMul(bet, 0L);
        }
        if (player.isNaturalBlackjack()) {
            return BlackjackEngine.safeMul(bet, 3L);
        }
        int pv = player.bestValue();
        if (pv > (dv = dealer.bestValue())) {
            return BlackjackEngine.safeMul(bet, 2L);
        }
        if (pv == dv) {
            return BlackjackEngine.safeMul(bet, 1L);
        }
        return BlackjackEngine.safeMul(bet, 0L);
    }

    private static long safeMul(long a, long b) {
        if (a < 0L || b < 0L) {
            return 0L;
        }
        if (a == 0L || b == 0L) {
            return 0L;
        }
        if (a > Long.MAX_VALUE / b) {
            return Long.MAX_VALUE;
        }
        return a * b;
    }

    public record EngineResult(long extraCostToCharge, long payout, boolean roundEnded) {
        public static EngineResult ongoing() {
            return new EngineResult(0L, 0L, false);
        }

        public static EngineResult ended(long extraCost, long payout) {
            return new EngineResult(extraCost, payout, true);
        }
    }
}

