/*
 * Decompiled with CFR 0.152.
 */
package net.andrespr.casinorocket.games.blackjack;

import java.util.UUID;
import net.andrespr.casinorocket.data.PlayerBlackjackData;
import net.andrespr.casinorocket.games.blackjack.BlackjackAction;
import net.andrespr.casinorocket.games.blackjack.BlackjackDeck;
import net.andrespr.casinorocket.games.blackjack.BlackjackEngine;
import net.andrespr.casinorocket.games.blackjack.BlackjackPhase;
import net.andrespr.casinorocket.games.blackjack.BlackjackRound;
import net.minecraft.class_3222;

public final class BlackjackGameController {
    private final UUID playerId;
    private final PlayerBlackjackData storage;
    private final BlackjackDeck deck = new BlackjackDeck();
    private final BlackjackRound round = new BlackjackRound();
    private int resultId = 0;
    private long lastResolvedBet = 0L;
    private long lastResolvedPayout = 0L;

    public BlackjackGameController(UUID playerId, PlayerBlackjackData storage) {
        this.playerId = playerId;
        this.storage = storage;
    }

    public boolean play() {
        long bet = this.storage.getBetAmount(this.playerId);
        long balance = this.storage.getBalance(this.playerId);
        if (balance < bet) {
            return false;
        }
        this.storage.setBalance(this.playerId, balance - bet);
        this.storage.addTotalSpent(this.playerId, bet);
        BlackjackEngine.startRound(this.round, this.deck, bet);
        return true;
    }

    public void hit() {
        long betBefore = this.round.getCurrentBet();
        BlackjackEngine.EngineResult res = BlackjackEngine.playerHit(this.round, this.deck);
        if (res.roundEnded()) {
            this.storage.setLastWin(this.playerId, res.payout());
            this.setResolvedResult(betBefore, res.payout());
        }
    }

    public void stand() {
        long betBefore = this.round.getCurrentBet();
        BlackjackEngine.EngineResult res = BlackjackEngine.playerStand(this.round, this.deck);
        if (res.roundEnded()) {
            this.storage.setLastWin(this.playerId, res.payout());
            this.setResolvedResult(betBefore, res.payout());
        }
    }

    public boolean doubleDown() {
        long balance = this.storage.getBalance(this.playerId);
        long betBefore = this.round.getCurrentBet();
        BlackjackEngine.EngineResult res = BlackjackEngine.playerDoubleDown(this.round, this.deck, balance);
        if (res.extraCostToCharge() > 0L) {
            this.storage.setBalance(this.playerId, balance - res.extraCostToCharge());
            this.storage.addTotalSpent(this.playerId, res.extraCostToCharge());
        }
        if (res.roundEnded()) {
            this.storage.setLastWin(this.playerId, res.payout());
            this.setResolvedResult(betBefore + Math.max(0L, res.extraCostToCharge()), res.payout());
        }
        return res.extraCostToCharge() > 0L;
    }

    public void finish() {
        if (!this.round.canFinish()) {
            return;
        }
        long win = this.round.getWinPayout();
        long balance = this.storage.getBalance(this.playerId);
        this.storage.setBalance(this.playerId, balance + win);
        this.storage.addTotalWon(this.playerId, win);
        this.storage.setLastWin(this.playerId, win);
        this.storage.updateHighestWin(this.playerId, win);
        this.round.setPhase(BlackjackPhase.IDLE);
    }

    public boolean doubleOrNothing() {
        if (!this.round.canDoubleOrNothing()) {
            return false;
        }
        long newBet = this.round.getWinPayout();
        if (newBet <= 0L) {
            return false;
        }
        BlackjackEngine.startRound(this.round, this.deck, newBet);
        return true;
    }

    public void handleAction(class_3222 player, BlackjackAction action) {
        switch (action) {
            case PLAY: {
                this.play();
                break;
            }
            case HIT: {
                this.hit();
                break;
            }
            case STAND: {
                this.stand();
                break;
            }
            case DOUBLE_DOWN: {
                this.doubleDown();
                break;
            }
            case FINISH: {
                this.finish();
                break;
            }
            case DOUBLE_OR_NOTHING: {
                this.doubleOrNothing();
            }
        }
    }

    public BlackjackRound getRound() {
        return this.round;
    }

    public int getResultId() {
        return this.resultId;
    }

    public long getLastResolvedBet() {
        return this.lastResolvedBet;
    }

    public long getLastResolvedPayout() {
        return this.lastResolvedPayout;
    }

    private void setResolvedResult(long bet, long payout) {
        if (bet <= 0L) {
            return;
        }
        ++this.resultId;
        this.lastResolvedBet = Math.max(0L, bet);
        this.lastResolvedPayout = Math.max(0L, payout);
    }
}

